/*
 * Decompiled with CFR 0.152.
 */
package com.plushycat.essentialsxtphook;

import com.earth2me.essentials.Essentials;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class essentialstphook
extends JavaPlugin
implements Listener {
    private Essentials essentials;

    public void onEnable() {
        this.saveDefaultConfig();
        this.essentials = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
        if (this.essentials == null) {
            this.getLogger().severe("EssentialsX not found! This plugin is required.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("EssentialsXTP has been enabled and hooked into EssentialsX.");
    }

    public void onDisable() {
        this.getLogger().info("EssentialsXTP has been disabled.");
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase();
        FileConfiguration config = this.getConfig();
        if (command.startsWith("/tpa ") || command.startsWith("/tpahere ")) {
            String[] args = command.split(" ");
            if (args.length < 2) {
                return;
            }
            Player target = Bukkit.getPlayerExact((String)args[1]);
            if (target == null || !target.isOnline()) {
                return;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                TextComponent msg = new TextComponent(ChatColor.AQUA + player.getName() + " has requested to teleport to you.");
                target.spigot().sendMessage((BaseComponent)msg);
                this.playSound(target, config.getString("sounds.request"));
                TextComponent line = new TextComponent("\n");
                TextComponent accept = new TextComponent(ChatColor.GREEN + "[\u2714]");
                accept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept " + player.getName()));
                accept.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Accept teleport").create()));
                TextComponent deny = new TextComponent(ChatColor.RED + "[\u2718]");
                deny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny " + player.getName()));
                deny.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Deny teleport").create()));
                line.addExtra((BaseComponent)accept);
                line.addExtra(" ");
                line.addExtra((BaseComponent)deny);
                target.spigot().sendMessage((BaseComponent)line);
                TextComponent cancelMsg = new TextComponent(ChatColor.YELLOW + "You sent a teleport request to " + target.getName() + ". ");
                TextComponent cancel = new TextComponent(ChatColor.RED + "[\u2718]");
                cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpacancel"));
                cancel.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Cancel request").create()));
                cancelMsg.addExtra((BaseComponent)cancel);
                player.spigot().sendMessage((BaseComponent)cancelMsg);
            }, 1L);
        } else if (command.startsWith("/tpaccept ")) {
            String[] args = command.split(" ");
            if (args.length < 2) {
                this.playSound(player, config.getString("sounds.accept"));
                return;
            }
            Player sender = Bukkit.getPlayerExact((String)args[1]);
            if (sender != null && sender.isOnline()) {
                this.playSound(sender, config.getString("sounds.accept"));
            }
            this.playSound(player, config.getString("sounds.accept"));
        } else if (command.startsWith("/tpdeny ")) {
            String[] args = command.split(" ");
            if (args.length < 2) {
                this.playSound(player, config.getString("sounds.deny"));
                return;
            }
            Player sender = Bukkit.getPlayerExact((String)args[1]);
            if (sender != null && sender.isOnline()) {
                this.playSound(sender, config.getString("sounds.deny"));
            }
            this.playSound(player, config.getString("sounds.deny"));
        } else if (command.startsWith("/tpcancel")) {
            this.playSound(player, config.getString("sounds.cancel"));
        }
    }

    private void playSound(Player player, String soundName) {
        if (soundName == null || soundName.isEmpty()) {
            return;
        }
        try {
            Sound sound = Sound.valueOf((String)soundName);
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid sound name: " + soundName);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("essxtpreload")) {
            this.reloadConfig();
            sender.sendMessage(ChatColor.GREEN + "[EssentialsXTP] Config reloaded!");
            return true;
        }
        return false;
    }
}

