/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.config.FaceConfig;
import xyz.mashtoolz.custom.FaceItem;
import xyz.mashtoolz.custom.FaceSlot;
import xyz.mashtoolz.custom.FaceSlotType;

public class FaceEquipment {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    public static boolean updateCache = false;
    public static final List<FaceSlot> SLOTS = new ArrayList<FaceSlot>();
    public static final List<Integer> INDICES = new ArrayList<Integer>();
    private static final List<FaceSlotType> DUALWIELD_SLOTS = List.of(FaceSlotType.MAINHAND, FaceSlotType.OFFHAND);
    private static final List<FaceSlotType> DOUBLE_SLOTS = List.of(FaceSlotType.EARRING, FaceSlotType.RING);
    public static final List<FaceSlotType> TOOL_TYPES = List.of(FaceSlotType.PICKAXE, FaceSlotType.WOODCUTTINGAXE, FaceSlotType.HOE);
    public static class_1703 handler;

    public static FaceSlot getSlot(String id, boolean shiftDown) {
        List<FaceSlot> matches = SLOTS.stream().filter(slot -> Arrays.asList(slot.getFaceSlotType().getNames()).contains(id)).toList();
        if (matches.isEmpty()) {
            return null;
        }
        FaceSlotType slotType = matches.getFirst().getFaceSlotType();
        if (DUALWIELD_SLOTS.contains((Object)slotType) || DOUBLE_SLOTS.contains((Object)slotType)) {
            return matches.size() == 2 ? matches.get(shiftDown ? 1 : 0) : matches.getFirst();
        }
        return matches.getFirst();
    }

    public static void clearCache() {
        SLOTS.forEach(slot -> slot.setStack(class_1799.field_8037));
        FaceEquipment.INSTANCE.CONFIG.inventory.equipmentSlots.clear();
    }

    public static void updateCachedEquipment() {
        FaceEquipment.clearCache();
        int size = FaceEquipment.handler.field_7761.size();
        for (FaceSlot slot : SLOTS) {
            boolean isTool = TOOL_TYPES.contains((Object)slot.getFaceSlotType());
            int index = FaceEquipment.getSlotIndex(slot, size);
            class_1799 stack = handler.method_7611(index).method_7677();
            if (stack.method_7960()) continue;
            FaceItem item = FaceItem.from(stack);
            if (isTool && item.getFaceTool() == null || item.isInvalid()) continue;
            slot.setStack(stack);
            assert (FaceEquipment.INSTANCE.CLIENT.field_1687 != null);
            class_5455 wrapper = FaceEquipment.INSTANCE.CLIENT.field_1687.method_30349();
            class_2520 compoundTag = stack.method_57358((class_7225.class_7874)wrapper);
            String[] eqSlot = new String[]{slot.getFaceSlotType().toString(), compoundTag.method_10714()};
            FaceEquipment.INSTANCE.CONFIG.inventory.equipmentSlots.add(eqSlot);
        }
        FaceConfig.save();
    }

    private static int getSlotIndex(FaceSlot slot, int size) {
        FaceSlotType slotType = slot.getFaceSlotType();
        if (slotType.equals((Object)FaceSlotType.MAINHAND)) {
            return size - slot.getIndex() - 1;
        }
        if (TOOL_TYPES.contains((Object)slotType)) {
            return slot.getIndex() + (size - 45);
        }
        return slot.getIndex();
    }

    static {
        for (FaceSlot slot : FaceSlot.values()) {
            SLOTS.add(slot);
            for (String[] eqSlot : FaceEquipment.INSTANCE.CONFIG.inventory.equipmentSlots) {
                if (!eqSlot[0].equals(slot.getFaceSlotType().toString())) continue;
                try {
                    class_2487 compound = class_2522.method_10718((String)eqSlot[1]);
                    assert (FaceEquipment.INSTANCE.CLIENT.field_1687 != null);
                    class_5455 wrapper = FaceEquipment.INSTANCE.CLIENT.field_1687.method_30349();
                    slot.setStack(class_1799.method_57359((class_7225.class_7874)wrapper, (class_2487)compound));
                }
                catch (Exception e) {
                    FaceLift.info(true, "Failed to parse NBT for cached item: " + eqSlot[0] + "[" + eqSlot[1] + "]");
                }
            }
            INDICES.add(slot.getIndex());
        }
    }
}

