/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FaceFont {
    private static final Map<FType, Map<String, String>> MAPS = new HashMap<FType, Map<String, String>>();
    private static final String TT_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ ";
    private static final String NAME_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ'";

    public static Map<String, String> get(FType type) {
        return MAPS.get((Object)type);
    }

    public static Set<String> keys(FType type) {
        return MAPS.get((Object)type).keySet();
    }

    public static Set<Map.Entry<String, String>> entries(FType type) {
        return MAPS.get((Object)type).entrySet();
    }

    static {
        for (FType type : FType.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (FFont font : FFont.values()) {
                if (font.getType() != type) continue;
                String name = font.name();
                block10: for (int i = 0; i < font.getUnicodes().length; ++i) {
                    String unicode = font.getUnicode(i);
                    String text = font.getText(i);
                    switch (name) {
                        case "UPGRADE_NUMBERS": {
                            map.put(unicode, String.format("+%d", i + 1));
                            continue block10;
                        }
                        case "GEM_SLOTS": {
                            continue block10;
                        }
                        default: {
                            map.put(unicode, text);
                        }
                    }
                }
            }
            MAPS.put(type, map);
        }
    }

    public static enum FType {
        DAMAGE_NUMBERS,
        ITEM_TOOLTIP,
        ACTION,
        HURT_TIME,
        TOAST,
        MOB_TAG,
        CHAT_TAG;

    }

    public static enum FFont {
        DAMAGE_NUMBERS(FType.DAMAGE_NUMBERS, "\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff10", "1234567890", true),
        CHARS_1(FType.ITEM_TOOLTIP, "\u4e40\u4e41\u4e42\u4e43\u4e44\u4e45\u4e46\u4e47\u4e48\u4e49\u4e4a\u4e4b\u4e4c\u4e4d\u4e4e\u4e4f\u4e50\u4e51\u4e52\u4e53\u4e54\u4e55\u4e56\u4e57\u4e58\u4e59\u4e5a", "ABCDEFGHIJKLMNOPQRSTUVWXYZ ", true),
        CHARS_2(FType.ITEM_TOOLTIP, "\u5000\u5001\u5002\u5003\u5004\u5005\u5006\u5007\u5008\u5009\u500a\u500b\u500c\u500d\u500e\u500f\u5016\u5017\u5018\u5019\u501a\u501b\u501c\u501d\u501e\u501f\u4fff", "ABCDEFGHIJKLMNOPQRSTUVWXYZ ", true),
        CHARS_3(FType.ITEM_TOOLTIP, "\u4fd0\u4fd1\u4fd2\u4fd3\u4fd4\u4fd5\u4fd6\u4fd7\u4fd8\u4fd9\u4fda\u4fdb\u4fdc\u4fdd\u4fde\u4fdf\u4fe0\u4fe1\u4fe2\u4fe3\u4fe4\u4fe5\u4fe6\u4fe7\u4fe8\u4fe9\u4fcf", "ABCDEFGHIJKLMNOPQRSTUVWXYZ'", true),
        CHARS_4(FType.ITEM_TOOLTIP, "\u52a0\u52a1\u52a2\u52a3\u52a4\u52a5\u52a6\u52a7\u52a8\u52a9\u52aa\u52ab\u52ac\u52ad\u52ae\u52af\u52b0\u52b1\u52b2\u52b3\u52b4\u52b5\u52b6\u52b7\u52b8\u52b9\u5a71", "ABCDEFGHIJKLMNOPQRSTUVWXYZ'", true),
        UPGRADE_NUMBERS(FType.ITEM_TOOLTIP, "\u4e30\u4e31\u4e32\u4e33\u4e34\u4e35\u4e36\u4e37\u4e38\u4e39\u4e3a\u4e3b\u4e3c\u4e3d\u4e3e", null, true),
        SPACERS(FType.ITEM_TOOLTIP, "\uf802", "", true),
        DISTORTED(FType.ITEM_TOOLTIP, "\u4ffe", "Distorted"),
        ENCHANTABLE(FType.ITEM_TOOLTIP, "\u4e25", "Enchantable"),
        SOULBOUND(FType.ITEM_TOOLTIP, "\u4fce", "Soulbound"),
        GEM_SLOTS(FType.ITEM_TOOLTIP, "\u4e26\u4e27\u4e28\u4e29\u4e2a\u4e2b\u4e2c\u4e2d\u4e2e\u4e2f", new String[]{"Open", "Locked", "Filled"}),
        REQUIREMENT_NOT_MET(FType.ACTION, "\u1ce4", "Requirement not met"),
        NO_TARGET(FType.ACTION, "\u1ce2", "No Target"),
        LOW_ENERGY(FType.ACTION, "\u1ce3", "Low Energy"),
        LOW_ENERGY_JEB(FType.ACTION, "\u7823", "Low Energy"),
        ON_COOLDOWN(FType.ACTION, "\u1ce5", "On Cooldown"),
        DODGED(FType.ACTION, "\u4e1e", "Dodged"),
        BLOCKED(FType.ACTION, "\u4e1f", "Blocked"),
        HURT_TIME_1(FType.HURT_TIME, "\u4e1e", "Dodged"),
        HURT_TIME_2(FType.HURT_TIME, "\u4e1f", "Blocked"),
        OUTPOST_UNDER_ATTACK(FType.TOAST, "\u4fa0", "Outpost Under Attack"),
        COMBAT_START(FType.TOAST, "\u4fa1", "Combat Start"),
        COMBAT_END(FType.TOAST, "\u4fa2", "Exited Combat"),
        ITEM_LOW_ENCHANTMENT(FType.TOAST, "\u4fa9", "Item Low Enchantment"),
        ITEM_LOW_DURABILITY(FType.TOAST, "\u4fab", "Item Low Durability"),
        NEW_KNOWLEDGE(FType.TOAST, "\u4fa3", "New Knowledge"),
        GAINED_QUEST_POINTS(FType.TOAST, "\u4fa4", "Gained Quest Points"),
        UNSPENT_LEVEL_POINTS(FType.TOAST, "\u4fa5", "Unspent Level Points"),
        KARMA_INCREASED(FType.TOAST, "\u4fa6", "Karma Increased"),
        KARMA_DECREASED(FType.TOAST, "\u4fa7", "Karma Decreased"),
        FRIEND_REQUEST(FType.TOAST, "\u4fac", "Friend Request"),
        FAITH_RESTORED(FType.TOAST, "\u4fad", "Faith Restored"),
        ELITE(FType.MOB_TAG, "\u271c", "#B55207"),
        BOSS(FType.MOB_TAG, "\u272e", "#FC0000"),
        DANGSON(FType.CHAT_TAG, "\u8ca1", "DANGSON"),
        DANGSON_BAD(FType.CHAT_TAG, "\u3673", "DANGSON_BAD");

        private final FType type;
        private final String[] unicode;
        private final String[] text;

        private FFont(FType type, String unicode, String text) {
            this(type, unicode, text, false);
        }

        private FFont(FType type, String unicode, String[] text) {
            this.type = type;
            this.unicode = unicode.split("");
            this.text = text;
        }

        private FFont(FType type, String unicode, String text, boolean isSplit) {
            String[] stringArray;
            String[] stringArray2;
            this.type = type;
            if (isSplit) {
                stringArray2 = unicode.split("");
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = unicode;
            }
            this.unicode = stringArray2;
            if (text != null && isSplit) {
                stringArray = text.split("");
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = text;
            }
            this.text = stringArray;
        }

        public FType getType() {
            return this.type;
        }

        public String[] getUnicodes() {
            return this.unicode;
        }

        public String getUnicode(int index) {
            return this.unicode[Math.min(index, this.unicode.length - 1)];
        }

        public String getText(int index) {
            return this.text[Math.min(index, this.text.length - 1)];
        }
    }
}

