/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.custom;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.custom.FaceEquipment;
import xyz.mashtoolz.custom.FaceFont;
import xyz.mashtoolz.custom.FaceSlot;
import xyz.mashtoolz.custom.FaceTool;
import xyz.mashtoolz.custom.FaceType;
import xyz.mashtoolz.utils.TextUtils;

public class FaceItem {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    private static final ConcurrentHashMap<class_1799, FaceItem> CACHE = new ConcurrentHashMap();
    private static final List<FaceSlot> TOOL_SLOTS = Arrays.asList(FaceSlot.PICKAXE, FaceSlot.WOODCUTTINGAXE, FaceSlot.HOE);
    private static final Pattern TIER_PATTERN = Pattern.compile(".*\\b([IV]+)\\b$");
    private final class_1799 stack;
    private final String name;
    private String tooltip = null;
    private String _tooltip = null;
    private FaceType type = null;
    private FaceTool tool = null;
    private int remaining = 0;
    private int max = 0;

    public FaceItem(class_1799 stack) {
        this.stack = stack;
        this.name = stack.method_7964().getString();
        this.updatePotionValues();
    }

    public static void clearCache() {
        if (CACHE.isEmpty()) {
            return;
        }
        CACHE.clear();
    }

    public static FaceItem from(class_1799 stack) {
        return CACHE.computeIfAbsent(stack, FaceItem::new);
    }

    public boolean isInvalid() {
        return this.getFaceType().equals((Object)FaceType.UNKNOWN);
    }

    public boolean isPotion() {
        return this.max != 0;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.getTooltip(false);
    }

    public String getTooltip(boolean forceRefresh) {
        return this.getTooltip(false, forceRefresh);
    }

    private String getTooltip(boolean noParse, boolean forceRefresh) {
        if (forceRefresh || this.tooltip == null && !noParse) {
            this.tooltip = this.parseTooltip(class_437.method_25408((class_310)FaceItem.INSTANCE.CLIENT, (class_1799)this.stack), false);
        }
        if (forceRefresh || this._tooltip == null && noParse) {
            this._tooltip = this.parseTooltip(class_437.method_25408((class_310)FaceItem.INSTANCE.CLIENT, (class_1799)this.stack), true);
        }
        return noParse ? this._tooltip : this.tooltip;
    }

    public FaceType getFaceType() {
        if (this.type == null) {
            this.type = Arrays.stream(FaceType.values()).filter(r -> !r.equals((Object)FaceType.UNKNOWN) && this.getTooltip(true, false).contains(r.getUnicode())).findFirst().orElse(FaceType.UNKNOWN);
        }
        return this.type;
    }

    public FaceTool getFaceTool() {
        if (this.tool == FaceTool.BEDROCK || this.tool == null) {
            this.tool = Arrays.stream(FaceTool.values()).filter(t -> this.getTooltip().contains(t.getFaceToolType().getName())).findFirst().orElse(null);
        }
        return this.tool;
    }

    public FaceSlot getFaceSlot() {
        boolean shiftDown = class_437.method_25442();
        if (this.tool != null) {
            return TOOL_SLOTS.get(this.tool.getFaceToolType().ordinal());
        }
        String id = class_7923.field_41178.method_10221((Object)this.stack.method_7909()).toString();
        return FaceEquipment.getSlot(id, shiftDown);
    }

    public class_5251 getColor() {
        FaceType type = this.getFaceType();
        class_5251 color = type.getColor();
        if (type.equals((Object)FaceType.SOCKET_GEM)) {
            FaceType determinedType;
            String name = this.stack.method_7964().getString();
            Matcher matcher = TIER_PATTERN.matcher(name);
            FaceType faceType = determinedType = matcher.find() && matcher.groupCount() == 1 ? FaceType.fromTier(matcher.group(1)) : FaceType.UNIQUE;
            if (determinedType == null) {
                return color;
            }
            return determinedType.getColor();
        }
        return color;
    }

    private void updatePotionValues() {
        Pattern pattern = Pattern.compile("Uses: \\((\\d+)/(\\d+)\\)", 32);
        Matcher matcher = pattern.matcher(this.getTooltip(true));
        if (!matcher.find() || matcher.groupCount() != 2) {
            return;
        }
        this.remaining = Integer.parseInt(matcher.group(1));
        this.max = Integer.parseInt(matcher.group(2));
    }

    private String parseTooltip(List<class_2561> tooltip, boolean noReplace) {
        if (tooltip.size() < 2) {
            return "";
        }
        StringBuilder textBuilder = new StringBuilder(512);
        tooltip.subList(1, tooltip.size() - 1).stream().map(class_2561::getString).filter(s -> !s.isBlank()).forEach(s -> textBuilder.append((String)s).append("\n"));
        if (noReplace) {
            return textBuilder.toString();
        }
        TextUtils.replaceAll(textBuilder, FaceFont.get(FaceFont.FType.ITEM_TOOLTIP));
        TextUtils.replaceAll(textBuilder, FaceType.map());
        StringBuilder gemBuilder = new StringBuilder("\n");
        int totalSlots = 0;
        int size = FaceFont.FFont.GEM_SLOTS.getUnicodes().length;
        for (int i = 0; i < size; ++i) {
            String unicode = FaceFont.FFont.GEM_SLOTS.getUnicode(i);
            String slotText = FaceFont.FFont.GEM_SLOTS.getText(i);
            int matches = TextUtils.countMatches(textBuilder, unicode);
            if (matches <= 0) continue;
            TextUtils.replaceAll(textBuilder, unicode, "");
            gemBuilder.append(slotText).append("_Slots=").append(matches).append("\n");
            totalSlots += matches;
        }
        gemBuilder.append("Total_Slots=").append(totalSlots);
        return textBuilder.append((CharSequence)gemBuilder).toString();
    }
}

