/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_286;
import net.minecraft.class_2868;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.custom.FaceTexture;
import xyz.mashtoolz.utils.RenderUtils;

public class FaceSpell {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    private static final FaceSpell[] SPELLS = new FaceSpell[4];
    private static final class_2960[] TEXTURES = new class_2960[]{FaceTexture.SPELL_RED, FaceTexture.SPELL_YELLOW, FaceTexture.SPELL_BLUE, FaceTexture.SPELL_BLUE};
    public static float GLOBALCD = 0.0f;
    private static final int maxFrames = 10;
    private static final int animTime = 100;
    private static final int stepTime = 10;
    private static final float cooldownScale = 16.0f;
    private static final float readyScale = 20.0f;
    private final int spellIndex;
    private final class_2960 texture;
    private int lastStep = 0;
    private int damage;
    private int maxDamage;
    private float size;
    private int currentFrame;
    private long time;
    private long animationStartTime;
    private boolean isToggled;
    private boolean onCooldown;
    private int maxCharges;
    private int charges;

    public FaceSpell(class_1799 stack, int spellIndex) {
        this.spellIndex = spellIndex;
        this.damage = stack.method_7919();
        this.maxDamage = stack.method_7936();
        this.texture = TEXTURES[spellIndex];
    }

    public static FaceSpell from(class_1799 stack) {
        assert (FaceSpell.INSTANCE.CLIENT.field_1724 != null);
        int spellIndex = FaceSpell.INSTANCE.CLIENT.field_1724.method_31548().method_7395(stack);
        if (spellIndex > 3 || spellIndex < 0) {
            return null;
        }
        if (SPELLS[spellIndex] == null) {
            FaceSpell.SPELLS[spellIndex] = new FaceSpell(stack, spellIndex);
        }
        return SPELLS[spellIndex];
    }

    public void cast() {
        Objects.requireNonNull(FaceSpell.INSTANCE.CLIENT.method_1562()).method_52787((class_2596)new class_2868(this.spellIndex));
    }

    public float getSize() {
        return this.size;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public boolean isToggled() {
        return this.isToggled;
    }

    public void setToggled(boolean toggled) {
        this.isToggled = toggled;
    }

    public void update(class_332 context, class_1799 stack, int x, int y) {
        int damage = stack.method_7919();
        int maxDamage = stack.method_7936();
        int step = stack.method_31579();
        if (!this.onCooldown || maxDamage != 0 && (damage != 0 || this.lastStep == 13)) {
            this.damage = damage;
            this.maxDamage = maxDamage;
            this.lastStep = step;
            String charges = String.valueOf(stack.method_7914());
            String[] chargeParts = charges.split("");
            if (chargeParts.length == 2) {
                this.maxCharges = Integer.parseInt(chargeParts[0]);
                this.charges = Integer.parseInt(chargeParts[1]);
            }
        }
        if (this.isToggled()) {
            return;
        }
        if (this.maxCharges > 1 && FaceSpell.INSTANCE.CONFIG.inventory.hotbar.useCustom) {
            int emptyCharges = this.maxCharges - this.charges;
            if (this.onCooldown) {
                context.method_51433(FaceSpell.INSTANCE.CLIENT.field_1772, "\u260a".repeat(this.charges) + "\u260b".repeat(emptyCharges), x, y - 54, 0xFFFFFF, false);
            } else {
                context.method_51433(FaceSpell.INSTANCE.CLIENT.field_1772, "\u260a".repeat(this.charges) + "\u260b".repeat(emptyCharges), x - 2, y - 56, 0xFFFFFF, false);
            }
        }
        this.drawCooldown(context, x, y);
    }

    private void drawCooldown(class_332 context, int x, int y) {
        float percent = 1.0f - (float)this.damage / (float)this.maxDamage;
        int size = FaceSpell.INSTANCE.CONFIG.inventory.hotbar.useCustom ? (int)this.getSize() : 16;
        int offset = (size - 16) / 2;
        int centerX = x + size / 2 - offset;
        int centerY = y + size / 2 - offset;
        int numSegments = 128;
        float step = (-360.0f + 360.0f * percent) / (float)numSegments;
        class_4587 matrices = context.method_51448();
        RenderSystem.setShader(class_757::method_34540);
        RenderUtils.enableBlend();
        context.method_44379(x - offset, y - offset, x + size - offset, y + size - offset);
        matrices.method_46416(0.0f, 0.0f, 400.0f);
        class_289 tessellator = class_289.method_1348();
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        class_287 builder = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        for (int i = 0; i <= numSegments; ++i) {
            float angle1 = -90.0f + (float)i * step;
            float angle2 = -90.0f + (float)(i + 1) * step;
            double rad1 = Math.toRadians(angle1);
            double rad2 = Math.toRadians(angle2);
            float x1 = (float)centerX + 14.0f * (float)Math.cos(rad1);
            float y1 = (float)centerY + 14.0f * (float)Math.sin(rad1);
            float x2 = (float)centerX + 14.0f * (float)Math.cos(rad2);
            float y2 = (float)centerY + 14.0f * (float)Math.sin(rad2);
            builder.method_22918(matrix, (float)centerX, (float)centerY, 0.0f).method_1336(0, 0, 0, 192);
            builder.method_22918(matrix, x1, y1, 0.0f).method_1336(0, 0, 0, 192);
            builder.method_22918(matrix, x2, y2, 0.0f).method_1336(0, 0, 0, 192);
        }
        class_286.method_43433((class_9801)builder.method_60800());
        context.method_44380();
        matrices.method_46416(0.0f, 0.0f, -400.0f);
    }

    public void animate(class_332 context, class_1799 stack) {
        GLOBALCD = FaceSpell.INSTANCE.CLIENT.field_1724 == null ? 0.0f : FaceSpell.INSTANCE.CLIENT.field_1724.method_7357().method_7905(stack.method_7909(), FaceSpell.INSTANCE.CLIENT.method_60646().method_60637(true));
        boolean cooldown = 1.0f - (float)this.damage / (float)this.maxDamage != 1.0f;
        boolean onCooldown = !this.isToggled() && GLOBALCD != 0.0f || cooldown;
        long currentTime = System.currentTimeMillis();
        if (this.maxCharges > 1 && this.charges > 0 || GLOBALCD != 0.0f && !cooldown) {
            onCooldown = false;
        }
        if (onCooldown) {
            if (!this.onCooldown) {
                this.animationStartTime = currentTime;
                this.onCooldown = true;
                this.isToggled = false;
            }
            if (!FaceSpell.INSTANCE.CONFIG.inventory.hotbar.useCustom) {
                this.size = 16.0f;
            } else if (this.isToggled()) {
                this.size = 20.0f;
            } else {
                long timeSinceAnimationStart = currentTime - this.animationStartTime;
                if (timeSinceAnimationStart >= 100L) {
                    this.size = 16.0f;
                } else {
                    float progress = (float)timeSinceAnimationStart / 100.0f;
                    this.size = 20.0f - 4.0f * progress;
                }
            }
        } else {
            if (this.onCooldown) {
                this.animationStartTime = currentTime;
                this.onCooldown = false;
            }
            if (!FaceSpell.INSTANCE.CONFIG.inventory.hotbar.useCustom) {
                this.size = 16.0f;
            } else if (this.isToggled()) {
                this.size = 20.0f;
            } else {
                long timeSinceAnimationStart = currentTime - this.animationStartTime;
                if (timeSinceAnimationStart >= 100L) {
                    this.size = 20.0f;
                } else {
                    float progress = (float)timeSinceAnimationStart / 100.0f;
                    this.size = 16.0f + 4.0f * progress;
                }
            }
        }
        if (currentTime - this.time >= 10L) {
            this.time = currentTime;
            this.currentFrame = (this.currentFrame + 1) % 10;
        }
        context.method_51448().method_22905(this.size, -this.size, 16.0f);
    }
}

