/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.config.FaceConfig;

public final class FaceStatus
extends Enum<FaceStatus> {
    public static final /* enum */ FaceStatus WELL_RESTED = new FaceStatus(12000, class_4081.field_18271);
    public static final /* enum */ FaceStatus ESCAPE_COOLDOWN = new FaceStatus(6000, class_4081.field_18273);
    public static final /* enum */ FaceStatus CURSE_STACK = new FaceStatus(-1, class_4081.field_18272);
    private static final FaceLift INSTANCE;
    private static final List<FaceStatus> EFFECTS;
    private final int duration;
    private final FaceStatusEffect effect;
    private static final /* synthetic */ FaceStatus[] $VALUES;

    public static FaceStatus[] values() {
        return (FaceStatus[])$VALUES.clone();
    }

    public static FaceStatus valueOf(String name) {
        return Enum.valueOf(FaceStatus.class, name);
    }

    private FaceStatus(int duration, class_4081 category) {
        this.duration = duration;
        this.effect = new FaceStatusEffect(category, 0, this);
    }

    public FaceStatusEffect getEffect() {
        return this.effect;
    }

    public void applyEffect() {
        FaceStatus.applyEffect(this, this.duration);
        FaceStatus.INSTANCE.CONFIG.general.statusEffects.put(this, System.currentTimeMillis());
        FaceConfig.save();
    }

    private static void applyEffect(FaceStatus status, int duration) {
        if (status.equals((Object)CURSE_STACK)) {
            duration = -1;
        }
        FaceStatusEffectInstance effect = new FaceStatusEffectInstance(status, status.getEffect().getEntry(), duration, 0, false, false, true);
        assert (FaceStatus.INSTANCE.CLIENT.field_1724 != null);
        FaceStatus.INSTANCE.CLIENT.field_1724.method_6092((class_1293)effect);
    }

    public void removeEffect() {
        assert (FaceStatus.INSTANCE.CLIENT.field_1724 != null);
        FaceStatus.INSTANCE.CLIENT.field_1724.method_6016(this.getEffect().getEntry());
        FaceStatus.INSTANCE.CONFIG.general.statusEffects.remove((Object)this);
        FaceConfig.save();
    }

    public static void getDescription(class_1293 statusEffect, CallbackInfoReturnable<class_2561> cir) {
        if (!(statusEffect instanceof FaceStatusEffectInstance)) {
            return;
        }
        FaceStatusEffectInstance faceStatusEffect = (FaceStatusEffectInstance)statusEffect;
        switch (faceStatusEffect.getFaceStatus().ordinal()) {
            case 2: {
                cir.setReturnValue((Object)class_2561.method_30163((String)("Curse Stacks: " + FaceStatus.INSTANCE.CONFIG.general.curseStacks)));
                break;
            }
        }
    }

    public static String getDuration(class_1293 statusEffect) {
        if (statusEffect.method_48559()) {
            return class_1074.method_4662((String)"effect.duration.infinite", (Object[])new Object[0]);
        }
        int ticks = class_3532.method_15375((float)statusEffect.method_5584());
        int seconds = ticks / 20;
        if (seconds >= 3600) {
            return seconds / 3600 + "h";
        }
        if (seconds >= 60) {
            return seconds / 60 + "m";
        }
        return seconds + "s";
    }

    public static void registerEffects() {
        for (FaceStatus status : FaceStatus.values()) {
            EFFECTS.add(status);
            class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)class_2960.method_60655((String)"facelift", (String)status.name().toLowerCase()), (Object)((Object)status.getEffect()));
        }
    }

    public static void update() {
        class_746 player = FaceStatus.INSTANCE.CLIENT.field_1724;
        if (player == null) {
            return;
        }
        for (Map.Entry<FaceStatus, Long> entry : FaceStatus.INSTANCE.CONFIG.general.statusEffects.entrySet()) {
            FaceStatus status = entry.getKey();
            Long startTime = entry.getValue();
            long elapsedTime = (System.currentTimeMillis() - startTime) / 1000L;
            int remainingTicks = (int)((long)(status.duration / 20) - elapsedTime) * 20;
            class_1293 statusEffect = player.method_6112(status.getEffect().getEntry());
            if (statusEffect != null) continue;
            FaceStatus.applyEffect(status, remainingTicks);
        }
        block4: for (FaceStatus faceStatus : EFFECTS) {
            class_1293 statusEffect = player.method_6112(faceStatus.getEffect().getEntry());
            if (statusEffect == null) {
                if (!faceStatus.equals((Object)CURSE_STACK) || FaceStatus.INSTANCE.CONFIG.general.curseStacks <= 0) continue;
                faceStatus.applyEffect();
                continue;
            }
            FaceStatusEffect effect = (FaceStatusEffect)((Object)statusEffect.method_5579().comp_349());
            switch (effect.getFaceStatus().ordinal()) {
                case 2: {
                    if (FaceStatus.INSTANCE.CONFIG.general.curseStacks > 0) continue block4;
                    faceStatus.removeEffect();
                    continue block4;
                }
            }
            if (statusEffect.method_5584() > 0) continue;
            faceStatus.removeEffect();
        }
    }

    private static /* synthetic */ FaceStatus[] $values() {
        return new FaceStatus[]{WELL_RESTED, ESCAPE_COOLDOWN, CURSE_STACK};
    }

    static {
        $VALUES = FaceStatus.$values();
        INSTANCE = FaceLift.getInstance();
        EFFECTS = new ArrayList<FaceStatus>();
    }

    public static class FaceStatusEffect
    extends class_1291 {
        private final FaceStatus status;

        protected FaceStatusEffect(class_4081 category, int color, FaceStatus status) {
            super(category, color);
            this.status = status;
        }

        public FaceStatus getFaceStatus() {
            return this.status;
        }

        public class_6880<class_1291> getEntry() {
            return class_7923.field_41174.method_47983((Object)this);
        }
    }

    public static class FaceStatusEffectInstance
    extends class_1293 {
        private final FaceStatus faceStatus;

        public FaceStatusEffectInstance(FaceStatus status, class_6880<class_1291> effect, int duration, int amplifier, boolean ambient, boolean visible, boolean showParticles) {
            super(effect, duration, amplifier, ambient, visible, showParticles);
            this.faceStatus = status;
        }

        public FaceStatus getFaceStatus() {
            return this.faceStatus;
        }
    }
}

