/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.custom;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2868;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_634;
import net.minecraft.class_746;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.config.FaceConfig;
import xyz.mashtoolz.custom.FaceItem;
import xyz.mashtoolz.custom.FaceTexture;
import xyz.mashtoolz.custom.FaceToolType;
import xyz.mashtoolz.utils.PlayerUtils;

public class FaceTool {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    public static final FaceTool PICKAXE = new FaceTool(FaceToolType.PICKAXE, FaceTool.INSTANCE.CONFIG.inventory.autoTool.PICKAXE, FaceTexture.EMPTY_PICKAXE);
    public static final FaceTool WOODCUTTINGAXE = new FaceTool(FaceToolType.WOODCUTTINGAXE, FaceTool.INSTANCE.CONFIG.inventory.autoTool.WOODCUTTINGAXE, FaceTexture.EMPTY_WOODCUTTINGAXE);
    public static final FaceTool HOE = new FaceTool(FaceToolType.HOE, FaceTool.INSTANCE.CONFIG.inventory.autoTool.HOE, FaceTexture.EMPTY_HOE);
    public static final FaceTool BEDROCK = new FaceTool(FaceToolType.BEDROCK, -1, null);
    private final FaceToolType type;
    private int slotIndex;
    private final class_2960 texture;

    private FaceTool(FaceToolType type, int slotIndex, class_2960 texture) {
        this.type = type;
        this.slotIndex = slotIndex;
        this.texture = texture;
    }

    public FaceToolType getFaceToolType() {
        return this.type;
    }

    public void setSlotIndex(int slotIndex) {
        this.slotIndex = slotIndex;
        this.updateConfig();
    }

    private void updateConfig() {
        FaceConfig.Inventory.AutoTool autoTool = FaceTool.INSTANCE.CONFIG.inventory.autoTool;
        switch (this.type) {
            case PICKAXE: {
                autoTool.PICKAXE = this.slotIndex;
                break;
            }
            case WOODCUTTINGAXE: {
                autoTool.WOODCUTTINGAXE = this.slotIndex;
                break;
            }
            case HOE: {
                autoTool.HOE = this.slotIndex;
                break;
            }
        }
        FaceConfig.save();
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public static FaceTool[] values() {
        return new FaceTool[]{PICKAXE, WOODCUTTINGAXE, HOE, BEDROCK};
    }

    public static FaceTool getByType(FaceToolType type) {
        for (FaceTool tool : FaceTool.values()) {
            if (!tool.type.equals((Object)type)) continue;
            return tool;
        }
        return null;
    }

    public static void update() {
        class_310 client = FaceTool.INSTANCE.CLIENT;
        class_746 player = client.field_1724;
        assert (player != null);
        class_1661 inventory = player.method_31548();
        int hotbarSlot = inventory.field_7545;
        class_1799 mainHandStack = player.method_6047();
        class_243 eyePos = player.method_33571();
        double reach = player.method_55754();
        class_243 rayEnd = eyePos.method_1019(player.method_5720().method_1021(reach));
        assert (client.field_1687 != null);
        class_3965 blockHitResult = client.field_1687.method_17742(new class_3959(eyePos, rayEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        FaceItem faceItem = FaceItem.from(mainHandStack);
        String tooltip = faceItem.isInvalid() ? null : faceItem.getTooltip();
        FaceTool currentTool = FaceTool.getCurrentToolFromTooltip(tooltip);
        FaceTool targetTool = PlayerUtils.getTargetTool(blockHitResult, mainHandStack);
        if (targetTool != null && targetTool.getFaceToolType().equals((Object)FaceToolType.BEDROCK)) {
            return;
        }
        class_634 networkHandler = Objects.requireNonNull(FaceTool.INSTANCE.CLIENT.method_1562());
        networkHandler.method_52787((class_2596)new class_2868(hotbarSlot != 8 ? 8 : 5));
        if (tooltip == null || currentTool == null) {
            FaceTool.handleNullTool(targetTool, hotbarSlot, inventory);
            networkHandler.method_52787((class_2596)new class_2868(hotbarSlot));
            return;
        }
        FaceTool.handleToolSwap(targetTool, currentTool, hotbarSlot, inventory);
        networkHandler.method_52787((class_2596)new class_2868(hotbarSlot));
    }

    private static FaceTool getCurrentToolFromTooltip(String tooltip) {
        if (tooltip == null) {
            return null;
        }
        for (FaceTool tool : FaceTool.values()) {
            if (!tooltip.contains(tool.getFaceToolType().getName())) continue;
            return tool;
        }
        return null;
    }

    private static void handleNullTool(FaceTool targetTool, int hotbarSlot, class_1661 inventory) {
        if (targetTool != null && !inventory.method_5438(targetTool.getSlotIndex()).method_7960()) {
            PlayerUtils.clickSlot(targetTool.getSlotIndex(), hotbarSlot, class_1713.field_7791);
        }
    }

    private static void handleToolSwap(FaceTool targetTool, FaceTool currentTool, int hotbarSlot, class_1661 inventory) {
        boolean isCurrentToolSlotEmpty = inventory.method_5438(currentTool.getSlotIndex()).method_7960();
        if (targetTool == null) {
            if (isCurrentToolSlotEmpty) {
                FaceTool.swap(hotbarSlot, currentTool);
            } else {
                PlayerUtils.clickSlot(currentTool.getSlotIndex(), hotbarSlot, class_1713.field_7791);
            }
            return;
        }
        if (currentTool.getFaceToolType().equals((Object)targetTool.getFaceToolType())) {
            return;
        }
        if (isCurrentToolSlotEmpty) {
            FaceTool.swap(hotbarSlot, currentTool);
            PlayerUtils.clickSlot(targetTool.getSlotIndex(), hotbarSlot, class_1713.field_7791);
        } else {
            PlayerUtils.clickSlot(currentTool.getSlotIndex(), hotbarSlot, class_1713.field_7791);
            PlayerUtils.clickSlot(targetTool.getSlotIndex(), hotbarSlot, class_1713.field_7791);
        }
    }

    private static void swap(int hotbarSlot, FaceTool tool) {
        PlayerUtils.clickSlot(36 + hotbarSlot, 0, class_1713.field_7790);
        PlayerUtils.clickSlot(tool.getSlotIndex(), 0, class_1713.field_7790);
    }
}

