/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.custom;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_5251;

public enum FaceType {
    UNKNOWN("Unknown", "\ufffd", 0),
    CRAFTED("Crafted", "\u4fcc", 16766018),
    COMMON("Common", "\u4e20", 0xFFFBF3, "I"),
    UNCOMMON("Uncommon", "\u4e3f", 3115233, "II"),
    RARE("Rare", "\u4e5b", 10895305, "III"),
    EPIC("Epic", "\u4e5c", 16530744, "IV"),
    UNIQUE("Unique", "\u4e5e", 16286764),
    DIVINE("Divine", "\u4e5d", 16760778),
    PAWN_1("Pawn", "\u4fcd", 12879872),
    PAWN_2("Pawn", "\u61d3", 0xCFCFCF),
    TRIBUTE("Tribute", "\u61da", 42191),
    IDOL("Idol", "\u61db", 13660391),
    SOCKET_GEM("Socket Gem", "\u4e08", 3513888),
    SOUL_GEM("Soul Gem", "\u4fca", 13660391),
    ITEM("Item", "\u5a70", 42191),
    POTION("Potion", "\u4e0b", 15167635),
    FOOD("Food", "\u0538", 8862476),
    TOME("Tome", "\u4e0d", 1273806),
    ESSENCE("Essence", "\u4e07", 3192545),
    EXTENDER("Extender", "\u4e09", 40577),
    SCROLL("Scroll", "\u4e0a", 8021463),
    PURITY("Purity Scroll", "\u4e0e", 0xE4E4E4),
    PET("Pet", "\u4fc8", 6151726),
    MOUNT("Mount", "\u4fc9", 8996910),
    UNCOMMON_UPGRADE("Item Upgrade (Uncommon)", "\u4fcb", 3434183),
    RARE_UPGRADE("Item Upgrade (Rare)", "\u4e0f", 9255603),
    EPIC_UPGRADE("Item Upgrade (Epic)", "\u4e0c", 12130858),
    MATERIAL_1("Material", "\u4e01", 15510870),
    MATERIAL_2("Material", "\u4e02", 15510870),
    MATERIAL_3("Material", "\u4e03", 15510870),
    MATERIAL_4("Material", "\u4e04", 15510870),
    MATERIAL_5("Material", "\u4e05", 15510870),
    COSMIC_QUARTER("Cosmic Quarter", "\u4e22", 3022405);

    private final String text;
    private final String unicode;
    private final class_5251 color;
    private final String tier;

    private FaceType(String text, String unicode, int color) {
        this(text, unicode, color, "");
    }

    private FaceType(String text, String unicode, int color, String tier) {
        this.text = text;
        this.unicode = unicode;
        this.color = class_5251.method_27717((int)color);
        this.tier = tier;
    }

    public static FaceType fromUnicode(String unicode) {
        return Arrays.stream(FaceType.values()).filter(type -> type.unicode.equals(unicode)).findFirst().orElse(null);
    }

    public static FaceType fromColor(class_5251 color) {
        return Arrays.stream(FaceType.values()).filter(type -> type.color.equals((Object)color)).findFirst().orElse(null);
    }

    public static FaceType fromTier(String tier) {
        return Arrays.stream(FaceType.values()).filter(type -> type.tier.equals(tier)).findFirst().orElse(null);
    }

    public static FaceType fromName(String name) {
        return Arrays.stream(FaceType.values()).filter(type -> type.toString().equals(name)).findFirst().orElse(null);
    }

    public String getText() {
        return this.text;
    }

    public String getUnicode() {
        return this.unicode;
    }

    public class_5251 getColor() {
        return this.color;
    }

    public String getString() {
        return this.toString();
    }

    public static Map<String, String> map() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (FaceType type : FaceType.values()) {
            if (type.equals((Object)UNKNOWN)) continue;
            map.put(type.getUnicode(), type.getText());
        }
        return map;
    }
}

