/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.mixins.InGameHudAccessor;
import xyz.mashtoolz.structs.RegexPattern;
import xyz.mashtoolz.utils.RenderUtils;
import xyz.mashtoolz.utils.TimeUtils;

public class ArenaTimer {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    private static final List<Wave> WAVES = new ArrayList<Wave>();
    private static final RegexPattern[] REGEXES = new RegexPattern[]{new RegexPattern("subtitle.waveStart", "Wave (\\d+) has begun!"), new RegexPattern("title.waveEnd", "WAVE VANQUISHED!"), new RegexPattern("title.arenaEnd", "ARENA ENDED!"), new RegexPattern("title.arenaEnd", "ARENA COMPLETE!")};
    private static boolean active = false;
    private static boolean paused = false;

    public static boolean isActive() {
        return active;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static void start() {
        WAVES.clear();
        active = true;
        paused = true;
    }

    public static void end() {
        active = false;
        paused = false;
    }

    public static void startWave() {
        WAVES.add(new Wave(System.currentTimeMillis()));
        paused = false;
    }

    public static void endWave() {
        Wave currentWave = WAVES.getLast();
        currentWave.setEndTime(System.currentTimeMillis());
        paused = true;
    }

    public static long getWaveTime(int index) {
        Wave wave = WAVES.get(index);
        long endTime = wave.getEndTime();
        return endTime > 0L ? endTime - wave.getStartTime() : System.currentTimeMillis() - wave.getStartTime();
    }

    public static long getCurrentWaveTime() {
        return WAVES.isEmpty() || paused ? 0L : ArenaTimer.getWaveTime(WAVES.size() - 1);
    }

    public static long getTotalTime() {
        return System.currentTimeMillis() - WAVES.getFirst().getStartTime();
    }

    public static void updateTimer() {
        InGameHudAccessor inGameHud = (InGameHudAccessor)ArenaTimer.INSTANCE.CLIENT.field_1705;
        if (inGameHud == null) {
            return;
        }
        class_2561 title = inGameHud.getTitle();
        if (title == null) {
            return;
        }
        class_5250 subtitle = inGameHud.getSubtitle() != null ? inGameHud.getSubtitle() : class_2561.method_43473();
        block10: for (RegexPattern regex : REGEXES) {
            String[] parts = regex.getKey().split("\\.");
            String type = parts[0];
            String key = parts[1];
            String text = type.equals("title") ? title.getString() : subtitle.getString();
            Matcher match = regex.getPattern().matcher(text);
            if (!match.find()) continue;
            switch (key) {
                case "waveStart": {
                    if (!ArenaTimer.isActive()) {
                        ArenaTimer.start();
                    }
                    if (!ArenaTimer.isPaused()) continue block10;
                    ArenaTimer.startWave();
                    continue block10;
                }
                case "waveEnd": {
                    if (!ArenaTimer.isActive() || ArenaTimer.isPaused()) continue block10;
                    ArenaTimer.endWave();
                    continue block10;
                }
                case "arenaEnd": {
                    if (!ArenaTimer.isActive()) continue block10;
                    ArenaTimer.end();
                }
            }
        }
    }

    public static void draw(class_332 context) {
        if (!ArenaTimer.isActive()) {
            return;
        }
        long totalTime = ArenaTimer.getTotalTime();
        long currentWaveTime = ArenaTimer.getCurrentWaveTime();
        String totalStr = ArenaTimer.formatTime(totalTime);
        String waveStr = ArenaTimer.formatTime(currentWaveTime);
        int x = ArenaTimer.INSTANCE.CONFIG.combat.arenaTimer.position.x;
        int y = ArenaTimer.INSTANCE.CONFIG.combat.arenaTimer.position.y;
        context.method_25294(x, y, x + 112, y + RenderUtils.h(2) + 2, Integer.MIN_VALUE);
        RenderUtils.drawTextWithShadow(context, "\u00a73Arena Timer", x + 5, y + 5);
        RenderUtils.drawTextWithShadow(context, "<#FDFDFD>" + totalStr, x + 107 - ArenaTimer.INSTANCE.CLIENT.field_1772.method_1727(totalStr), y + 5);
        RenderUtils.drawTextWithShadow(context, "\u00a7bWave Timer", x + 5, y + 15);
        RenderUtils.drawTextWithShadow(context, "<#FDFDFD>" + waveStr, x + 107 - ArenaTimer.INSTANCE.CLIENT.field_1772.method_1727(waveStr), y + 15);
    }

    private static String formatTime(long time) {
        long[] hms = TimeUtils.timeToHMS(time);
        return String.format("%02d:%02d.%d", hms[1], hms[2], hms[3]);
    }

    private static class Wave {
        private final long start;
        private long end;

        public Wave(long start) {
            this.start = start;
            this.end = 0L;
        }

        public long getStartTime() {
            return this.start;
        }

        public long getEndTime() {
            return this.end;
        }

        public void setEndTime(long end) {
            this.end = end;
        }
    }
}

