/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.displays;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_332;
import net.minecraft.class_8113;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.custom.FaceFont;
import xyz.mashtoolz.utils.ColorUtils;
import xyz.mashtoolz.utils.NumberUtils;
import xyz.mashtoolz.utils.RenderUtils;

public class DPSMeter {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    public static final Map<String, class_8113.class_8123> TEXT_DISPLAYS = new HashMap<String, class_8113.class_8123>();
    private static long startTime = 0L;
    private static long lastHitTime = 0L;
    private static int damage = 0;
    private static int hits = 0;

    public static long getStartTime() {
        return startTime;
    }

    public static long getLastHitTime() {
        return lastHitTime;
    }

    public static void addDamage(int damage) {
        if (startTime == 0L) {
            startTime = System.currentTimeMillis();
        }
        lastHitTime = System.currentTimeMillis();
        DPSMeter.damage += damage;
        ++hits;
    }

    public static void reset() {
        startTime = 0L;
        damage = 0;
        hits = 0;
    }

    public static int getDPS() {
        long elapsedTime = System.currentTimeMillis() - startTime;
        return startTime == 0L || elapsedTime == 0L ? 0 : Math.round((float)damage / ((float)elapsedTime / 1000.0f));
    }

    public static Integer parseDamage(String text) {
        String numericString = text.chars().mapToObj(c -> String.valueOf((char)c)).filter(c -> FaceFont.keys(FaceFont.FType.DAMAGE_NUMBERS).contains(c)).collect(Collectors.joining());
        return numericString.isEmpty() ? 0 : Integer.parseInt(numericString);
    }

    public static void draw(class_332 context) {
        boolean ignoreTimer;
        long remaining = (long)DPSMeter.INSTANCE.CONFIG.combat.dpsMeter.duration - (System.currentTimeMillis() - DPSMeter.getLastHitTime());
        if (DPSMeter.getStartTime() == 0L) {
            return;
        }
        boolean bl = ignoreTimer = DPSMeter.INSTANCE.CONFIG.combat.dpsMeter.duration == -1;
        if (remaining <= 0L && !ignoreTimer) {
            DPSMeter.reset();
            return;
        }
        String damageFormat = NumberUtils.format(damage);
        String hitsFormat = NumberUtils.format(hits);
        String dpsFormat = NumberUtils.format(DPSMeter.getDPS());
        int x = DPSMeter.INSTANCE.CONFIG.combat.dpsMeter.position.x;
        int y = DPSMeter.INSTANCE.CONFIG.combat.dpsMeter.position.y;
        context.method_25294(x, y, x + 112, y + RenderUtils.h(5) + 2, Integer.MIN_VALUE);
        RenderUtils.drawTextWithShadow(context, "\u00a7cDPS Meter", x + 5, y + 5);
        if (!ignoreTimer && DPSMeter.INSTANCE.CONFIG.combat.dpsMeter.showTimebar) {
            RenderUtils.drawTimeBar(context, x, y, (int)remaining, DPSMeter.INSTANCE.CONFIG.combat.dpsMeter.duration, ColorUtils.hex2Int("FD3434", 144));
        }
        int[] yOffsets = new int[]{25, 35, 45};
        DPSMeter.drawStats(context, "Damage", damageFormat, x, y + yOffsets[0]);
        DPSMeter.drawStats(context, "Hits", hitsFormat, x, y + yOffsets[1]);
        DPSMeter.drawStats(context, "DPS", dpsFormat, x, y + yOffsets[2]);
    }

    private static void drawStats(class_332 context, String label, String value, int x, int y) {
        int valueWidth = DPSMeter.INSTANCE.CLIENT.field_1772.method_1727(value);
        RenderUtils.drawTextWithShadow(context, "<#FFB2CC>" + label + " <#FDFDFD>", x + 5, y);
        RenderUtils.drawTextWithShadow(context, "<#FDFDFD>" + value, x + 112 - valueWidth - 5, y);
    }

    public static void update() {
        Iterator<class_8113.class_8123> iterator = TEXT_DISPLAYS.values().iterator();
        while (iterator.hasNext()) {
            class_8113.class_8123 entity = iterator.next();
            if (entity.method_49784() == null || entity.method_49784().comp_1334() == null) continue;
            String text = entity.method_49784().comp_1334().getString();
            int damage = DPSMeter.parseDamage(text);
            if (damage > 0) {
                DPSMeter.addDamage(damage);
            }
            iterator.remove();
        }
    }
}

