/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.displays;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_332;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.config.FaceConfig;
import xyz.mashtoolz.utils.ColorUtils;
import xyz.mashtoolz.utils.NumberUtils;
import xyz.mashtoolz.utils.RenderUtils;

public class XPDisplay {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    public static Map<String, XPDisplay> DISPLAYS = new HashMap<String, XPDisplay>();
    public static XPDisplay lastDisplay;
    private final String key;
    private String color;
    private int xp;
    private int lastXp;
    private long time;
    private long totalTime;
    private boolean visible;

    public XPDisplay(String key, String color, int amount, long time, boolean visible) {
        this.key = key;
        this.color = color;
        this.xp = amount;
        this.time = time;
        this.visible = visible;
        this.totalTime = 0L;
    }

    public String getKey() {
        return this.key;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public int getXP() {
        return this.xp;
    }

    public void setXP(int amount) {
        this.lastXp = this.xp;
        this.xp = amount;
    }

    public int getGain() {
        return this.xp - this.lastXp;
    }

    public long getTotalTime() {
        return System.currentTimeMillis() - this.totalTime;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        if (this.totalTime == 0L && time > 0L) {
            this.totalTime = time;
        }
        this.time = time;
        lastDisplay = this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void reset() {
        this.setXP(0);
        this.setVisible(false);
        this.totalTime = 0L;
    }

    public static void draw(class_332 context) {
        if (lastDisplay == null) {
            return;
        }
        FaceConfig.General.XPDisplay config = XPDisplay.INSTANCE.CONFIG.general.xpDisplay;
        boolean ignoreTimer = config.duration == -1;
        long remaining = (long)config.duration - (System.currentTimeMillis() - lastDisplay.getTime());
        if (remaining <= 0L && !ignoreTimer) {
            if (lastDisplay.getXP() != 0) {
                lastDisplay.reset();
            }
            return;
        }
        int height = DISPLAYS.values().stream().filter(display -> display.getXP() > 0).mapToInt(display -> 10).sum();
        int x = config.position.x;
        int y = config.position.y;
        context.method_25294(x, y, x + 112, y + height + RenderUtils.h(2) + 2, Integer.MIN_VALUE);
        RenderUtils.drawTextWithShadow(context, "\u00a7aXP Display", x + 5, y + 5);
        if (!ignoreTimer && config.showTimebar) {
            RenderUtils.drawTimeBar(context, x, y, (int)remaining, config.duration, ColorUtils.hex2Int("34FD34", 144));
        }
        int i = 0;
        for (XPDisplay display2 : DISPLAYS.values()) {
            if (!display2.draw(context, x, y, i, ignoreTimer)) continue;
            ++i;
        }
    }

    public boolean draw(class_332 context, int x, int y, int i, boolean ignoreTimer) {
        if (this.getXP() == 0) {
            return false;
        }
        if (this.isVisible() && this.getTime() + (long)XPDisplay.INSTANCE.CONFIG.general.xpDisplay.duration < System.currentTimeMillis() && !ignoreTimer) {
            this.reset();
            return false;
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        String skill = this.getColor() + this.getKey();
        String xpFormatted = NumberUtils.format(this.getXP());
        String gain = XPDisplay.INSTANCE.CONFIG.general.xpDisplay.showLastGain ? "  +" + NumberUtils.format(this.getGain()) : "";
        RenderUtils.drawTextWithShadow(context, skill, x + 5, y + 25 + i * 10);
        FaceConfig.General.XPDisplay.DisplayType type = XPDisplay.INSTANCE.CONFIG.general.xpDisplay.displayType;
        double perN = (double)this.getTotalTime() / (60000.0 * (double)(type == FaceConfig.General.XPDisplay.DisplayType.PER_HOUR ? 60 : 1));
        if (type != FaceConfig.General.XPDisplay.DisplayType.DEFAULT) {
            xpFormatted = NumberUtils.format((int)((double)this.getXP() / perN));
        }
        RenderUtils.drawTextWithShadow(context, "<#FDFDFD>" + xpFormatted + gain, x + 107 - XPDisplay.INSTANCE.CLIENT.field_1772.method_1727(xpFormatted), y + 25 + i * 10);
        return true;
    }
}

