/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.handlers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.config.FaceConfig;
import xyz.mashtoolz.custom.FaceStatus;
import xyz.mashtoolz.displays.TeleportBar;
import xyz.mashtoolz.displays.XPDisplay;
import xyz.mashtoolz.structs.RegexPattern;
import xyz.mashtoolz.utils.ColorUtils;
import xyz.mashtoolz.utils.TextUtils;

public class ChatHandler {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    private static final Pattern CURSE_STACK_PATTERN = Pattern.compile("You have (\\d+) curse stacks");
    private static final RegexPattern[] XP_REGEXES = new RegexPattern[]{new RegexPattern("skillXP", "Gained (\\w+ ?){1,2} XP! \\(\\+(\\d+)XP\\)"), new RegexPattern("combatXP", "\\+(\\d+)XP")};

    public static void addMessage(class_2561 text, CallbackInfo ci) {
        String message = text.getString().replaceAll("[.,]", "");
        if (TextUtils.escapeStringToUnicode(message, false).startsWith("\\uf804")) {
            return;
        }
        if (ChatHandler.INSTANCE.CONFIG.general.xpDisplay.enabled) {
            ChatHandler.handleXPMessage(text, message, ci);
        }
        switch (message.trim()) {
            case "RISE AND SHINE! You're well rested and had a pretty good meal!": {
                FaceStatus.WELL_RESTED.applyEffect();
                break;
            }
            case "Teleport started! You will be teleported in 10 seconds!": {
                TeleportBar.start(10500, "Escaping");
                break;
            }
            case "Teleport cancelled!": {
                TeleportBar.stop();
                break;
            }
            case "Whoosh!": {
                FaceStatus.ESCAPE_COOLDOWN.applyEffect();
                break;
            }
            case "Your curse has been broken!": {
                ChatHandler.INSTANCE.CONFIG.general.curseStacks = 0;
                FaceConfig.save();
                break;
            }
            default: {
                Matcher curse_matcher = CURSE_STACK_PATTERN.matcher(message);
                if (!curse_matcher.find()) break;
                ChatHandler.INSTANCE.CONFIG.general.curseStacks = Integer.parseInt(curse_matcher.group(1));
                FaceConfig.save();
            }
        }
    }

    private static void handleXPMessage(class_2561 text, String message, CallbackInfo ci) {
        for (RegexPattern regex : XP_REGEXES) {
            Matcher match = regex.getPattern().matcher(message);
            if (!match.find()) continue;
            ci.cancel();
            String key = regex.getKey().equals("combatXP") ? "Combat" : match.group(1);
            String xpValue = regex.getKey().equals("combatXP") ? match.group(1) : match.group(2);
            String color = regex.getKey().equals("combatXP") ? "<#8AF828>" : ColorUtils.getTextColor(text);
            ChatHandler.handleXP(key, xpValue, color);
            return;
        }
    }

    private static void handleXP(String key, String xpValue, String color) {
        XPDisplay display = XPDisplay.DISPLAYS.computeIfAbsent(key, k -> new XPDisplay((String)k, color, 0, System.currentTimeMillis(), false));
        display.setXP(display.getXP() + Integer.parseInt(xpValue));
        display.setTime(System.currentTimeMillis());
        display.setColor(color);
    }
}

