/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.config.FaceConfig;
import xyz.mashtoolz.config.Keybinds;
import xyz.mashtoolz.custom.FaceEquipment;
import xyz.mashtoolz.custom.FaceFont;
import xyz.mashtoolz.custom.FaceItem;
import xyz.mashtoolz.custom.FaceSpell;
import xyz.mashtoolz.custom.FaceStatus;
import xyz.mashtoolz.custom.FaceTexture;
import xyz.mashtoolz.custom.FaceTool;
import xyz.mashtoolz.custom.FaceType;
import xyz.mashtoolz.displays.ArenaTimer;
import xyz.mashtoolz.displays.CombatTimer;
import xyz.mashtoolz.displays.DPSMeter;
import xyz.mashtoolz.displays.TeleportBar;
import xyz.mashtoolz.displays.XPDisplay;
import xyz.mashtoolz.interfaces.EntityInterface;
import xyz.mashtoolz.mixins.HandledScreenAccessor;
import xyz.mashtoolz.mixins.InGameHudAccessor;
import xyz.mashtoolz.mixins.ScreenAccessor;
import xyz.mashtoolz.utils.ColorUtils;
import xyz.mashtoolz.utils.RenderUtils;
import xyz.mashtoolz.widget.DropDownMenu;
import xyz.mashtoolz.widget.SearchFieldWidget;

public class RenderHandler {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    private static final class_310 CLIENT = RenderHandler.INSTANCE.CLIENT;
    private static final FaceConfig CONFIG = RenderHandler.INSTANCE.CONFIG;
    public static SearchFieldWidget SEARCHBAR;
    private static DropDownMenu DROPDOWN;
    private static int GLINT_FRAME;
    private static long GLINT_TIME;
    public static final List<class_1792> ABILITY_ITEMS;
    public static final List<class_1792> IGNORED_ITEMS;
    public static final List<class_1792> HIDDEN_ITEMS;

    public static void afterInitScreen(class_310 client, class_437 screen, int width, int height) {
        if (!(screen instanceof class_465)) {
            return;
        }
        FaceItem.clearCache();
        String title = screen.method_25440().getString();
        if (title.contains("\u5e93")) {
            FaceEquipment.updateCache = true;
        }
        RenderHandler.setupSearchBar(client, width, height);
        RenderHandler.setupDropdownMenu(screen, width, height);
        ((ScreenAccessor)screen).invokeAddDrawableChild(SEARCHBAR);
        ((ScreenAccessor)screen).invokeAddDrawableChild(DROPDOWN.getButton());
    }

    private static void setupSearchBar(class_310 client, int width, int height) {
        FaceConfig.Inventory inventory = RenderHandler.CONFIG.inventory;
        SEARCHBAR = new SearchFieldWidget(client.field_1772, width / 2 - 90, height - 25, 180, 20, SEARCHBAR, (class_2561)class_2561.method_43470((String)inventory.searchbar.query));
        SEARCHBAR.method_1852(inventory.searchbar.query);
        SEARCHBAR.method_1880(255);
        SEARCHBAR.method_1863(text -> {
            inventory.searchbar.query = text;
            FaceConfig.save();
        });
        if (inventory.searchbar.highlight) {
            RenderHandler.SEARCHBAR.highlighted = true;
            SEARCHBAR.method_1868(0xFFFF78);
        }
    }

    private static void setupDropdownMenu(class_437 screen, int width, int height) {
        FaceConfig.Inventory inventory = RenderHandler.CONFIG.inventory;
        DROPDOWN = new DropDownMenu(screen, "Options", width / 2 + 95, height - 25, 120, 20, true);
        DROPDOWN.addButton("Case-Sensitive: " + inventory.searchbar.caseSensitive, button -> {
            inventory.searchbar.caseSensitive = !inventory.searchbar.caseSensitive;
            button.method_25355((class_2561)class_2561.method_43470((String)(" Case-Sensitive: " + inventory.searchbar.caseSensitive)));
            FaceConfig.save();
        });
    }

    public static void onHudRender(class_332 context, class_9779 tickCounter) {
        if (!FaceConfig.General.onFaceLand) {
            return;
        }
        if (!(FaceEquipment.updateCache || FaceEquipment.handler == null || RenderHandler.CLIENT.field_1755 != null && RenderHandler.CLIENT.field_1755.method_25440().getString().contains("\u5e93"))) {
            FaceEquipment.updateCachedEquipment();
            FaceEquipment.handler = null;
        }
        if (RenderHandler.CLIENT.field_1755 == null) {
            SEARCHBAR = null;
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        if (RenderHandler.CONFIG.combat.combatTimer.enabled) {
            CombatTimer.draw(context);
        }
        if (RenderHandler.CONFIG.combat.dpsMeter.enabled) {
            DPSMeter.draw(context);
        }
        if (RenderHandler.CONFIG.combat.arenaTimer.enabled) {
            ArenaTimer.updateTimer();
            ArenaTimer.draw(context);
        }
        if (RenderHandler.CONFIG.general.xpDisplay.enabled) {
            XPDisplay.draw(context);
        }
        if (RenderHandler.CONFIG.general.teleportBar.enabled) {
            TeleportBar.draw(context);
        }
        matrices.method_22909();
    }

    public static void renderOverlayMessage(class_329 inGameHud) {
        if (!FaceConfig.General.onFaceLand || !RenderHandler.CONFIG.inventory.hotbar.useCustom) {
            return;
        }
        InGameHudAccessor hud = (InGameHudAccessor)inGameHud;
        if (hud.getOverlayMessage() != null) {
            class_2561 originalText = hud.getOverlayMessage();
            class_5250 replacedText = class_2561.method_43470((String)"");
            for (class_2561 sibling : originalText.method_10855()) {
                class_5250 text = class_2561.method_43470((String)sibling.getString().replaceAll("\u260a", "\uf823").replaceAll("\u260b", "\uf823")).method_10862(sibling.method_10866());
                replacedText.method_10852((class_2561)text);
            }
            hud.setOverlayMessage((class_2561)replacedText);
        }
    }

    public static void drawStatusEffectOverlay(class_332 context, class_1293 statusEffectInstance, int x, int y) {
        Object duration = FaceStatus.getDuration(statusEffectInstance);
        String color = "<#D1D1D1>";
        if (statusEffectInstance instanceof FaceStatus.FaceStatusEffectInstance) {
            FaceStatus.FaceStatusEffectInstance faceStatusEffect = (FaceStatus.FaceStatusEffectInstance)statusEffectInstance;
            switch (faceStatusEffect.getFaceStatus()) {
                case CURSE_STACK: {
                    duration = "" + RenderHandler.CONFIG.general.curseStacks;
                    color = "<#FD3434>";
                    break;
                }
            }
        }
        int durationLength = RenderHandler.CLIENT.field_1772.method_1727((String)duration);
        RenderUtils.drawTextWithShadow(context, color + (String)duration, x + 13 - durationLength / 2, y + 14);
    }

    public static void beforeEntities(WorldRenderContext context) {
        if (!FaceConfig.General.onFaceLand) {
            return;
        }
        class_638 world = context.world();
        world.method_18112().forEach(entity -> {
            if (entity.method_31481() || !entity.method_5805() || !entity.method_5709() || entity.method_5864().equals(class_1299.field_6131)) {
                return;
            }
            class_2561 text = entity.method_5797();
            if (text == null || text.equals((Object)class_2561.field_25310)) {
                return;
            }
            List list = text.method_10855();
            if (list.size() < 3) {
                return;
            }
            EntityInterface flEntity = (EntityInterface)entity;
            String tag = ((class_2561)list.getFirst()).getString().trim();
            int forceGlowingValue = 2;
            boolean tagFound = false;
            Optional<Map.Entry> optionalEntry = FaceFont.entries(FaceFont.FType.MOB_TAG).stream().filter(e -> ((String)e.getKey()).equals(tag)).findFirst();
            if (optionalEntry.isPresent()) {
                Map.Entry entry = optionalEntry.get();
                flEntity.FL_setGlowingColor(ColorUtils.hex2Int((String)entry.getValue(), 255));
                tagFound = true;
            }
            if (!tagFound) {
                class_5251 color = ((class_2561)list.getFirst()).method_10866().method_10973();
                if (color != null) {
                    flEntity.FL_setGlowingColor(ColorUtils.hex2Int(color.method_27723(), 255));
                } else {
                    forceGlowingValue = 1;
                }
            }
            flEntity.FL_setForceGlowing(forceGlowingValue);
        });
    }

    public static void onHandledScreenRender(class_332 context, int mouseX, int mouseY) {
        if (!FaceConfig.General.onFaceLand || !(RenderHandler.CLIENT.field_1755 instanceof class_465)) {
            return;
        }
        HandledScreenAccessor screen = (HandledScreenAccessor)RenderHandler.CLIENT.field_1755;
        Object handler = screen.getHandler();
        if (handler == null) {
            return;
        }
        if (FaceEquipment.updateCache && RenderHandler.CLIENT.field_1755.method_25440().getString().contains("\u5e93")) {
            FaceEquipment.updateCache = false;
            FaceEquipment.handler = handler;
        }
        if (Keybinds.isPressed(Keybinds.COMPARE_TOOLTIP)) {
            RenderUtils.compareAndRenderTooltip(screen, context, mouseX, mouseY);
        }
    }

    public static void onHandledScreenKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (SEARCHBAR != null && SEARCHBAR.method_25370()) {
            class_315 options = RenderHandler.INSTANCE.CLIENT.field_1690;
            ArrayList<class_304> keys = new ArrayList<class_304>(List.of(options.field_1822, options.field_1869, options.field_1871));
            keys.addAll(Arrays.asList(options.field_1852));
            if (keys.stream().anyMatch(key -> key.method_1417(keyCode, scanCode))) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    public static void drawItem(class_332 context, @Nullable class_1309 entity, @Nullable class_1937 world, class_1799 stack, int x, int y, int seed, int z, CallbackInfo ci) {
        if (!stack.method_7960()) {
            class_4587 matrices = context.method_51448();
            class_1087 bakedModel = CLIENT.method_1480().method_4019(stack, world, entity, seed);
            matrices.method_22903();
            matrices.method_46416((float)(x + 8), (float)(y + 8), (float)(150 + (bakedModel.method_4712() ? z : 0)));
            try {
                boolean bl;
                boolean isSpell = ABILITY_ITEMS.contains(stack.method_7909());
                if (isSpell && !(RenderHandler.CLIENT.field_1755 instanceof class_465)) {
                    FaceSpell spell = FaceSpell.from(stack);
                    if (spell == null) {
                        return;
                    }
                    spell.animate(context, stack);
                } else {
                    matrices.method_22905(16.0f, -16.0f, 16.0f);
                }
                boolean bl2 = bl = !bakedModel.method_24304();
                if (bl) {
                    class_308.method_24210();
                }
                if (isSpell) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(FaceSpell.GLOBALCD != 0.0f ? 0.35f : 1.0f));
                }
                CLIENT.method_1480().method_23179(stack, class_811.field_4317, false, matrices, (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, bakedModel);
                context.method_51452();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (bl) {
                    class_308.method_24211();
                }
            }
            catch (Throwable var12) {
                class_128 crashReport = class_128.method_560((Throwable)var12, (String)"Rendering item");
                class_129 crashReportSection = crashReport.method_562("Item being rendered");
                crashReportSection.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
                crashReportSection.method_577("Item Components", () -> String.valueOf(stack.method_57353()));
                crashReportSection.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
                throw new class_148(crashReport);
            }
            matrices.method_22909();
        }
        ci.cancel();
    }

    public static void renderHotbar(class_329 inGameHud, class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (!FaceConfig.General.onFaceLand) {
            return;
        }
        boolean customHotbar = RenderHandler.CONFIG.inventory.hotbar.useCustom;
        InGameHudAccessor hud = (InGameHudAccessor)inGameHud;
        class_4587 matrices = context.method_51448();
        class_1657 player = hud.invokeGetCameraPlayer();
        if (player != null) {
            int m;
            class_1799 itemStack = player.method_6079();
            class_1306 arm = player.method_6068().method_5928();
            int i = context.method_51421() / 2;
            int j = context.method_51443();
            RenderSystem.enableBlend();
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, -90.0f);
            matrices.method_22905(1.0f, 1.0f, 1.0f);
            context.method_25290(customHotbar ? FaceTexture.CUSTOM_HOTBAR : FaceTexture.HOTBAR, i - 91, j - 22, 0.0f, 0.0f, 182, 22, 182, 22);
            class_1661 inventory = player.method_31548();
            int selectedSlot = inventory.field_7545;
            if (!customHotbar) {
                context.method_52706(hud.hotbarSelectionTexture(), i - 91 - 1 + selectedSlot * 20, j - 23, 24, 23);
            } else if (selectedSlot >= 4 && selectedSlot <= 8) {
                int visualIndex = selectedSlot - 4;
                context.method_52706(hud.hotbarSelectionTexture(), i - 91 - 1 + 30 + visualIndex * 25, j - 23, 24, 23);
            }
            if (!itemStack.method_7960()) {
                if (arm == class_1306.field_6182) {
                    context.method_52706(hud.hotbarOffhandLeftTexture(), i - 91 - 29, j - 23, 29, 24);
                } else {
                    context.method_52706(hud.hotbarOffhandRightTexture(), i + 91, j - 23, 29, 24);
                }
            }
            matrices.method_22909();
            RenderSystem.disableBlend();
            int l = 1;
            for (m = 0; m < 9; ++m) {
                class_1799 mStack = (class_1799)player.method_31548().field_7547.get(m);
                if (customHotbar) {
                    boolean isSpellSlot = m < 4;
                    int x = isSpellSlot ? i - 90 + 42 + m * 25 + 2 + RenderHandler.CONFIG.inventory.hotbar.offset.x : i - 90 + 30 + (m - 4) * 25 + 2;
                    int y = isSpellSlot ? j / 2 + RenderHandler.CONFIG.inventory.hotbar.offset.y : j - 16 - 3;
                    hud.invokeRenderHotbarItem(context, x, y, tickCounter, player, mStack, l++);
                    continue;
                }
                int n = i - 90 + m * 20 + 2;
                int o = context.method_51443() - 16 - 3;
                hud.invokeRenderHotbarItem(context, n, o, tickCounter, player, mStack, l++);
            }
            if (!itemStack.method_7960()) {
                m = j - 16 - 3;
                if (arm == class_1306.field_6182) {
                    hud.invokeRenderHotbarItem(context, i - 91 - 26, m, tickCounter, player, itemStack, l++);
                } else {
                    hud.invokeRenderHotbarItem(context, i + 91 + 10, m, tickCounter, player, itemStack, l++);
                }
            }
            if (RenderHandler.INSTANCE.CLIENT.field_1690.method_42565().method_41753() == class_4061.field_18153) {
                RenderSystem.enableBlend();
                assert (RenderHandler.INSTANCE.CLIENT.field_1724 != null);
                float f = RenderHandler.INSTANCE.CLIENT.field_1724.method_7261(0.0f);
                if (f < 1.0f) {
                    int n = j - 20;
                    int o = i + 91 + 6;
                    if (arm == class_1306.field_6183) {
                        o = i - 91 - 22;
                    }
                    int p = (int)(f * 19.0f);
                    context.method_52706(hud.hotbarAttackIndicatorBackgroundTexture(), o, n, 18, 18);
                    context.method_52708(hud.hotbarAttackIndicatorProgressTexture(), 18, 18, 0, 18 - p, o, n + 18 - p, 18, p);
                }
                RenderSystem.disableBlend();
            }
        }
        ci.cancel();
    }

    public static void drawSlot_start(class_332 context, class_1735 slot, CallbackInfo ci) {
        if (!FaceConfig.General.onFaceLand) {
            return;
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        RenderUtils.enableBlend();
        int x = slot.field_7873;
        int y = slot.field_7872;
        class_1799 stack = slot.method_7677();
        boolean hideItem = false;
        if (stack.method_7960() || IGNORED_ITEMS.contains(stack.method_7909())) {
            RenderHandler.renderToolSlot(context, slot, x, y);
        } else {
            FaceItem item = FaceItem.from(stack);
            hideItem = RenderHandler.searchbarCheck(item);
            RenderHandler.renderNormalItem(context, matrices, item, x, y, hideItem);
        }
        RenderUtils.disableBlend();
        matrices.method_22909();
        if (hideItem && HIDDEN_ITEMS.contains(stack.method_7909())) {
            ci.cancel();
        }
    }

    public static void drawItemInSlot(class_332 context, class_1799 stack, int x, int y, @Nullable String countOverride, CallbackInfo ci) {
        boolean hasEnchantment;
        if (!FaceConfig.General.onFaceLand || !ABILITY_ITEMS.contains(stack.method_7909())) {
            return;
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        RenderUtils.enableBlend();
        FaceSpell spell = FaceSpell.from(stack);
        boolean bl = hasEnchantment = !stack.method_58657().method_57543();
        if (spell != null) {
            if (spell.isToggled() && !hasEnchantment || !spell.isToggled() && hasEnchantment) {
                spell.setToggled(hasEnchantment);
            }
            spell.update(context, stack, x, y);
            int size = (int)spell.getSize() + 2;
            int offset = (size - 16) / 2;
            context.method_25290(spell.getTexture(), x - offset, y - offset, 0.0f, 0.0f, size, size, size, size);
        }
        if (hasEnchantment) {
            RenderHandler.drawGlintAnimation(context, stack, x, y);
        }
        RenderUtils.disableBlend();
        matrices.method_22909();
        if (!stack.method_7960()) {
            matrices.method_22903();
            if (stack.method_7947() != 1 || countOverride != null) {
                String string = countOverride == null ? String.valueOf(stack.method_7947()) : countOverride;
                matrices.method_46416(0.0f, 0.0f, 200.0f);
                context.method_51433(RenderHandler.CLIENT.field_1772, string, x + 19 - 2 - RenderHandler.CLIENT.field_1772.method_1727(string), y + 6 + 3, 0xFFFFFF, true);
                matrices.method_46416(0.0f, 0.0f, -200.0f);
            }
            if (stack.method_31578()) {
                int i = stack.method_31579();
                int j = stack.method_31580();
                int k = x + 2;
                int l = y + 13;
                context.method_51739(class_1921.method_51785(), k, l, k + 13, l + 2, -16777216);
                context.method_51739(class_1921.method_51785(), k, l, k + i, l + 1, j | 0xFF000000);
            }
            matrices.method_22909();
        }
        ci.cancel();
    }

    private static boolean searchbarCheck(FaceItem item) {
        if (SEARCHBAR == null || !RenderHandler.SEARCHBAR.highlighted) {
            return false;
        }
        String query = SEARCHBAR.method_1882();
        if (query.isEmpty()) {
            return true;
        }
        String name = item.getName();
        if (name.equalsIgnoreCase("air")) {
            return true;
        }
        String tooltip = item.getTooltip();
        try {
            Pattern pattern = Pattern.compile(query, 0x20 | (RenderHandler.CONFIG.inventory.searchbar.caseSensitive ? 0 : 2));
            if (!pattern.matcher(tooltip).find() && !pattern.matcher(name).find()) {
                return true;
            }
            SEARCHBAR.method_1868(0xFFFF78);
        }
        catch (PatternSyntaxException e) {
            SEARCHBAR.method_1868(0xFF7878);
        }
        return false;
    }

    private static void drawGlintAnimation(class_332 context, class_1799 stack, int x, int y) {
        boolean onCooldown;
        FaceSpell spell = FaceSpell.from(stack);
        class_4587 matrices = context.method_51448();
        int size = 16;
        float f = RenderHandler.CLIENT.field_1724 == null ? 0.0f : RenderHandler.CLIENT.field_1724.method_7357().method_7905(stack.method_7909(), CLIENT.method_60646().method_60637(true));
        boolean bl = onCooldown = f != 0.0f || 1.0f - (float)stack.method_7919() / (float)stack.method_7936() != 1.0f;
        int iSize = RenderHandler.CLIENT.field_1755 instanceof class_465 || !RenderHandler.CONFIG.inventory.hotbar.useCustom ? 16 : (spell != null && spell.isToggled() ? 20 : (onCooldown ? 16 : 20));
        int iOffset = (iSize - size) / 2;
        int maxFrames = 960 / size;
        int stepTime = 1200 / maxFrames;
        matrices.method_46416(0.0f, 0.0f, 400.0f);
        context.method_25294(x - iOffset, y - iOffset, x + iSize - iOffset, y + iSize - iOffset, ColorUtils.hex2Int("#000000", 120));
        RenderSystem.setShaderTexture((int)0, (class_2960)FaceTexture.ABILITY_GLINT);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        context.method_25293(FaceTexture.ABILITY_GLINT, x - iOffset + 1, y - iOffset + 1, iSize - 2, iSize - 2, (float)(GLINT_FRAME * size), 0.0f, size, size, maxFrames * size, size);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_25293(FaceTexture.ABILITY_GLINT, x - iOffset, y - iOffset, iSize, iSize, (float)(GLINT_FRAME * size), 0.0f, size, size, maxFrames * size, size);
        matrices.method_46416(0.0f, 0.0f, -400.0f);
        if (System.currentTimeMillis() - GLINT_TIME >= (long)stepTime) {
            GLINT_TIME = System.currentTimeMillis();
            GLINT_FRAME = (GLINT_FRAME + 1) % maxFrames;
        }
    }

    private static void renderToolSlot(class_332 context, class_1735 slot, int x, int y) {
        if (!RenderHandler.CONFIG.inventory.autoTool.enabled) {
            return;
        }
        HandledScreenAccessor screen = (HandledScreenAccessor)RenderHandler.CLIENT.field_1755;
        assert (screen != null);
        Object handler = screen.getHandler();
        if (((class_1703)handler).field_7761.size() == 46 && !RenderHandler.CLIENT.field_1755.method_25440().getString().isEmpty()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            for (FaceTool tool : FaceTool.values()) {
                if (slot.field_7874 != tool.getSlotIndex()) continue;
                RenderSystem.setShaderTexture((int)0, (class_2960)tool.getTexture());
                context.method_25290(tool.getTexture(), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                break;
            }
        }
    }

    private static void renderNormalItem(class_332 context, class_4587 matrices, FaceItem item, int x, int y, boolean hideItem) {
        if (!RenderHandler.CONFIG.inventory.itemColors.enabled) {
            return;
        }
        FaceType type = item.getFaceType();
        class_5251 color = item.getColor();
        if (color == null || type.equals((Object)FaceType.UNKNOWN)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(hideItem ? 0.25f : 1.0f));
            return;
        }
        float[] rgb = ColorUtils.getRGB(color);
        float opacity = hideItem ? 0.25f : RenderHandler.CONFIG.inventory.itemColors.opacity;
        matrices.method_46416(0.0f, 0.0f, 100.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)FaceTexture.ITEM_GLOW);
        RenderSystem.setShaderColor((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)opacity);
        if (RenderHandler.CONFIG.inventory.itemColors.useTexture) {
            context.method_25290(FaceTexture.ITEM_GLOW, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            context.method_49601(x, y, 16, 16, ColorUtils.hex2Int("#FFFFFF", 255));
        }
        matrices.method_46416(0.0f, 0.0f, -100.0f);
        if (type.getString().startsWith("MATERIAL_")) {
            int stars = Integer.parseInt(type.getString().split("_")[1]);
            matrices.method_46416(0.0f, 0.0f, 300.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)FaceTexture.ITEM_STAR);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_25290(FaceTexture.ITEM_STAR, x, y, 0.0f, 0.0f, 3 * stars, 3, 3, 3);
            matrices.method_46416(0.0f, 0.0f, -300.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(hideItem ? 0.25f : 1.0f));
    }

    static {
        GLINT_FRAME = 0;
        GLINT_TIME = System.currentTimeMillis();
        ABILITY_ITEMS = Arrays.asList(class_1802.field_8058, class_1802.field_8678);
        IGNORED_ITEMS = Arrays.asList(class_1802.field_8077, class_1802.field_8523, class_1802.field_8873, class_1802.field_8575, class_1802.field_8077);
        HIDDEN_ITEMS = Arrays.asList(class_1802.field_8255, class_1802.field_8366, class_1802.field_8276, class_1802.field_17532);
    }
}

