/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import xyz.mashtoolz.FaceLift;
import xyz.mashtoolz.custom.FaceItem;
import xyz.mashtoolz.custom.FaceSlot;
import xyz.mashtoolz.mixins.HandledScreenAccessor;
import xyz.mashtoolz.utils.ColorUtils;
import xyz.mashtoolz.utils.ItemUtils;

public class RenderUtils {
    private static final FaceLift INSTANCE = FaceLift.getInstance();
    private static final Pattern COLOR_PATTERN = Pattern.compile("<#([A-Fa-f0-9]{6,8})>");
    private static final int DEFAULT_COLOR = 0xD1D1D1;

    public static void drawTextWithShadow(class_332 context, String text, int x, int y) {
        Matcher matcher = COLOR_PATTERN.matcher(text);
        int color = 0xD1D1D1;
        int lastEnd = 0;
        while (matcher.find()) {
            String segment = text.substring(lastEnd, matcher.start());
            context.method_25303(RenderUtils.INSTANCE.CLIENT.field_1772, segment, x, y, color);
            x += RenderUtils.INSTANCE.CLIENT.field_1772.method_1727(segment);
            String group = matcher.group(1);
            String hex = group.length() == 8 ? group.substring(2, 8) : group.substring(0, 6);
            int opacity = group.length() == 8 ? Math.max(4, Math.min(255, Integer.parseInt(group.substring(0, 2), 16))) : 255;
            color = ColorUtils.hex2Int(hex, opacity);
            lastEnd = matcher.end();
        }
        if (lastEnd < text.length()) {
            context.method_25303(RenderUtils.INSTANCE.CLIENT.field_1772, text.substring(lastEnd), x, y, color);
        }
    }

    public static void drawTimeBar(class_332 context, int x, int y, int remaining, int max, int color) {
        int barWidth = Math.min(x + 6 + Math.round((float)(remaining * 101) / (float)max), x + 107);
        int colorWithAlpha = ColorUtils.hex2Int("D1D1D1", 64);
        context.method_25294(x + 5, y + 15, x + 107, y + 22, colorWithAlpha);
        context.method_25294(x + 6, y + 16, x + 106, y + 21, colorWithAlpha);
        context.method_25294(x + 6, y + 16, barWidth, y + 21, color);
    }

    public static int h(int n) {
        return 10 * n + 5;
    }

    public static void enableBlend() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public static void disableBlend() {
        RenderSystem.disableBlend();
    }

    public static void drawTooltip(class_332 context, class_1799 stack, int mouseX, int mouseY) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        RenderSystem.disableDepthTest();
        List text = stack.method_7950(class_1792.class_9635.field_51353, (class_1657)RenderUtils.INSTANCE.CLIENT.field_1724, (class_1836)(RenderUtils.INSTANCE.CLIENT.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070));
        List<class_5684> components = text.stream().map(class_2561::method_30937).map(class_5684::method_32662).toList();
        int maxWidth = components.stream().mapToInt(c -> c.method_32664(RenderUtils.INSTANCE.CLIENT.field_1772)).max().orElse(0);
        context.method_51437(RenderUtils.INSTANCE.CLIENT.field_1772, text, stack.method_32347(), mouseX - maxWidth - 25, mouseY);
        RenderSystem.enableDepthTest();
        matrices.method_22909();
    }

    public static void compareAndRenderTooltip(HandledScreenAccessor screen, class_332 context, int mouseX, int mouseY) {
        class_1735 focusedSlot = screen.getFocusedSlot();
        if (focusedSlot == null || focusedSlot.method_7677().method_7960()) {
            return;
        }
        FaceItem focusedItem = FaceItem.from(focusedSlot.method_7677());
        if (focusedItem.isInvalid()) {
            return;
        }
        FaceSlot compareSlot = focusedItem.getFaceSlot();
        if (compareSlot == null) {
            return;
        }
        class_1799 compareStack = compareSlot.getStack();
        if (compareStack.method_7960() || ItemUtils.compareStacks(focusedSlot.method_7677(), compareStack)) {
            return;
        }
        RenderUtils.drawTooltip(context, compareStack, mouseX, mouseY);
    }
}

