/*
 * Decompiled with CFR 0.152.
 */
package xyz.mashtoolz.utils;

import java.util.Map;

public class TextUtils {
    public static String escapeStringToUnicode(String input, boolean removeUnicode) {
        StringBuilder builder = new StringBuilder(input.length());
        for (char ch : input.toCharArray()) {
            if (ch < '\u0080') {
                builder.append(ch);
                continue;
            }
            if (removeUnicode) continue;
            builder.append("\\u").append(String.format("%04x", ch));
        }
        return builder.toString();
    }

    public static void replaceAll(StringBuilder builder, String key, String value) {
        int index;
        while ((index = builder.indexOf(key)) != -1) {
            builder.replace(index, index + key.length(), value);
        }
    }

    public static <T> void replaceAll(StringBuilder builder, Map<String, T> replacements) {
        TextUtils.replaceAll(builder, replacements, "", "");
    }

    public static <T> void replaceAll(StringBuilder builder, Map<String, T> replacements, String prefix, String suffix) {
        for (Map.Entry<String, T> entry : replacements.entrySet()) {
            int index;
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            while ((index = builder.indexOf(key)) != -1) {
                builder.replace(index, index + key.length(), prefix + value + suffix);
            }
        }
    }

    public static int countMatches(StringBuilder builder, String key) {
        int matches = 0;
        int index = 0;
        while ((index = builder.indexOf(key, index)) != -1) {
            ++matches;
            index += key.length();
        }
        return matches;
    }
}

