/*
 * Decompiled with CFR 0.152.
 */
package com.kasetoatz.superenchants.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2960;

public class Config {
    public static boolean BOW_ENCHANTS_UNNERF = true;
    public static boolean CROSSBOW_ENCHANTS_UNNERF = true;
    public static boolean ARMOR_ENCHANTS_UNNERF = true;
    public static boolean TOOL_ENCHANTS_UNNERF = true;
    public static boolean ENABLE_CHANNELING_2 = true;
    public static boolean LOYALTY_VOID_PROTECTION = true;
    public static boolean DISABLE_SOUL_SPEED_DAMAGE = true;
    public static boolean DISABLE_THORNS_DAMAGE = true;
    public static boolean ENABLE_INFINITY_WITHOUT_ARROW = true;
    public static boolean ENABLE_CROSSBOW_INFINITY = true;
    public static boolean TRIDENT_RETURN_TO_SAME_SLOT = true;
    public static boolean ENABLE_CUSTOM_ENCHANT_LEVELS = true;
    public static Map<class_2960, Integer> LEVELS = new HashMap<class_2960, Integer>(Map.ofEntries(Map.entry(class_2960.method_60654((String)"minecraft:unbreaking"), 5), Map.entry(class_2960.method_60654((String)"minecraft:thorns"), 5), Map.entry(class_2960.method_60654((String)"minecraft:respiration"), 5), Map.entry(class_2960.method_60654((String)"minecraft:swift_sneak"), 5), Map.entry(class_2960.method_60654((String)"minecraft:feather_falling"), 10), Map.entry(class_2960.method_60654((String)"minecraft:soul_speed"), 5), Map.entry(class_2960.method_60654((String)"minecraft:protection"), 10), Map.entry(class_2960.method_60654((String)"minecraft:projectile_protection"), 10), Map.entry(class_2960.method_60654((String)"minecraft:fire_protection"), 10), Map.entry(class_2960.method_60654((String)"minecraft:blast_protection"), 10), Map.entry(class_2960.method_60654((String)"minecraft:depth_strider"), 5), Map.entry(class_2960.method_60654((String)"minecraft:fire_aspect"), 3), Map.entry(class_2960.method_60654((String)"minecraft:looting"), 5), Map.entry(class_2960.method_60654((String)"minecraft:knockback"), 3), Map.entry(class_2960.method_60654((String)"minecraft:sweeping_edge"), 5), Map.entry(class_2960.method_60654((String)"minecraft:sharpness"), 10), Map.entry(class_2960.method_60654((String)"minecraft:smite"), 10), Map.entry(class_2960.method_60654((String)"minecraft:bane_of_arthropods"), 10), Map.entry(class_2960.method_60654((String)"minecraft:wind_burst"), 5), Map.entry(class_2960.method_60654((String)"minecraft:density"), 10), Map.entry(class_2960.method_60654((String)"minecraft:breach"), 10), Map.entry(class_2960.method_60654((String)"minecraft:efficiency"), 10), Map.entry(class_2960.method_60654((String)"minecraft:fortune"), 5), Map.entry(class_2960.method_60654((String)"minecraft:power"), 10), Map.entry(class_2960.method_60654((String)"minecraft:punch"), 3), Map.entry(class_2960.method_60654((String)"minecraft:lure"), 5), Map.entry(class_2960.method_60654((String)"minecraft:luck_of_the_sea"), 5), Map.entry(class_2960.method_60654((String)"minecraft:impaling"), 10), Map.entry(class_2960.method_60654((String)"minecraft:loyalty"), 5), Map.entry(class_2960.method_60654((String)"minecraft:riptide"), 5), Map.entry(class_2960.method_60654((String)"minecraft:quick_charge"), 5), Map.entry(class_2960.method_60654((String)"minecraft:piercing"), 10)));
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("superenchants.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void load() {
        if (!Files.exists(FILE, new LinkOption[0])) {
            Config.save();
            return;
        }
        try {
            String json = Files.readString(FILE);
            JsonObject data = (JsonObject)GSON.fromJson(json, JsonObject.class);
            if (data.has("bow-enchants-unnerf")) {
                BOW_ENCHANTS_UNNERF = data.get("bow-enchants-unnerf").getAsBoolean();
            }
            if (data.has("crossbow-enchants-unnerf")) {
                CROSSBOW_ENCHANTS_UNNERF = data.get("crossbow-enchants-unnerf").getAsBoolean();
            }
            if (data.has("armor-enchants-unnerf")) {
                ARMOR_ENCHANTS_UNNERF = data.get("armor-enchants-unnerf").getAsBoolean();
            }
            if (data.has("tool-enchants-unnerf")) {
                TOOL_ENCHANTS_UNNERF = data.get("tool-enchants-unnerf").getAsBoolean();
            }
            if (data.has("enable-channeling-2")) {
                ENABLE_CHANNELING_2 = data.get("enable-channeling-2").getAsBoolean();
            }
            if (data.has("loyalty-void-protection")) {
                LOYALTY_VOID_PROTECTION = data.get("loyalty-void-protection").getAsBoolean();
            }
            if (data.has("disable-soul-speed-damage")) {
                DISABLE_SOUL_SPEED_DAMAGE = data.get("disable-soul-speed-damage").getAsBoolean();
            }
            if (data.has("disable-thorns-damage")) {
                DISABLE_THORNS_DAMAGE = data.get("disable-thorns-damage").getAsBoolean();
            }
            if (data.has("enable-infinity-without-arrow")) {
                ENABLE_INFINITY_WITHOUT_ARROW = data.get("enable-infinity-without-arrow").getAsBoolean();
            }
            if (data.has("enable-crossbow-infinity")) {
                ENABLE_CROSSBOW_INFINITY = data.get("enable-crossbow-infinity").getAsBoolean();
            }
            if (data.has("trident-return-to-same-slot")) {
                TRIDENT_RETURN_TO_SAME_SLOT = data.get("trident-return-to-same-slot").getAsBoolean();
            }
            if (data.has("enable-custom-enchant-levels")) {
                ENABLE_CUSTOM_ENCHANT_LEVELS = data.get("enable-custom-enchant-levels").getAsBoolean();
            }
            if (data.has("custom-levels")) {
                JsonObject levels = data.get("custom-levels").getAsJsonObject();
                levels.entrySet().forEach(entry -> LEVELS.put(class_2960.method_60654((String)((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsInt()));
            }
            Config.save();
        }
        catch (IOException exc) {
            throw new class_148(class_128.method_560((Throwable)exc, (String)"Loading config file."));
        }
    }

    private static void save() {
        try {
            JsonObject data = new JsonObject();
            data.addProperty("bow-enchants-unnerf", Boolean.valueOf(BOW_ENCHANTS_UNNERF));
            data.addProperty("crossbow-enchants-unnerf", Boolean.valueOf(CROSSBOW_ENCHANTS_UNNERF));
            data.addProperty("armor-enchants-unnerf", Boolean.valueOf(ARMOR_ENCHANTS_UNNERF));
            data.addProperty("tool-enchants-unnerf", Boolean.valueOf(TOOL_ENCHANTS_UNNERF));
            data.addProperty("enable-channeling-2", Boolean.valueOf(ENABLE_CHANNELING_2));
            data.addProperty("loyalty-void-protection", Boolean.valueOf(LOYALTY_VOID_PROTECTION));
            data.addProperty("disable-soul-speed-damage", Boolean.valueOf(DISABLE_SOUL_SPEED_DAMAGE));
            data.addProperty("disable-thorns-damage", Boolean.valueOf(DISABLE_THORNS_DAMAGE));
            data.addProperty("enable-infinity-without-arrow", Boolean.valueOf(ENABLE_INFINITY_WITHOUT_ARROW));
            data.addProperty("enable-crossbow-infinity", Boolean.valueOf(ENABLE_CROSSBOW_INFINITY));
            data.addProperty("trident-return-to-same-slot", Boolean.valueOf(TRIDENT_RETURN_TO_SAME_SLOT));
            data.addProperty("enable-custom-enchant-levels", Boolean.valueOf(ENABLE_CUSTOM_ENCHANT_LEVELS));
            JsonObject levels = new JsonObject();
            LEVELS.forEach((id, level) -> levels.addProperty(id.toString(), (Number)level));
            data.add("custom-levels", (JsonElement)levels);
            Files.writeString(FILE, (CharSequence)GSON.toJson((JsonElement)data), new OpenOption[0]);
        }
        catch (IOException exc) {
            throw new class_148(class_128.method_560((Throwable)exc, (String)"Saving config file."));
        }
    }
}

