/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ModEntities;
import com.example.examplemod.TornadoRenderer;
import com.example.examplemod.client.CloudRenderHandler;
import com.example.examplemod.client.CloudShaderManager;
import com.example.examplemod.client.CloudVolumetricRenderer;
import com.example.examplemod.client.NoiseTextureGenerator;
import com.example.examplemod.client.TornadoShaderManager;
import com.example.examplemod.client.TornadoVolumetricRenderer;
import com.example.examplemod.tornado;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(modid="tornado", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEvents {
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        System.out.println("DEBUG: ClientModEvents registerRenderers called. Registering TornadoRenderer.");
        event.registerEntityRenderer((EntityType)ModEntities.TORNADO.get(), TornadoRenderer::new);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            tornado.LOGGER.info("Initializing volumetric rendering system...");
            NoiseTextureGenerator.getInstance().initialize();
            TornadoShaderManager.getInstance().initialize();
            TornadoVolumetricRenderer.getInstance().initialize();
            CloudShaderManager.getInstance().initialize();
            CloudVolumetricRenderer.getInstance().initialize();
            CloudRenderHandler.enableVolumetricClouds();
            tornado.LOGGER.info("Volumetric rendering system initialized!");
            tornado.LOGGER.info("- Tornado volumetric: ENABLED");
            tornado.LOGGER.info("- Cloud volumetric: ENABLED (vanilla clouds disabled)");
        });
    }
}

