/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.TornadoEntity;
import com.example.examplemod.client.CloudShaderManager;
import com.example.examplemod.tornado;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL30;

public class CloudVolumetricRenderer {
    private static CloudVolumetricRenderer instance;
    private RenderTarget cloudTarget;
    private int targetWidth = 0;
    private int targetHeight = 0;
    private static final float RESOLUTION_SCALE = 0.5f;
    private int quadVAO = -1;
    private int quadVBO = -1;
    private float cloudCoverage = 0.5f;
    private float cloudAltitude = 192.0f;
    private float cloudThickness = 64.0f;
    private float windSpeed = 1.0f;
    private Vector3f windDirection = new Vector3f(1.0f, 0.0f, 0.3f).normalize();
    private RenderTarget previousFrame;
    private Matrix4f previousViewProjMatrix = new Matrix4f();
    private boolean hasPreviousFrame = false;
    private boolean enabled = true;

    public static CloudVolumetricRenderer getInstance() {
        if (instance == null) {
            instance = new CloudVolumetricRenderer();
        }
        return instance;
    }

    private CloudVolumetricRenderer() {
    }

    public void initialize() {
        CloudShaderManager.getInstance().initialize();
        this.createFullscreenQuad();
        tornado.LOGGER.info("CloudVolumetricRenderer initialized");
    }

    private void createFullscreenQuad() {
        if (this.quadVAO > 0) {
            return;
        }
        float[] quadVertices = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.quadVAO = GL30.glGenVertexArrays();
        this.quadVBO = GL30.glGenBuffers();
        GL30.glBindVertexArray((int)this.quadVAO);
        GL30.glBindBuffer((int)34962, (int)this.quadVBO);
        GL30.glBufferData((int)34962, (float[])quadVertices, (int)35044);
        GL30.glEnableVertexAttribArray((int)0);
        GL30.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)20, (long)0L);
        GL30.glEnableVertexAttribArray((int)1);
        GL30.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)20, (long)12L);
        GL30.glBindVertexArray((int)0);
    }

    private void updateRenderTarget(int screenWidth, int screenHeight) {
        int newWidth = (int)((float)screenWidth * 0.5f);
        int newHeight = (int)((float)screenHeight * 0.5f);
        if (this.cloudTarget == null || this.targetWidth != newWidth || this.targetHeight != newHeight) {
            if (this.cloudTarget != null) {
                this.cloudTarget.destroyBuffers();
            }
            if (this.previousFrame != null) {
                this.previousFrame.destroyBuffers();
            }
            this.cloudTarget = new TextureTarget(newWidth, newHeight, false, Minecraft.ON_OSX);
            this.cloudTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.previousFrame = new TextureTarget(newWidth, newHeight, false, Minecraft.ON_OSX);
            this.previousFrame.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.targetWidth = newWidth;
            this.targetHeight = newHeight;
            this.hasPreviousFrame = false;
            tornado.LOGGER.debug("Created cloud render targets: {}x{}", (Object)newWidth, (Object)newHeight);
        }
    }

    public void render(PoseStack poseStack, float partialTicks, Camera camera) {
        if (!this.enabled || !CloudShaderManager.getInstance().isReady()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        int screenWidth = mc.getWindow().getWidth();
        int screenHeight = mc.getWindow().getHeight();
        this.updateRenderTarget(screenWidth, screenHeight);
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.last().pose());
        Matrix4f viewProjMatrix = new Matrix4f((Matrix4fc)projectionMatrix).mul((Matrix4fc)modelViewMatrix);
        Matrix4f invViewProjMatrix = new Matrix4f((Matrix4fc)viewProjMatrix).invert();
        Vec3 cameraPos = camera.getPosition();
        float sunAngle = level.getTimeOfDay(partialTicks) * ((float)Math.PI * 2);
        Vector3f sunDirection = new Vector3f((float)Math.cos(sunAngle), (float)Math.sin(sunAngle), 0.3f);
        sunDirection.normalize();
        float daylight = level.getSkyDarken();
        float sunIntensity = 1.0f - daylight;
        TornadoEntity nearestTornado = this.findNearestTornado((Level)level, cameraPos);
        this.renderCloudsToTarget(invViewProjMatrix, cameraPos, sunDirection, sunIntensity, partialTicks, nearestTornado);
        this.blitCloudsToScreen(screenWidth, screenHeight);
        this.previousViewProjMatrix.set((Matrix4fc)viewProjMatrix);
        this.hasPreviousFrame = true;
    }

    private TornadoEntity findNearestTornado(Level level, Vec3 cameraPos) {
        double maxDist = 500.0;
        AABB searchBox = new AABB(cameraPos.x - maxDist, cameraPos.y - 200.0, cameraPos.z - maxDist, cameraPos.x + maxDist, cameraPos.y + 300.0, cameraPos.z + maxDist);
        List tornadoes = level.getEntitiesOfClass(TornadoEntity.class, searchBox);
        TornadoEntity nearest = null;
        double nearestDist = Double.MAX_VALUE;
        for (TornadoEntity tornado2 : tornadoes) {
            double dist = tornado2.position().distanceTo(cameraPos);
            if (!(dist < nearestDist)) continue;
            nearestDist = dist;
            nearest = tornado2;
        }
        return nearest;
    }

    private void renderCloudsToTarget(Matrix4f invViewProjMatrix, Vec3 cameraPos, Vector3f sunDirection, float sunIntensity, float partialTicks, TornadoEntity tornado2) {
        CloudShaderManager shader = CloudShaderManager.getInstance();
        this.cloudTarget.clear(Minecraft.ON_OSX);
        this.cloudTarget.bindWrite(true);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        shader.bind();
        shader.setCameraPosition((float)cameraPos.x, (float)cameraPos.y, (float)cameraPos.z);
        shader.setInverseViewProjectionMatrix(invViewProjMatrix);
        shader.setTime((float)Minecraft.getInstance().level.getGameTime() + partialTicks);
        shader.setSunDirection(sunDirection.x, sunDirection.y, sunDirection.z);
        shader.setSunIntensity(sunIntensity);
        shader.setScreenSize(this.targetWidth, this.targetHeight);
        shader.setCloudCoverage(this.cloudCoverage);
        shader.setCloudAltitude(this.cloudAltitude);
        shader.setCloudThickness(this.cloudThickness);
        shader.setWindDirection(this.windDirection.x, this.windDirection.y, this.windDirection.z);
        shader.setWindSpeed(this.windSpeed);
        if (tornado2 != null) {
            shader.setStormActive(true);
            shader.setStormCenter((float)tornado2.getX(), (float)tornado2.getY(), (float)tornado2.getZ());
            float stormRadius = 50.0f + (float)tornado2.getTier() * 30.0f;
            shader.setStormRadius(stormRadius);
        } else {
            shader.setStormActive(false);
        }
        GL30.glBindVertexArray((int)this.quadVAO);
        GL30.glDrawArrays((int)4, (int)0, (int)6);
        GL30.glBindVertexArray((int)0);
        shader.unbind();
        this.cloudTarget.unbindWrite();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    private void blitCloudsToScreen(int screenWidth, int screenHeight) {
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        this.cloudTarget.blitToScreen(screenWidth, screenHeight, false);
        RenderSystem.enableDepthTest();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCloudCoverage(float coverage) {
        this.cloudCoverage = Math.max(0.0f, Math.min(1.0f, coverage));
    }

    public void setCloudAltitude(float altitude) {
        this.cloudAltitude = altitude;
    }

    public void setCloudThickness(float thickness) {
        this.cloudThickness = thickness;
    }

    public void setWindSpeed(float speed) {
        this.windSpeed = speed;
    }

    public void setWindDirection(Vector3f direction) {
        this.windDirection.set((Vector3fc)direction).normalize();
    }

    public void cleanup() {
        if (this.quadVAO > 0) {
            GL30.glDeleteVertexArrays((int)this.quadVAO);
            this.quadVAO = -1;
        }
        if (this.quadVBO > 0) {
            GL30.glDeleteBuffers((int)this.quadVBO);
            this.quadVBO = -1;
        }
        if (this.cloudTarget != null) {
            this.cloudTarget.destroyBuffers();
            this.cloudTarget = null;
        }
        if (this.previousFrame != null) {
            this.previousFrame.destroyBuffers();
            this.previousFrame = null;
        }
        CloudShaderManager.getInstance().cleanup();
    }
}

