/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.tornado;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public class TornadoShaderManager {
    private static TornadoShaderManager instance;
    private int shaderProgram = -1;
    private int vertexShader = -1;
    private int fragmentShader = -1;
    private int uTornadoPositionLoc = -1;
    private int uTimeLoc = -1;
    private int uSunDirectionLoc = -1;
    private int uSunIntensityLoc = -1;
    private int uCameraPosLoc = -1;
    private int uInvViewProjMatLoc = -1;
    private int uTierLoc = -1;
    private int uScreenSizeLoc = -1;
    private int uModelViewMatLoc = -1;
    private int uProjMatLoc = -1;
    private int uBoxSizeLoc = -1;
    private int uBoxCenterLoc = -1;
    private final FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);
    private boolean initialized = false;
    private boolean loadFailed = false;

    public static TornadoShaderManager getInstance() {
        if (instance == null) {
            instance = new TornadoShaderManager();
        }
        return instance;
    }

    private TornadoShaderManager() {
    }

    public void initialize() {
        if (this.initialized || this.loadFailed) {
            return;
        }
        try {
            tornado.LOGGER.info("Initializing tornado volumetric shader...");
            String vertexSource = this.loadShaderSource("tornado:shaders/core/tornado_volumetric.vsh");
            String fragmentSource = this.loadShaderSource("tornado:shaders/core/tornado_volumetric.fsh");
            if (vertexSource == null || fragmentSource == null) {
                tornado.LOGGER.error("Failed to load shader source files");
                this.loadFailed = true;
                return;
            }
            this.vertexShader = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)this.vertexShader, (CharSequence)vertexSource);
            GL20.glCompileShader((int)this.vertexShader);
            if (GL20.glGetShaderi((int)this.vertexShader, (int)35713) == 0) {
                String log = GL20.glGetShaderInfoLog((int)this.vertexShader);
                tornado.LOGGER.error("Vertex shader compilation failed: {}", (Object)log);
                this.cleanup();
                this.loadFailed = true;
                return;
            }
            this.fragmentShader = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)this.fragmentShader, (CharSequence)fragmentSource);
            GL20.glCompileShader((int)this.fragmentShader);
            if (GL20.glGetShaderi((int)this.fragmentShader, (int)35713) == 0) {
                String log = GL20.glGetShaderInfoLog((int)this.fragmentShader);
                tornado.LOGGER.error("Fragment shader compilation failed: {}", (Object)log);
                this.cleanup();
                this.loadFailed = true;
                return;
            }
            this.shaderProgram = GL20.glCreateProgram();
            GL20.glAttachShader((int)this.shaderProgram, (int)this.vertexShader);
            GL20.glAttachShader((int)this.shaderProgram, (int)this.fragmentShader);
            GL20.glBindAttribLocation((int)this.shaderProgram, (int)0, (CharSequence)"Position");
            GL20.glBindAttribLocation((int)this.shaderProgram, (int)1, (CharSequence)"UV0");
            GL20.glLinkProgram((int)this.shaderProgram);
            if (GL20.glGetProgrami((int)this.shaderProgram, (int)35714) == 0) {
                String log = GL20.glGetProgramInfoLog((int)this.shaderProgram);
                tornado.LOGGER.error("Shader program linking failed: {}", (Object)log);
                this.cleanup();
                this.loadFailed = true;
                return;
            }
            this.cacheUniformLocations();
            this.initialized = true;
            tornado.LOGGER.info("Tornado volumetric shader initialized successfully!");
        }
        catch (Exception e) {
            tornado.LOGGER.error("Exception during shader initialization", (Throwable)e);
            this.cleanup();
            this.loadFailed = true;
        }
    }

    private void cacheUniformLocations() {
        this.uTornadoPositionLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uTornadoPosition");
        this.uTimeLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uTime");
        this.uSunDirectionLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uSunDirection");
        this.uSunIntensityLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uSunIntensity");
        this.uCameraPosLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uCameraPos");
        this.uInvViewProjMatLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uInvViewProjMat");
        this.uTierLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uTier");
        this.uScreenSizeLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uScreenSize");
        this.uModelViewMatLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"ModelViewMat");
        this.uProjMatLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"ProjMat");
        this.uBoxSizeLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uBoxSize");
        this.uBoxCenterLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uBoxCenter");
        tornado.LOGGER.debug("Uniform locations - Position: {}, Time: {}, Tier: {}, BoxSize: {}, BoxCenter: {}", new Object[]{this.uTornadoPositionLoc, this.uTimeLoc, this.uTierLoc, this.uBoxSizeLoc, this.uBoxCenterLoc});
    }

    private String loadShaderSource(String path) {
        String string;
        ResourceLocation location = ResourceLocation.parse((String)path);
        String resourcePath = "/assets/" + location.getNamespace() + "/" + location.getPath();
        InputStream stream = TornadoShaderManager.class.getResourceAsStream(resourcePath);
        if (stream == null) {
            tornado.LOGGER.error("Could not find shader resource: {}", (Object)resourcePath);
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                tornado.LOGGER.error("Failed to load shader: {}", (Object)path, (Object)e);
                return null;
            }
        }
        reader.close();
        return string;
    }

    public void bind() {
        if (!this.initialized || this.loadFailed) {
            return;
        }
        GL20.glUseProgram((int)this.shaderProgram);
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    public boolean isReady() {
        return this.initialized && !this.loadFailed;
    }

    public void setTornadoPosition(float x, float y, float z) {
        if (this.uTornadoPositionLoc >= 0) {
            GL20.glUniform3f((int)this.uTornadoPositionLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setTornadoPosition(Vector3f pos) {
        this.setTornadoPosition(pos.x, pos.y, pos.z);
    }

    public void setTime(float time) {
        if (this.uTimeLoc >= 0) {
            GL20.glUniform1f((int)this.uTimeLoc, (float)time);
        }
    }

    public void setSunDirection(float x, float y, float z) {
        if (this.uSunDirectionLoc >= 0) {
            GL20.glUniform3f((int)this.uSunDirectionLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setSunIntensity(float intensity) {
        if (this.uSunIntensityLoc >= 0) {
            GL20.glUniform1f((int)this.uSunIntensityLoc, (float)intensity);
        }
    }

    public void setCameraPosition(float x, float y, float z) {
        if (this.uCameraPosLoc >= 0) {
            GL20.glUniform3f((int)this.uCameraPosLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setCameraPosition(Vector3f pos) {
        this.setCameraPosition(pos.x, pos.y, pos.z);
    }

    public void setInverseViewProjectionMatrix(Matrix4f matrix) {
        if (this.uInvViewProjMatLoc >= 0) {
            this.matrixBuffer.clear();
            matrix.get(this.matrixBuffer);
            GL20.glUniformMatrix4fv((int)this.uInvViewProjMatLoc, (boolean)false, (FloatBuffer)this.matrixBuffer);
        }
    }

    public void setModelViewMatrix(Matrix4f matrix) {
        if (this.uModelViewMatLoc >= 0) {
            this.matrixBuffer.clear();
            matrix.get(this.matrixBuffer);
            GL20.glUniformMatrix4fv((int)this.uModelViewMatLoc, (boolean)false, (FloatBuffer)this.matrixBuffer);
        }
    }

    public void setProjectionMatrix(Matrix4f matrix) {
        if (this.uProjMatLoc >= 0) {
            this.matrixBuffer.clear();
            matrix.get(this.matrixBuffer);
            GL20.glUniformMatrix4fv((int)this.uProjMatLoc, (boolean)false, (FloatBuffer)this.matrixBuffer);
        }
    }

    public void setTier(float tier) {
        if (this.uTierLoc >= 0) {
            GL20.glUniform1f((int)this.uTierLoc, (float)tier);
        }
    }

    public void setScreenSize(float width, float height) {
        if (this.uScreenSizeLoc >= 0) {
            GL20.glUniform2f((int)this.uScreenSizeLoc, (float)width, (float)height);
        }
    }

    public void setBoxSize(float width, float height, float depth) {
        if (this.uBoxSizeLoc >= 0) {
            GL20.glUniform3f((int)this.uBoxSizeLoc, (float)width, (float)height, (float)depth);
        }
    }

    public void setBoxCenter(float x, float y, float z) {
        if (this.uBoxCenterLoc >= 0) {
            GL20.glUniform3f((int)this.uBoxCenterLoc, (float)x, (float)y, (float)z);
        }
    }

    public void cleanup() {
        if (this.shaderProgram > 0) {
            GL20.glDeleteProgram((int)this.shaderProgram);
            this.shaderProgram = -1;
        }
        if (this.vertexShader > 0) {
            GL20.glDeleteShader((int)this.vertexShader);
            this.vertexShader = -1;
        }
        if (this.fragmentShader > 0) {
            GL20.glDeleteShader((int)this.fragmentShader);
            this.fragmentShader = -1;
        }
        this.initialized = false;
    }

    public void reload() {
        this.cleanup();
        this.loadFailed = false;
        this.initialize();
    }
}

