/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.TornadoEntity;
import com.example.examplemod.client.TornadoShaderManager;
import com.example.examplemod.tornado;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class TornadoVolumetricRenderer {
    private static TornadoVolumetricRenderer instance;
    private RenderTarget lowResTarget;
    private int lowResWidth = 0;
    private int lowResHeight = 0;
    private static final float RESOLUTION_SCALE = 0.5f;
    private int quadVAO = -1;
    private int quadVBO = -1;
    private final List<TornadoRenderData> tornadoesToRender = new ArrayList<TornadoRenderData>();
    private long lastFrameTime = 0L;
    private float smoothedFrameTime = 16.0f;
    private int cubeVAO = -1;
    private int cubeVBO = -1;
    private static final float[] TORNADO_HEIGHT;
    private static final float[] MAX_RADIUS;

    public static TornadoVolumetricRenderer getInstance() {
        if (instance == null) {
            instance = new TornadoVolumetricRenderer();
        }
        return instance;
    }

    private TornadoVolumetricRenderer() {
    }

    public void initialize() {
        TornadoShaderManager.getInstance().initialize();
        this.createFullscreenQuad();
        this.createCube();
        tornado.LOGGER.info("TornadoVolumetricRenderer initialized");
    }

    private void createFullscreenQuad() {
        if (this.quadVAO > 0) {
            return;
        }
        float[] quadVertices = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.quadVAO = GL30.glGenVertexArrays();
        this.quadVBO = GL30.glGenBuffers();
        GL30.glBindVertexArray((int)this.quadVAO);
        GL30.glBindBuffer((int)34962, (int)this.quadVBO);
        GL30.glBufferData((int)34962, (float[])quadVertices, (int)35044);
        GL30.glEnableVertexAttribArray((int)0);
        GL30.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)20, (long)0L);
        GL30.glEnableVertexAttribArray((int)1);
        GL30.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)20, (long)12L);
        GL30.glBindVertexArray((int)0);
    }

    private void createCube() {
        if (this.cubeVAO > 0) {
            return;
        }
        float[] cubeVertices = new float[]{-0.5f, -0.5f, 0.5f, 0.0f, 0.0f, 0.5f, -0.5f, 0.5f, 1.0f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f, 1.0f, -0.5f, -0.5f, 0.5f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f, 1.0f, -0.5f, 0.5f, 0.5f, 0.0f, 1.0f, 0.5f, -0.5f, -0.5f, 0.0f, 0.0f, -0.5f, -0.5f, -0.5f, 1.0f, 0.0f, -0.5f, 0.5f, -0.5f, 1.0f, 1.0f, 0.5f, -0.5f, -0.5f, 0.0f, 0.0f, -0.5f, 0.5f, -0.5f, 1.0f, 1.0f, 0.5f, 0.5f, -0.5f, 0.0f, 1.0f, -0.5f, -0.5f, -0.5f, 0.0f, 0.0f, -0.5f, -0.5f, 0.5f, 1.0f, 0.0f, -0.5f, 0.5f, 0.5f, 1.0f, 1.0f, -0.5f, -0.5f, -0.5f, 0.0f, 0.0f, -0.5f, 0.5f, 0.5f, 1.0f, 1.0f, -0.5f, 0.5f, -0.5f, 0.0f, 1.0f, 0.5f, -0.5f, 0.5f, 0.0f, 0.0f, 0.5f, -0.5f, -0.5f, 1.0f, 0.0f, 0.5f, 0.5f, -0.5f, 1.0f, 1.0f, 0.5f, -0.5f, 0.5f, 0.0f, 0.0f, 0.5f, 0.5f, -0.5f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 0.0f, 1.0f, -0.5f, 0.5f, 0.5f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f, 0.0f, 0.5f, 0.5f, -0.5f, 1.0f, 1.0f, -0.5f, 0.5f, 0.5f, 0.0f, 0.0f, 0.5f, 0.5f, -0.5f, 1.0f, 1.0f, -0.5f, 0.5f, -0.5f, 0.0f, 1.0f, -0.5f, -0.5f, -0.5f, 0.0f, 0.0f, 0.5f, -0.5f, -0.5f, 1.0f, 0.0f, 0.5f, -0.5f, 0.5f, 1.0f, 1.0f, -0.5f, -0.5f, -0.5f, 0.0f, 0.0f, 0.5f, -0.5f, 0.5f, 1.0f, 1.0f, -0.5f, -0.5f, 0.5f, 0.0f, 1.0f};
        this.cubeVAO = GL30.glGenVertexArrays();
        this.cubeVBO = GL30.glGenBuffers();
        GL30.glBindVertexArray((int)this.cubeVAO);
        GL30.glBindBuffer((int)34962, (int)this.cubeVBO);
        GL30.glBufferData((int)34962, (float[])cubeVertices, (int)35044);
        GL30.glEnableVertexAttribArray((int)0);
        GL30.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)20, (long)0L);
        GL30.glEnableVertexAttribArray((int)1);
        GL30.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)20, (long)12L);
        GL30.glBindVertexArray((int)0);
    }

    private void updateLowResTarget(int screenWidth, int screenHeight) {
        int targetWidth = (int)((float)screenWidth * 0.5f);
        int targetHeight = (int)((float)screenHeight * 0.5f);
        if (this.lowResTarget == null || this.lowResWidth != targetWidth || this.lowResHeight != targetHeight) {
            if (this.lowResTarget != null) {
                this.lowResTarget.destroyBuffers();
            }
            this.lowResTarget = new TextureTarget(targetWidth, targetHeight, true, Minecraft.ON_OSX);
            this.lowResTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.lowResWidth = targetWidth;
            this.lowResHeight = targetHeight;
            tornado.LOGGER.debug("Created low-res render target: {}x{}", (Object)targetWidth, (Object)targetHeight);
        }
    }

    public void render(PoseStack poseStack, float partialTicks, Camera camera) {
        if (!TornadoShaderManager.getInstance().isReady()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        long currentTime = System.nanoTime();
        if (this.lastFrameTime > 0L) {
            float frameTime = (float)(currentTime - this.lastFrameTime) / 1000000.0f;
            this.smoothedFrameTime = this.smoothedFrameTime * 0.9f + frameTime * 0.1f;
        }
        this.lastFrameTime = currentTime;
        this.collectVisibleTornadoes((Level)level, camera);
        if (this.tornadoesToRender.isEmpty()) {
            return;
        }
        int screenWidth = mc.getWindow().getWidth();
        int screenHeight = mc.getWindow().getHeight();
        this.updateLowResTarget(screenWidth, screenHeight);
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.last().pose());
        Matrix4f viewProjMatrix = new Matrix4f((Matrix4fc)projectionMatrix).mul((Matrix4fc)modelViewMatrix);
        Matrix4f invViewProjMatrix = new Matrix4f((Matrix4fc)viewProjMatrix).invert();
        Vec3 cameraPos = camera.getPosition();
        float sunAngle = level.getTimeOfDay(partialTicks) * ((float)Math.PI * 2);
        Vector3f sunDirection = new Vector3f((float)Math.cos(sunAngle), (float)Math.sin(sunAngle), 0.3f);
        sunDirection.normalize();
        float daylight = level.getSkyDarken();
        float sunIntensity = 1.0f - daylight;
        for (TornadoRenderData data : this.tornadoesToRender) {
            this.renderTornado(data, invViewProjMatrix, cameraPos, sunDirection, sunIntensity, partialTicks, screenWidth, screenHeight);
        }
    }

    private void collectVisibleTornadoes(Level level, Camera camera) {
        this.tornadoesToRender.clear();
        Vec3 cameraPos = camera.getPosition();
        double maxRenderDistance = 256.0;
        AABB searchBox = new AABB(cameraPos.x - maxRenderDistance, cameraPos.y - maxRenderDistance, cameraPos.z - maxRenderDistance, cameraPos.x + maxRenderDistance, cameraPos.y + maxRenderDistance, cameraPos.z + maxRenderDistance);
        List tornadoes = level.getEntitiesOfClass(TornadoEntity.class, searchBox);
        for (TornadoEntity tornado2 : tornadoes) {
            Vec3 cameraLook;
            Vec3 toTornado;
            double distance = tornado2.position().distanceTo(cameraPos);
            if (distance > maxRenderDistance || !((toTornado = tornado2.position().subtract(cameraPos).normalize()).dot(cameraLook = new Vec3(camera.getLookVector())) > -0.3) && !(distance < 100.0)) continue;
            TornadoRenderData data = new TornadoRenderData();
            data.entity = tornado2;
            data.position = tornado2.position();
            data.tier = tornado2.getTier();
            data.distance = distance;
            data.time = tornado2.tickCount;
            this.tornadoesToRender.add(data);
        }
    }

    private void renderTornado(TornadoRenderData data, Matrix4f invViewProjMatrix, Vec3 cameraPos, Vector3f sunDirection, float sunIntensity, float partialTicks, int screenWidth, int screenHeight) {
        TornadoShaderManager shader = TornadoShaderManager.getInstance();
        int tierIdx = Math.max(0, Math.min(4, data.tier - 1));
        float height = TORNADO_HEIGHT[tierIdx];
        float radius = MAX_RADIUS[tierIdx] + 25.0f;
        float boxWidth = radius * 2.5f;
        float boxHeight = height + 50.0f;
        float boxDepth = radius * 2.5f;
        float boxCenterX = (float)data.position.x;
        float boxCenterY = (float)data.position.y + boxHeight * 0.5f;
        float boxCenterZ = (float)data.position.z;
        boolean depthTest = GL11.glIsEnabled((int)2929);
        boolean blend = GL11.glIsEnabled((int)3042);
        int[] prevProgram = new int[1];
        GL30.glGetIntegerv((int)35725, (int[])prevProgram);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        shader.bind();
        shader.setTornadoPosition((float)data.position.x, (float)data.position.y, (float)data.position.z);
        shader.setTime((float)data.time + partialTicks);
        shader.setSunDirection(sunDirection.x, sunDirection.y, sunDirection.z);
        shader.setSunIntensity(sunIntensity);
        shader.setCameraPosition((float)cameraPos.x, (float)cameraPos.y, (float)cameraPos.z);
        shader.setInverseViewProjectionMatrix(invViewProjMatrix);
        shader.setTier(data.tier);
        shader.setScreenSize(screenWidth, screenHeight);
        shader.setBoxSize(boxWidth, boxHeight, boxDepth);
        shader.setBoxCenter(boxCenterX, boxCenterY, boxCenterZ);
        Matrix4f modelMatrix = new Matrix4f();
        modelMatrix.translate((float)((double)boxCenterX - cameraPos.x), (float)((double)boxCenterY - cameraPos.y), (float)((double)boxCenterZ - cameraPos.z));
        modelMatrix.scale(boxWidth, boxHeight, boxDepth);
        Matrix4f projMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f viewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        shader.setModelViewMatrix(new Matrix4f((Matrix4fc)viewMatrix).mul((Matrix4fc)modelMatrix));
        shader.setProjectionMatrix(projMatrix);
        if (this.cubeVAO > 0) {
            GL30.glBindVertexArray((int)this.cubeVAO);
            GL30.glDrawArrays((int)4, (int)0, (int)36);
            GL30.glBindVertexArray((int)0);
        }
        shader.unbind();
        GL30.glUseProgram((int)prevProgram[0]);
        RenderSystem.enableCull();
        if (depthTest) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        if (blend) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        RenderSystem.depthMask((boolean)true);
    }

    public boolean shouldReduceQuality() {
        return this.smoothedFrameTime > 33.3f;
    }

    public void cleanup() {
        if (this.quadVAO > 0) {
            GL30.glDeleteVertexArrays((int)this.quadVAO);
            this.quadVAO = -1;
        }
        if (this.quadVBO > 0) {
            GL30.glDeleteBuffers((int)this.quadVBO);
            this.quadVBO = -1;
        }
        if (this.cubeVAO > 0) {
            GL30.glDeleteVertexArrays((int)this.cubeVAO);
            this.cubeVAO = -1;
        }
        if (this.cubeVBO > 0) {
            GL30.glDeleteBuffers((int)this.cubeVBO);
            this.cubeVBO = -1;
        }
        if (this.lowResTarget != null) {
            this.lowResTarget.destroyBuffers();
            this.lowResTarget = null;
        }
        TornadoShaderManager.getInstance().cleanup();
    }

    static {
        TORNADO_HEIGHT = new float[]{25.0f, 40.0f, 60.0f, 85.0f, 120.0f};
        MAX_RADIUS = new float[]{8.0f, 12.0f, 18.0f, 26.0f, 38.0f};
    }

    private static class TornadoRenderData {
        TornadoEntity entity;
        Vec3 position;
        int tier;
        double distance;
        int time;

        private TornadoRenderData() {
        }
    }
}

