/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ModEntities;
import com.example.examplemod.TornadoEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class TornadoCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tornado").then(Commands.argument((String)"tier", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("f1");
            builder.suggest("f2");
            builder.suggest("f3");
            builder.suggest("f4");
            builder.suggest("f5");
            return builder.buildFuture();
        }).executes(context -> {
            String tierStr = StringArgumentType.getString((CommandContext)context, (String)"tier");
            int tier = 1;
            if (tierStr.equalsIgnoreCase("f2")) {
                tier = 2;
            } else if (tierStr.equalsIgnoreCase("f3")) {
                tier = 3;
            } else if (tierStr.equalsIgnoreCase("f4")) {
                tier = 4;
            } else if (tierStr.equalsIgnoreCase("f5")) {
                tier = 5;
            }
            TornadoCommand.spawnTornado((CommandSourceStack)context.getSource(), tier);
            return 1;
        })));
    }

    private static void spawnTornado(CommandSourceStack source, int tier) {
        ServerLevel level = source.getLevel();
        TornadoEntity tornado2 = (TornadoEntity)((EntityType)ModEntities.TORNADO.get()).create((Level)level);
        if (tornado2 != null) {
            tornado2.moveTo(source.getPosition());
            tornado2.setTier(tier);
            level.addFreshEntity((Entity)tornado2);
            source.sendSuccess(() -> Component.literal((String)("Spawned F" + tier + " Tornado!")), true);
        }
    }
}

