/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ModSounds;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TornadoEntity
extends Entity {
    private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.defineId(TornadoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int wanderTimer = 0;
    private Vec3 wanderTarget = Vec3.ZERO;
    private double wobblePhase = 0.0;
    private static final double[] THROW_POWER = new double[]{4.0, 6.0, 9.0, 13.0, 18.0};
    private int spiralScanAngle = 0;
    private int spiralScanRadius = 0;
    private int spiralScanY = 0;
    private static final int SPIRAL_ANGLE_STEP = 30;
    private static final int BLOCKS_PER_TICK = 5;
    private static final double[] ENTITY_PULL_RADIUS = new double[]{25.0, 40.0, 60.0, 85.0, 120.0};
    private static final double[] BLOCK_GRAB_RADIUS = new double[]{35.0, 55.0, 80.0, 110.0, 150.0};
    private static final double[] TORNADO_HEIGHT = new double[]{25.0, 40.0, 60.0, 85.0, 120.0};
    private static final double[] MOVEMENT_SPEED = new double[]{0.15, 0.2, 0.25, 0.32, 0.4};
    private static final int[] BLOCK_BREAK_RADIUS = new int[]{8, 14, 22, 32, 45};
    private static final float[] DAMAGE_PER_SECOND = new float[]{3.0f, 6.0f, 10.0f, 16.0f, 25.0f};
    private static final double[] LIFT_STRENGTH = new double[]{0.18, 0.3, 0.45, 0.65, 0.9};
    private static final double[] PULL_STRENGTH = new double[]{0.5, 0.75, 1.0, 1.4, 1.9};
    private static final double[] SPIRAL_STRENGTH = new double[]{0.6, 0.85, 1.1, 1.5, 2.0};

    public TornadoEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TIER, (Object)1);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(TIER, (Object)compound.getInt("Tier"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Tier", this.getTier());
    }

    public void setTier(int tier) {
        this.entityData.set(TIER, (Object)Mth.clamp((int)tier, (int)1, (int)5));
    }

    public int getTier() {
        return (Integer)this.entityData.get(TIER);
    }

    private int getTierIndex() {
        return Mth.clamp((int)(this.getTier() - 1), (int)0, (int)4);
    }

    public void tick() {
        super.tick();
        this.wobblePhase += 0.1;
        if (!this.level().isClientSide) {
            this.moveTornado();
            this.pullAndDamageEntities();
            this.destroyBlocks();
            this.grabWater();
            this.spawnLightning();
            this.pullItems();
        } else {
            this.playAmbientSound();
            this.spawnDebrisParticles();
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 65536.0;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isOnFire() {
        return false;
    }

    private void playAmbientSound() {
        double warningRange;
        double distSq;
        LocalPlayer clientPlayer;
        if (this.tickCount % 30 == 0) {
            float volume = 5.0f + (float)this.getTier() * 2.0f;
            float pitch = 1.0f - (float)this.getTier() * 0.08f;
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.TORNADO_ROAR.get(), SoundSource.WEATHER, volume, pitch, false);
        }
        if ((clientPlayer = Minecraft.getInstance().player) != null && (distSq = clientPlayer.distanceToSqr((Entity)this)) < (warningRange = (double)(80 + this.getTier() * 20)) * warningRange && this.tickCount % 80 == 0) {
            this.level().playLocalSound(clientPlayer.getX(), clientPlayer.getY(), clientPlayer.getZ(), (SoundEvent)ModSounds.TORNADO_SIREN.get(), SoundSource.WEATHER, 0.8f, 1.0f, false);
        }
    }

    private void spawnDebrisParticles() {
        double angle;
        int i;
        int tier = this.getTier();
        double height = TORNADO_HEIGHT[this.getTierIndex()];
        double radius = ENTITY_PULL_RADIUS[this.getTierIndex()];
        for (i = 0; i < tier * 3; ++i) {
            angle = (double)this.tickCount * 0.2 + (double)i * (Math.PI * 2 / (double)(tier * 3));
            double y = this.random.nextDouble() * height;
            double r = 2.0 + y / height * (radius * 0.5);
            double px = this.getX() + Math.cos(angle) * r;
            double pz = this.getZ() + Math.sin(angle) * r;
            double py = this.getY() + y;
            double vx = -Math.sin(angle) * 0.3;
            double vz = Math.cos(angle) * 0.3;
            double vy = 0.2 + this.random.nextDouble() * 0.3;
            this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, px, py, pz, vx, vy, vz);
        }
        if (this.tickCount % 2 == 0) {
            for (i = 0; i < tier * 2; ++i) {
                angle = this.random.nextDouble() * Math.PI * 2.0;
                double r = this.random.nextDouble() * radius * 0.3;
                double px = this.getX() + Math.cos(angle) * r;
                double pz = this.getZ() + Math.sin(angle) * r;
                this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, px, this.getY() + 0.5, pz, (this.random.nextDouble() - 0.5) * 0.5, 0.1, (this.random.nextDouble() - 0.5) * 0.5);
            }
        }
    }

    private void moveTornado() {
        int tierIdx = this.getTierIndex();
        double speed = MOVEMENT_SPEED[tierIdx];
        if (this.wanderTimer <= 0 || this.wanderTarget.distanceToSqr(this.position()) < 9.0) {
            this.wanderTimer = 100 + this.random.nextInt(200);
            double angle = this.random.nextDouble() * 2.0 * Math.PI;
            double distance = 20.0 + this.random.nextDouble() * 40.0;
            this.wanderTarget = this.position().add(Math.cos(angle) * distance, 0.0, Math.sin(angle) * distance);
        }
        --this.wanderTimer;
        Vec3 currentPos = this.position();
        Vec3 toTarget = new Vec3(this.wanderTarget.x - currentPos.x, 0.0, this.wanderTarget.z - currentPos.z);
        if (toTarget.lengthSqr() > 0.01) {
            toTarget = toTarget.normalize().scale(speed);
        }
        double wobbleX = Math.sin(this.wobblePhase) * 0.05 * (double)this.getTier();
        double wobbleZ = Math.cos(this.wobblePhase * 1.3) * 0.05 * (double)this.getTier();
        int groundY = this.getMaxGroundY(this.blockPosition().getX(), this.blockPosition().getZ(), 3);
        double yDiff = (double)groundY - currentPos.y;
        double yVel = Mth.clamp((double)(yDiff * 0.15), (double)-0.5, (double)0.5);
        this.setDeltaMovement(toTarget.x + wobbleX, yVel, toTarget.z + wobbleZ);
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    private int getMaxGroundY(int centerX, int centerZ, int radius) {
        int maxY = Integer.MIN_VALUE;
        for (int x = centerX - radius; x <= centerX + radius; x += 2) {
            for (int z = centerZ - radius; z <= centerZ + radius; z += 2) {
                int y = this.level().getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        return maxY == Integer.MIN_VALUE ? (int)this.getY() : maxY;
    }

    private void pullAndDamageEntities() {
        int tierIdx = this.getTierIndex();
        double radius = ENTITY_PULL_RADIUS[tierIdx];
        double height = TORNADO_HEIGHT[tierIdx];
        double liftStrength = LIFT_STRENGTH[tierIdx];
        double pullStrength = PULL_STRENGTH[tierIdx];
        double spiralStrength = SPIRAL_STRENGTH[tierIdx];
        float damage = DAMAGE_PER_SECOND[tierIdx] / 20.0f;
        AABB area = new AABB(this.getX() - radius, this.getY() - 10.0, this.getZ() - radius, this.getX() + radius, this.getY() + height + 20.0, this.getZ() + radius);
        List entities = this.level().getEntities((Entity)this, area, e -> e instanceof LivingEntity || e instanceof FallingBlockEntity);
        for (Entity entity : entities) {
            double pullFactor;
            Player player;
            if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator()) || entity instanceof FallingBlockEntity && entity.getTags().contains("TornadoEjected")) continue;
            Vec3 entityPos = entity.position();
            Vec3 tornadoCenter = new Vec3(this.getX(), this.getY(), this.getZ());
            Vec3 toCenter = tornadoCenter.subtract(entityPos);
            double horizontalDist = Math.sqrt(toCenter.x * toCenter.x + toCenter.z * toCenter.z);
            if (horizontalDist < 1.0) {
                horizontalDist = 1.0;
            }
            if ((pullFactor = Math.max(0.0, 1.0 - horizontalDist / radius * 0.7)) < 0.02) continue;
            Vec3 horizontalPull = new Vec3(toCenter.x, 0.0, toCenter.z).normalize();
            Vec3 pullForce = horizontalPull.scale(pullStrength * pullFactor);
            double verticalProgress = Math.max(0.0, (entityPos.y - this.getY()) / height);
            double liftMult = 1.0;
            if (verticalProgress > 0.85) {
                liftMult = 0.2;
            } else if (horizontalDist < radius * 0.25) {
                liftMult = 2.0;
            }
            Vec3 liftForce = new Vec3(0.0, liftStrength * pullFactor * liftMult, 0.0);
            Vec3 tangent = new Vec3(-toCenter.z, 0.0, toCenter.x).normalize();
            Vec3 spiralForce = tangent.scale(spiralStrength * pullFactor);
            Vec3 totalForce = pullForce.add(liftForce).add(spiralForce);
            Vec3 currentVel = entity.getDeltaMovement();
            Vec3 newVel = currentVel.scale(0.75).add(totalForce);
            double maxSpeed = 2.5 + (double)tierIdx * 0.8;
            if (newVel.length() > maxSpeed) {
                newVel = newVel.normalize().scale(maxSpeed);
            }
            entity.setDeltaMovement(newVel);
            entity.hurtMarked = true;
            entity.fallDistance = 0.0f;
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.setNoAi(true);
                mob.addTag("TornadoCaught");
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (horizontalDist < radius * 0.5 && this.tickCount % 5 == 0) {
                    living.hurt(this.damageSources().flyIntoWall(), damage * 5.0f);
                }
            }
            if (!(verticalProgress > 0.9) || !(horizontalDist < radius * 0.4)) continue;
            Vec3 ejectDir = new Vec3(toCenter.x + (this.random.nextDouble() - 0.5) * 2.0, 0.0, toCenter.z + (this.random.nextDouble() - 0.5) * 2.0).normalize().scale(-1.0);
            double ejectPower = 2.0 + (double)tierIdx * 0.5;
            entity.setDeltaMovement(ejectDir.scale(ejectPower).add(0.0, 1.0 + (double)tierIdx * 0.3, 0.0));
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (!entity.getTags().contains("TornadoCaught")) continue;
            mob.setNoAi(false);
            entity.removeTag("TornadoCaught");
        }
    }

    private void pullItems() {
        int tierIdx = this.getTierIndex();
        double radius = BLOCK_GRAB_RADIUS[tierIdx];
        double height = TORNADO_HEIGHT[tierIdx];
        double pullStr = PULL_STRENGTH[tierIdx];
        double liftStr = LIFT_STRENGTH[tierIdx];
        double spiralStr = SPIRAL_STRENGTH[tierIdx];
        AABB area = new AABB(this.getX() - radius * 1.5, this.getY() - 10.0, this.getZ() - radius * 1.5, this.getX() + radius * 1.5, this.getY() + height + 30.0, this.getZ() + radius * 1.5);
        List items = this.level().getEntitiesOfClass(ItemEntity.class, area);
        for (ItemEntity item : items) {
            this.applyVortexPhysics((Entity)item, radius, pullStr, liftStr, spiralStr, height);
        }
        List debris = this.level().getEntitiesOfClass(FallingBlockEntity.class, area);
        for (FallingBlockEntity block : debris) {
            this.applyDebrisPhysics(block, radius, pullStr, liftStr, spiralStr, height);
        }
    }

    private void applyVortexPhysics(Entity entity, double radius, double pullStr, double liftStr, double spiralStr, double height) {
        double pullFactor;
        Vec3 toCenter = new Vec3(this.getX() - entity.getX(), 0.0, this.getZ() - entity.getZ());
        double dist = toCenter.length();
        if (dist < 1.0) {
            dist = 1.0;
        }
        if ((pullFactor = Math.max(0.0, 1.0 - dist / radius * 0.6)) < 0.05) {
            return;
        }
        double verticalProgress = (entity.getY() - this.getY()) / height;
        Vec3 pull = toCenter.normalize().scale(pullStr * pullFactor * 0.8);
        Vec3 lift = new Vec3(0.0, liftStr * pullFactor * (verticalProgress > 0.9 ? 0.2 : 1.2), 0.0);
        Vec3 spiral = new Vec3(-toCenter.z, 0.0, toCenter.x).normalize().scale(spiralStr * pullFactor * 0.7);
        Vec3 currentVel = entity.getDeltaMovement();
        entity.setDeltaMovement(currentVel.scale(0.8).add(pull).add(lift).add(spiral));
        entity.hurtMarked = true;
    }

    private void applyDebrisPhysics(FallingBlockEntity debris, double radius, double pullStr, double liftStr, double spiralStr, double height) {
        if (debris.getTags().contains("TornadoEjected")) {
            return;
        }
        Vec3 toCenter = new Vec3(this.getX() - debris.getX(), 0.0, this.getZ() - debris.getZ());
        double dist = toCenter.length();
        if (dist < 1.0) {
            dist = 1.0;
        }
        double verticalProgress = Math.max(0.0, (debris.getY() - this.getY()) / height);
        int debrisAge = debris.tickCount;
        int maxAge = 30 + this.random.nextInt(30);
        if (debrisAge > maxAge || verticalProgress > 0.5 || debris.getY() > this.getY() + height * 0.6) {
            this.throwDebrisOutward(debris, Math.max(verticalProgress, 0.5));
            return;
        }
        double pullFactor = Math.max(0.0, 1.0 - dist / radius * 0.4);
        if (pullFactor < 0.02) {
            return;
        }
        double targetRadius = 2.0 + verticalProgress * (radius * 0.15);
        double radialForce = (dist - targetRadius) * 0.12;
        Vec3 pull = toCenter.normalize().scale(radialForce + pullStr * pullFactor * 0.7);
        double liftMult = 3.5;
        if (dist < radius * 0.3) {
            liftMult = 5.0;
        }
        Vec3 lift = new Vec3(0.0, liftStr * pullFactor * liftMult, 0.0);
        Vec3 spiral = new Vec3(-toCenter.z, 0.0, toCenter.x).normalize().scale(spiralStr * pullFactor * 1.8);
        Vec3 currentVel = debris.getDeltaMovement();
        Vec3 newVel = currentVel.scale(0.75).add(pull).add(lift).add(spiral);
        double maxSpeed = 6.0 + (double)this.getTierIndex() * 0.8;
        if (newVel.length() > maxSpeed) {
            newVel = newVel.normalize().scale(maxSpeed);
        }
        debris.setDeltaMovement(newVel);
        debris.hurtMarked = true;
        if (debris.time > 200) {
            debris.time = 50;
        }
    }

    private void throwDebrisOutward(FallingBlockEntity debris, double verticalProgress) {
        int tierIdx = this.getTierIndex();
        double throwPower = THROW_POWER[tierIdx];
        double heightBonus = 1.2 + verticalProgress * 1.2;
        double angle = this.random.nextDouble() * Math.PI * 2.0;
        double vx = Math.cos(angle) * (throwPower *= heightBonus);
        double vy = 0.5 + this.random.nextDouble() * 0.8;
        double vz = Math.sin(angle) * throwPower;
        Vec3 currentVel = debris.getDeltaMovement();
        vx += currentVel.x * 0.8;
        vz += currentVel.z * 0.8;
        debris.setDeltaMovement(vx += (this.random.nextDouble() - 0.5) * throwPower * 0.4, vy, vz += (this.random.nextDouble() - 0.5) * throwPower * 0.4);
        debris.addTag("TornadoEjected");
        debris.setHurtsEntities(4.0f + (float)this.getTier() * 2.0f, 80);
    }

    private void destroyBlocks() {
        int tierIdx = this.getTierIndex();
        int maxRadius = BLOCK_BREAK_RADIUS[tierIdx];
        double height = TORNADO_HEIGHT[tierIdx];
        for (int blocksProcessed = 0; blocksProcessed < 5 + tierIdx * 2; ++blocksProcessed) {
            double angleRad = Math.toRadians(this.spiralScanAngle);
            int x = Mth.floor((double)(this.getX() + Math.cos(angleRad) * (double)this.spiralScanRadius));
            int z = Mth.floor((double)(this.getZ() + Math.sin(angleRad) * (double)this.spiralScanRadius));
            int y = Mth.floor((double)this.getY()) + this.spiralScanY;
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = this.level().getBlockState(pos);
            if (this.canBreakBlock(state, pos)) {
                this.destroyAndLaunchBlock(pos, state);
            }
            this.advanceSpiralScan(maxRadius, (int)Math.min(height * 0.5, 30.0));
        }
        if (this.tickCount % 3 == 0) {
            int randomAttempts = 3 + tierIdx * 2;
            for (int i = 0; i < randomAttempts; ++i) {
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                double r = this.random.nextDouble() * (double)maxRadius;
                double yOffset = this.random.nextDouble() * Math.min(height * 0.4, 20.0) - 2.0;
                int rx = Mth.floor((double)(this.getX() + Math.cos(angle) * r));
                int ry = Mth.floor((double)(this.getY() + yOffset));
                int rz = Mth.floor((double)(this.getZ() + Math.sin(angle) * r));
                BlockPos rpos = new BlockPos(rx, ry, rz);
                BlockState rstate = this.level().getBlockState(rpos);
                if (!this.canBreakBlock(rstate, rpos)) continue;
                this.destroyAndLaunchBlock(rpos, rstate);
            }
        }
        if (this.tickCount % 2 == 0) {
            this.destroyVegetationThrottled(maxRadius);
        }
        if (this.tickCount % 4 == 0) {
            this.destroyStructuresAboveThrottled(maxRadius);
        }
    }

    private void advanceSpiralScan(int maxRadius, int maxYOffset) {
        this.spiralScanAngle += 30;
        if (this.spiralScanAngle >= 360) {
            this.spiralScanAngle = 0;
            this.spiralScanRadius += 2;
            if (this.spiralScanRadius > maxRadius) {
                this.spiralScanRadius = 0;
                this.spiralScanY += 3;
                if (this.spiralScanY > maxYOffset) {
                    this.spiralScanY = -5;
                }
            }
        }
    }

    private void destroyStructuresAboveThrottled(int radius) {
        int baseY = Mth.floor((double)this.getY());
        int scanHeight = 30 + this.getTier() * 10;
        int columns = 2 + (this.getTier() > 3 ? 1 : 0);
        block0: for (int i = 0; i < columns; ++i) {
            int startY;
            int x = Mth.floor((double)this.getX()) + this.random.nextInt(radius * 2 + 1) - radius;
            int z = Mth.floor((double)this.getZ()) + this.random.nextInt(radius * 2 + 1) - radius;
            for (int y = startY = baseY + this.tickCount / 4 * 5 % scanHeight; y < Math.min(startY + 5, baseY + scanHeight); ++y) {
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = this.level().getBlockState(pos);
                if (!this.canBreakBlock(state, pos)) continue;
                this.destroyAndLaunchBlock(pos, state);
                continue block0;
            }
        }
    }

    private boolean canBreakBlock(BlockState state, BlockPos pos) {
        if (state.isAir()) {
            return false;
        }
        float hardness = state.getDestroySpeed((BlockGetter)this.level(), pos);
        if (hardness < 0.0f || hardness > 50.0f) {
            return false;
        }
        int tier = this.getTier();
        float maxHardness = switch (tier) {
            case 1 -> 1.0f;
            case 2 -> 2.0f;
            case 3 -> 3.5f;
            case 4 -> 6.0f;
            case 5 -> 50.0f;
            default -> 1.0f;
        };
        return hardness <= maxHardness;
    }

    private void destroyAndLaunchBlock(BlockPos pos, BlockState state) {
        Level level;
        this.level().removeBlock(pos, false);
        FallingBlockEntity fallingBlock = FallingBlockEntity.fall((Level)this.level(), (BlockPos)pos, (BlockState)state);
        if (fallingBlock != null) {
            double dz;
            int tierIdx = this.getTierIndex();
            double dx = this.getX() - (double)pos.getX();
            double dist = Math.sqrt(dx * dx + (dz = this.getZ() - (double)pos.getZ()) * dz);
            if (dist < 1.0) {
                dist = 1.0;
            }
            double pullX = dx / dist;
            double pullZ = dz / dist;
            double spiralX = -pullZ;
            double spiralZ = pullX;
            double pullPower = PULL_STRENGTH[tierIdx] * 0.8;
            double spiralPower = SPIRAL_STRENGTH[tierIdx] * 0.6;
            double liftPower = LIFT_STRENGTH[tierIdx] * 1.5;
            double vx = pullX * pullPower + spiralX * spiralPower + (this.random.nextDouble() - 0.5) * 0.3;
            double vy = liftPower + this.random.nextDouble() * 0.5;
            double vz = pullZ * pullPower + spiralZ * spiralPower + (this.random.nextDouble() - 0.5) * 0.3;
            fallingBlock.setDeltaMovement(vx, vy, vz);
            fallingBlock.dropItem = false;
            fallingBlock.setHurtsEntities(2.0f + (float)this.getTier(), 40);
            fallingBlock.time = -100;
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.playSound(null, pos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS, 0.7f, 0.7f + this.random.nextFloat() * 0.3f);
        }
    }

    private void grabWater() {
        int tierIdx = this.getTierIndex();
        int radius = BLOCK_BREAK_RADIUS[tierIdx];
        if (this.tickCount % (6 - this.getTier()) != 0) {
            return;
        }
        int attempts = 3 + this.getTier() * 2;
        block0: for (int i = 0; i < attempts; ++i) {
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            double r = this.random.nextDouble() * (double)radius;
            int x = Mth.floor((double)(this.getX() + Math.cos(angle) * r));
            int z = Mth.floor((double)(this.getZ() + Math.sin(angle) * r));
            for (int y = Mth.floor((double)this.getY()) - 5; y < Mth.floor((double)this.getY()) + 10; ++y) {
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = this.level().getBlockState(pos);
                if (!state.is(Blocks.WATER)) continue;
                this.launchWaterBlock(pos);
                continue block0;
            }
        }
    }

    private void launchWaterBlock(BlockPos pos) {
        Level level;
        this.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        BlockState waterRepresentation = Blocks.BLUE_ICE.defaultBlockState();
        FallingBlockEntity waterBlock = FallingBlockEntity.fall((Level)this.level(), (BlockPos)pos, (BlockState)waterRepresentation);
        if (waterBlock != null) {
            double dz;
            int tierIdx = this.getTierIndex();
            double dx = this.getX() - (double)pos.getX();
            double dist = Math.sqrt(dx * dx + (dz = this.getZ() - (double)pos.getZ()) * dz);
            if (dist < 1.0) {
                dist = 1.0;
            }
            double pullX = dx / dist;
            double pullZ = dz / dist;
            double spiralX = -pullZ;
            double spiralZ = pullX;
            double pullPower = PULL_STRENGTH[tierIdx] * 1.0;
            double spiralPower = SPIRAL_STRENGTH[tierIdx] * 0.8;
            double liftPower = LIFT_STRENGTH[tierIdx] * 2.0;
            double vx = pullX * pullPower + spiralX * spiralPower;
            double vy = liftPower + this.random.nextDouble() * 0.8;
            double vz = pullZ * pullPower + spiralZ * spiralPower;
            waterBlock.setDeltaMovement(vx, vy, vz);
            waterBlock.dropItem = false;
            waterBlock.time = -200;
            waterBlock.addTag("TornadoWater");
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.3, 0.3, 0.3, 0.1);
        }
    }

    private void destroyVegetationThrottled(int radius) {
        int scanRadius = radius + 5;
        int baseY = Mth.floor((double)this.getY());
        int slice = this.tickCount / 2 % 12;
        double startAngle = (double)slice * 0.5235987755982988;
        double endAngle = startAngle + 0.5235987755982988;
        int processed = 0;
        int maxProcess = 8 + this.getTier() * 2;
        for (int r = 2; r <= scanRadius && processed < maxProcess; r += 3) {
            block1: for (double angle = startAngle; angle < endAngle && processed < maxProcess; angle += 0.3) {
                int dx = (int)(Math.cos(angle) * (double)r);
                int dz = (int)(Math.sin(angle) * (double)r);
                int x = Mth.floor((double)this.getX()) + dx;
                int z = Mth.floor((double)this.getZ()) + dz;
                int surfaceY = this.level().getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
                for (int y = baseY; y < surfaceY + 10 && y < baseY + 30; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.level().getBlockState(pos);
                    if (!this.isVegetation(state)) continue;
                    this.destroyAndLaunchBlock(pos, state);
                    ++processed;
                    continue block1;
                }
            }
        }
    }

    private boolean isVegetation(BlockState state) {
        return state.getBlock() instanceof LeavesBlock || state.is(BlockTags.FLOWERS) || state.is(BlockTags.CROPS) || state.is(BlockTags.SAPLINGS) || state.is(Blocks.TALL_GRASS) || state.is(Blocks.SHORT_GRASS) || state.is(Blocks.FERN) || state.is(Blocks.LARGE_FERN) || state.is(Blocks.VINE) || state.is(Blocks.DEAD_BUSH);
    }

    private void spawnLightning() {
        Level level;
        int chance;
        if (this.getTier() < 3) {
            return;
        }
        switch (this.getTier()) {
            case 3: {
                int n = 800;
                break;
            }
            case 4: {
                int n = 400;
                break;
            }
            case 5: {
                int n = 200;
                break;
            }
            default: {
                int n = chance = 1000;
            }
        }
        if (this.random.nextInt(chance) == 0 && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double radius = ENTITY_PULL_RADIUS[this.getTierIndex()];
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            double dist = this.random.nextDouble() * radius * 1.5;
            double lx = this.getX() + Math.cos(angle) * dist;
            double lz = this.getZ() + Math.sin(angle) * dist;
            int ly = serverLevel.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)lx, (int)lz);
            LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
            if (lightning != null) {
                lightning.moveTo(lx, (double)ly, lz);
                lightning.setVisualOnly(false);
                serverLevel.addFreshEntity((Entity)lightning);
            }
        }
    }
}

