/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.client.CloudVolumetricRenderer;
import com.example.examplemod.tornado;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="tornado", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class CloudRenderHandler {
    private static CloudStatus originalCloudSetting = null;
    private static boolean volumetricCloudsEnabled = true;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (volumetricCloudsEnabled && mc.options != null) {
            if (originalCloudSetting == null) {
                originalCloudSetting = mc.options.getCloudsType();
            }
            if (mc.options.getCloudsType() != CloudStatus.OFF) {
                mc.options.cloudStatus().set((Object)CloudStatus.OFF);
            }
        }
    }

    public static void enableVolumetricClouds() {
        volumetricCloudsEnabled = true;
        CloudVolumetricRenderer.getInstance().setEnabled(true);
        Minecraft mc = Minecraft.getInstance();
        if (mc.options != null) {
            if (originalCloudSetting == null) {
                originalCloudSetting = mc.options.getCloudsType();
            }
            mc.options.cloudStatus().set((Object)CloudStatus.OFF);
        }
        tornado.LOGGER.info("Volumetric clouds enabled, vanilla clouds disabled");
    }

    public static void disableVolumetricClouds() {
        volumetricCloudsEnabled = false;
        CloudVolumetricRenderer.getInstance().setEnabled(false);
        Minecraft mc = Minecraft.getInstance();
        if (mc.options != null && originalCloudSetting != null) {
            mc.options.cloudStatus().set((Object)originalCloudSetting);
        }
        tornado.LOGGER.info("Volumetric clouds disabled, vanilla clouds restored");
    }

    public static void toggleVolumetricClouds() {
        if (volumetricCloudsEnabled) {
            CloudRenderHandler.disableVolumetricClouds();
        } else {
            CloudRenderHandler.enableVolumetricClouds();
        }
    }

    public static boolean isVolumetricCloudsEnabled() {
        return volumetricCloudsEnabled;
    }

    public static void setCloudCoverage(float coverage) {
        CloudVolumetricRenderer.getInstance().setCloudCoverage(coverage);
    }

    public static void setCloudAltitude(float altitude) {
        CloudVolumetricRenderer.getInstance().setCloudAltitude(altitude);
    }
}

