/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.tornado;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public class CloudShaderManager {
    private static CloudShaderManager instance;
    private int shaderProgram = -1;
    private int vertexShader = -1;
    private int fragmentShader = -1;
    private int uCameraPosLoc = -1;
    private int uInvViewProjMatLoc = -1;
    private int uViewProjMatLoc = -1;
    private int uTimeLoc = -1;
    private int uSunDirectionLoc = -1;
    private int uSunIntensityLoc = -1;
    private int uScreenSizeLoc = -1;
    private int uCloudCoverageLoc = -1;
    private int uCloudAltitudeLoc = -1;
    private int uCloudThicknessLoc = -1;
    private int uWindDirectionLoc = -1;
    private int uWindSpeedLoc = -1;
    private int uStormActiveLoc = -1;
    private int uStormCenterLoc = -1;
    private int uStormRadiusLoc = -1;
    private int uDepthTextureLoc = -1;
    private int uQualityLevelLoc = -1;
    private int uFrustumCornersLoc = -1;
    private int uCameraLookLoc = -1;
    private int uCameraUpLoc = -1;
    private int uCameraRightLoc = -1;
    private int uModelViewMatLoc = -1;
    private int uProjMatLoc = -1;
    private int uFovScaleLoc = -1;
    private final FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);
    private boolean initialized = false;
    private boolean loadFailed = false;

    public static CloudShaderManager getInstance() {
        if (instance == null) {
            instance = new CloudShaderManager();
        }
        return instance;
    }

    private CloudShaderManager() {
    }

    public void initialize() {
        if (this.initialized || this.loadFailed) {
            return;
        }
        try {
            tornado.LOGGER.info("Initializing volumetric cloud shader...");
            String vertexSource = this.loadShaderSource("tornado:shaders/core/clouds_volumetric.vsh");
            String fragmentSource = this.loadShaderSource("tornado:shaders/core/clouds_volumetric.fsh");
            if (vertexSource == null || fragmentSource == null) {
                tornado.LOGGER.error("Failed to load cloud shader source files");
                this.loadFailed = true;
                return;
            }
            this.vertexShader = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)this.vertexShader, (CharSequence)vertexSource);
            GL20.glCompileShader((int)this.vertexShader);
            if (GL20.glGetShaderi((int)this.vertexShader, (int)35713) == 0) {
                String log = GL20.glGetShaderInfoLog((int)this.vertexShader);
                tornado.LOGGER.error("Cloud vertex shader compilation failed: {}", (Object)log);
                this.cleanup();
                this.loadFailed = true;
                return;
            }
            this.fragmentShader = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)this.fragmentShader, (CharSequence)fragmentSource);
            GL20.glCompileShader((int)this.fragmentShader);
            if (GL20.glGetShaderi((int)this.fragmentShader, (int)35713) == 0) {
                String log = GL20.glGetShaderInfoLog((int)this.fragmentShader);
                tornado.LOGGER.error("Cloud fragment shader compilation failed: {}", (Object)log);
                this.cleanup();
                this.loadFailed = true;
                return;
            }
            this.shaderProgram = GL20.glCreateProgram();
            GL20.glAttachShader((int)this.shaderProgram, (int)this.vertexShader);
            GL20.glAttachShader((int)this.shaderProgram, (int)this.fragmentShader);
            GL20.glBindAttribLocation((int)this.shaderProgram, (int)0, (CharSequence)"Position");
            GL20.glBindAttribLocation((int)this.shaderProgram, (int)1, (CharSequence)"UV0");
            GL20.glLinkProgram((int)this.shaderProgram);
            if (GL20.glGetProgrami((int)this.shaderProgram, (int)35714) == 0) {
                String log = GL20.glGetProgramInfoLog((int)this.shaderProgram);
                tornado.LOGGER.error("Cloud shader program linking failed: {}", (Object)log);
                this.cleanup();
                this.loadFailed = true;
                return;
            }
            this.cacheUniformLocations();
            this.initialized = true;
            tornado.LOGGER.info("Volumetric cloud shader initialized successfully!");
        }
        catch (Exception e) {
            tornado.LOGGER.error("Exception during cloud shader initialization", (Throwable)e);
            this.cleanup();
            this.loadFailed = true;
        }
    }

    private void cacheUniformLocations() {
        this.uCameraPosLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uCameraPos");
        this.uInvViewProjMatLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uInvViewProjMat");
        this.uViewProjMatLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uViewProjMat");
        this.uTimeLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uTime");
        this.uSunDirectionLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uSunDirection");
        this.uSunIntensityLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uSunIntensity");
        this.uScreenSizeLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uScreenSize");
        this.uCloudCoverageLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uCloudCoverage");
        this.uCloudAltitudeLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uCloudAltitude");
        this.uCloudThicknessLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uCloudThickness");
        this.uWindDirectionLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uWindDirection");
        this.uWindSpeedLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uWindSpeed");
        this.uStormActiveLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uStormActive");
        this.uStormCenterLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uStormCenter");
        this.uStormRadiusLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uStormRadius");
        this.uDepthTextureLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uDepthTexture");
        this.uQualityLevelLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uQualityLevel");
        this.uFrustumCornersLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uFrustumCorners");
        this.uCameraLookLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uCameraLook");
        this.uCameraUpLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uCameraUp");
        this.uCameraRightLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uCameraRight");
        this.uModelViewMatLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"ModelViewMat");
        this.uProjMatLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"ProjMat");
        this.uFovScaleLoc = GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"uFovScale");
    }

    private String loadShaderSource(String path) {
        String string;
        ResourceLocation location = ResourceLocation.parse((String)path);
        String resourcePath = "/assets/" + location.getNamespace() + "/" + location.getPath();
        InputStream stream = CloudShaderManager.class.getResourceAsStream(resourcePath);
        if (stream == null) {
            tornado.LOGGER.error("Could not find cloud shader resource: {}", (Object)resourcePath);
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                tornado.LOGGER.error("Failed to load cloud shader: {}", (Object)path, (Object)e);
                return null;
            }
        }
        reader.close();
        return string;
    }

    public void bind() {
        if (!this.initialized || this.loadFailed) {
            return;
        }
        GL20.glUseProgram((int)this.shaderProgram);
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    public boolean isReady() {
        return this.initialized && !this.loadFailed;
    }

    public void setCameraPosition(float x, float y, float z) {
        if (this.uCameraPosLoc >= 0) {
            GL20.glUniform3f((int)this.uCameraPosLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setInverseViewProjectionMatrix(Matrix4f matrix) {
        if (this.uInvViewProjMatLoc >= 0) {
            this.matrixBuffer.clear();
            matrix.get(this.matrixBuffer);
            GL20.glUniformMatrix4fv((int)this.uInvViewProjMatLoc, (boolean)false, (FloatBuffer)this.matrixBuffer);
        }
    }

    public void setTime(float time) {
        if (this.uTimeLoc >= 0) {
            GL20.glUniform1f((int)this.uTimeLoc, (float)time);
        }
    }

    public void setSunDirection(float x, float y, float z) {
        if (this.uSunDirectionLoc >= 0) {
            GL20.glUniform3f((int)this.uSunDirectionLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setSunIntensity(float intensity) {
        if (this.uSunIntensityLoc >= 0) {
            GL20.glUniform1f((int)this.uSunIntensityLoc, (float)intensity);
        }
    }

    public void setScreenSize(float width, float height) {
        if (this.uScreenSizeLoc >= 0) {
            GL20.glUniform2f((int)this.uScreenSizeLoc, (float)width, (float)height);
        }
    }

    public void setCloudCoverage(float coverage) {
        if (this.uCloudCoverageLoc >= 0) {
            GL20.glUniform1f((int)this.uCloudCoverageLoc, (float)coverage);
        }
    }

    public void setCloudAltitude(float altitude) {
        if (this.uCloudAltitudeLoc >= 0) {
            GL20.glUniform1f((int)this.uCloudAltitudeLoc, (float)altitude);
        }
    }

    public void setCloudThickness(float thickness) {
        if (this.uCloudThicknessLoc >= 0) {
            GL20.glUniform1f((int)this.uCloudThicknessLoc, (float)thickness);
        }
    }

    public void setWindDirection(float x, float y, float z) {
        if (this.uWindDirectionLoc >= 0) {
            GL20.glUniform3f((int)this.uWindDirectionLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setWindSpeed(float speed) {
        if (this.uWindSpeedLoc >= 0) {
            GL20.glUniform1f((int)this.uWindSpeedLoc, (float)speed);
        }
    }

    public void setStormActive(boolean active) {
        if (this.uStormActiveLoc >= 0) {
            GL20.glUniform1i((int)this.uStormActiveLoc, (int)(active ? 1 : 0));
        }
    }

    public void setStormCenter(float x, float y, float z) {
        if (this.uStormCenterLoc >= 0) {
            GL20.glUniform3f((int)this.uStormCenterLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setStormRadius(float radius) {
        if (this.uStormRadiusLoc >= 0) {
            GL20.glUniform1f((int)this.uStormRadiusLoc, (float)radius);
        }
    }

    public void setDepthTexture(int textureUnit) {
        if (this.uDepthTextureLoc >= 0) {
            GL20.glUniform1i((int)this.uDepthTextureLoc, (int)textureUnit);
        }
    }

    public void setViewProjectionMatrix(Matrix4f matrix) {
        if (this.uViewProjMatLoc >= 0) {
            this.matrixBuffer.clear();
            matrix.get(this.matrixBuffer);
            GL20.glUniformMatrix4fv((int)this.uViewProjMatLoc, (boolean)false, (FloatBuffer)this.matrixBuffer);
        }
    }

    public void setQualityLevel(int level) {
        if (this.uQualityLevelLoc >= 0) {
            GL20.glUniform1i((int)this.uQualityLevelLoc, (int)level);
        }
    }

    public void setCameraLook(float x, float y, float z) {
        if (this.uCameraLookLoc >= 0) {
            GL20.glUniform3f((int)this.uCameraLookLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setCameraUp(float x, float y, float z) {
        if (this.uCameraUpLoc >= 0) {
            GL20.glUniform3f((int)this.uCameraUpLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setCameraRight(float x, float y, float z) {
        if (this.uCameraRightLoc >= 0) {
            GL20.glUniform3f((int)this.uCameraRightLoc, (float)x, (float)y, (float)z);
        }
    }

    public void setFrustumCorners(float[] corners) {
        if (this.uFrustumCornersLoc >= 0 && corners.length >= 12) {
            GL20.glUniform3fv((int)this.uFrustumCornersLoc, (float[])corners);
        }
    }

    public void setModelViewMatrix(Matrix4f matrix) {
        if (this.uModelViewMatLoc >= 0) {
            this.matrixBuffer.clear();
            matrix.get(this.matrixBuffer);
            GL20.glUniformMatrix4fv((int)this.uModelViewMatLoc, (boolean)false, (FloatBuffer)this.matrixBuffer);
        }
    }

    public void setProjectionMatrix(Matrix4f matrix) {
        if (this.uProjMatLoc >= 0) {
            this.matrixBuffer.clear();
            matrix.get(this.matrixBuffer);
            GL20.glUniformMatrix4fv((int)this.uProjMatLoc, (boolean)false, (FloatBuffer)this.matrixBuffer);
        }
    }

    public void setFovScale(float tanHalfFov, float aspectRatio) {
        if (this.uFovScaleLoc >= 0) {
            GL20.glUniform2f((int)this.uFovScaleLoc, (float)tanHalfFov, (float)aspectRatio);
        }
    }

    public void cleanup() {
        if (this.shaderProgram > 0) {
            GL20.glDeleteProgram((int)this.shaderProgram);
            this.shaderProgram = -1;
        }
        if (this.vertexShader > 0) {
            GL20.glDeleteShader((int)this.vertexShader);
            this.vertexShader = -1;
        }
        if (this.fragmentShader > 0) {
            GL20.glDeleteShader((int)this.fragmentShader);
            this.fragmentShader = -1;
        }
        this.initialized = false;
    }
}

