/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.TornadoEntity;
import com.example.examplemod.client.CloudShaderManager;
import com.example.examplemod.tornado;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class CloudVolumetricRenderer {
    private static CloudVolumetricRenderer instance;
    private RenderTarget cloudTarget;
    private int targetWidth = 0;
    private int targetHeight = 0;
    private int quadVAO = -1;
    private int quadVBO = -1;
    private int domeVAO = -1;
    private int domeVBO = -1;
    private int domeVertexCount = 0;
    private float cloudCoverage = 0.5f;
    private float cloudAltitude = 192.0f;
    private float cloudThickness = 64.0f;
    private float windSpeed = 1.0f;
    private Vector3f windDirection = new Vector3f(1.0f, 0.0f, 0.3f).normalize();
    private RenderTarget previousFrame;
    private Matrix4f previousViewProjMatrix = new Matrix4f();
    private boolean hasPreviousFrame = false;
    private boolean enabled = true;
    private long lastFrameTime = 0L;
    private float smoothedFrameTime = 16.0f;
    private int qualityLevel = 1;
    private Matrix4f currentViewProjMatrix = new Matrix4f();
    private static final float RESOLUTION_SCALE = 0.5f;

    public static CloudVolumetricRenderer getInstance() {
        if (instance == null) {
            instance = new CloudVolumetricRenderer();
        }
        return instance;
    }

    private CloudVolumetricRenderer() {
    }

    public void initialize() {
        CloudShaderManager.getInstance().initialize();
        this.createFullscreenQuad();
        this.createSkyDome();
        tornado.LOGGER.info("CloudVolumetricRenderer initialized");
    }

    private void createSkyDome() {
        if (this.domeVAO > 0) {
            return;
        }
        int rings = 16;
        int segments = 32;
        float radius = 1.0f;
        ArrayList<Float> vertices = new ArrayList<Float>();
        for (int ring = 0; ring < rings; ++ring) {
            float phi1 = (float)(1.5707963267948966 * (double)ring / (double)rings);
            float phi2 = (float)(1.5707963267948966 * (double)(ring + 1) / (double)rings);
            float y1 = (float)Math.sin(phi1);
            float y2 = (float)Math.sin(phi2);
            float r1 = (float)Math.cos(phi1);
            float r2 = (float)Math.cos(phi2);
            for (int seg = 0; seg < segments; ++seg) {
                float theta1 = (float)(Math.PI * 2 * (double)seg / (double)segments);
                float theta2 = (float)(Math.PI * 2 * (double)(seg + 1) / (double)segments);
                float x1 = (float)Math.cos(theta1);
                float z1 = (float)Math.sin(theta1);
                float x2 = (float)Math.cos(theta2);
                float z2 = (float)Math.sin(theta2);
                this.addDomeVertex(vertices, x1 * r1 * radius, y1 * radius, z1 * r1 * radius);
                this.addDomeVertex(vertices, x1 * r2 * radius, y2 * radius, z1 * r2 * radius);
                this.addDomeVertex(vertices, x2 * r1 * radius, y1 * radius, z2 * r1 * radius);
                this.addDomeVertex(vertices, x2 * r1 * radius, y1 * radius, z2 * r1 * radius);
                this.addDomeVertex(vertices, x1 * r2 * radius, y2 * radius, z1 * r2 * radius);
                this.addDomeVertex(vertices, x2 * r2 * radius, y2 * radius, z2 * r2 * radius);
            }
        }
        float[] vertexArray = new float[vertices.size()];
        for (int i = 0; i < vertices.size(); ++i) {
            vertexArray[i] = ((Float)vertices.get(i)).floatValue();
        }
        this.domeVertexCount = vertices.size() / 5;
        this.domeVAO = GL30.glGenVertexArrays();
        this.domeVBO = GL30.glGenBuffers();
        GL30.glBindVertexArray((int)this.domeVAO);
        GL30.glBindBuffer((int)34962, (int)this.domeVBO);
        GL30.glBufferData((int)34962, (float[])vertexArray, (int)35044);
        GL30.glEnableVertexAttribArray((int)0);
        GL30.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)20, (long)0L);
        GL30.glEnableVertexAttribArray((int)1);
        GL30.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)20, (long)12L);
        GL30.glBindVertexArray((int)0);
        tornado.LOGGER.debug("Created sky dome with {} vertices", (Object)this.domeVertexCount);
    }

    private void addDomeVertex(List<Float> vertices, float x, float y, float z) {
        vertices.add(Float.valueOf(x));
        vertices.add(Float.valueOf(y));
        vertices.add(Float.valueOf(z));
        vertices.add(Float.valueOf((x + 1.0f) * 0.5f));
        vertices.add(Float.valueOf((z + 1.0f) * 0.5f));
    }

    private void createFullscreenQuad() {
        if (this.quadVAO > 0) {
            return;
        }
        float[] quadVertices = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.quadVAO = GL30.glGenVertexArrays();
        this.quadVBO = GL30.glGenBuffers();
        GL30.glBindVertexArray((int)this.quadVAO);
        GL30.glBindBuffer((int)34962, (int)this.quadVBO);
        GL30.glBufferData((int)34962, (float[])quadVertices, (int)35044);
        GL30.glEnableVertexAttribArray((int)0);
        GL30.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)20, (long)0L);
        GL30.glEnableVertexAttribArray((int)1);
        GL30.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)20, (long)12L);
        GL30.glBindVertexArray((int)0);
    }

    private void updateRenderTarget(int screenWidth, int screenHeight) {
        int newWidth = (int)((float)screenWidth * 0.5f);
        int newHeight = (int)((float)screenHeight * 0.5f);
        if (this.cloudTarget == null || this.targetWidth != newWidth || this.targetHeight != newHeight) {
            if (this.cloudTarget != null) {
                this.cloudTarget.destroyBuffers();
            }
            if (this.previousFrame != null) {
                this.previousFrame.destroyBuffers();
            }
            this.cloudTarget = new TextureTarget(newWidth, newHeight, false, Minecraft.ON_OSX);
            this.cloudTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.previousFrame = new TextureTarget(newWidth, newHeight, false, Minecraft.ON_OSX);
            this.previousFrame.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.targetWidth = newWidth;
            this.targetHeight = newHeight;
            this.hasPreviousFrame = false;
            tornado.LOGGER.debug("Created cloud render targets: {}x{}", (Object)newWidth, (Object)newHeight);
        }
    }

    public void render(PoseStack poseStack, float partialTicks, Camera camera) {
        if (!this.enabled || !CloudShaderManager.getInstance().isReady()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        long currentTime = System.nanoTime();
        if (this.lastFrameTime > 0L) {
            float frameTime = (float)(currentTime - this.lastFrameTime) / 1000000.0f;
            this.smoothedFrameTime = this.smoothedFrameTime * 0.95f + frameTime * 0.05f;
            if (this.smoothedFrameTime > 33.3f && this.qualityLevel > 0) {
                --this.qualityLevel;
                tornado.LOGGER.debug("Cloud quality reduced to {} due to low FPS", (Object)this.qualityLevel);
            } else if (this.smoothedFrameTime < 16.0f && this.qualityLevel < 2) {
                ++this.qualityLevel;
                tornado.LOGGER.debug("Cloud quality increased to {} due to high FPS", (Object)this.qualityLevel);
            }
        }
        this.lastFrameTime = currentTime;
        Vec3 cameraPos = camera.getPosition();
        float pitch = camera.getXRot();
        float yaw = camera.getYRot();
        float pitchRad = (float)Math.toRadians(pitch);
        float yawRad = (float)Math.toRadians(yaw);
        Matrix4f viewMatrix = new Matrix4f();
        viewMatrix.rotateX(pitchRad);
        viewMatrix.rotateY(yawRad + (float)Math.PI);
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f viewProjMatrix = new Matrix4f((Matrix4fc)projectionMatrix).mul((Matrix4fc)viewMatrix);
        Matrix4f invViewProjMatrix = new Matrix4f((Matrix4fc)viewProjMatrix).invert();
        this.currentViewProjMatrix = viewProjMatrix;
        float sunAngle = level.getTimeOfDay(partialTicks) * ((float)Math.PI * 2);
        Vector3f sunDirection = new Vector3f((float)Math.cos(sunAngle), (float)Math.sin(sunAngle), 0.3f);
        sunDirection.normalize();
        float daylight = level.getSkyDarken();
        float sunIntensity = 1.0f - daylight;
        TornadoEntity nearestTornado = this.findNearestTornado((Level)level, cameraPos);
        this.renderCloudsToTarget(invViewProjMatrix, cameraPos, sunDirection, sunIntensity, partialTicks, nearestTornado, camera);
        this.previousViewProjMatrix.set((Matrix4fc)viewProjMatrix);
        this.hasPreviousFrame = true;
    }

    private TornadoEntity findNearestTornado(Level level, Vec3 cameraPos) {
        double maxDist = 500.0;
        AABB searchBox = new AABB(cameraPos.x - maxDist, cameraPos.y - 200.0, cameraPos.z - maxDist, cameraPos.x + maxDist, cameraPos.y + 300.0, cameraPos.z + maxDist);
        List tornadoes = level.getEntitiesOfClass(TornadoEntity.class, searchBox);
        TornadoEntity nearest = null;
        double nearestDist = Double.MAX_VALUE;
        for (TornadoEntity tornado2 : tornadoes) {
            double dist = tornado2.position().distanceTo(cameraPos);
            if (!(dist < nearestDist)) continue;
            nearestDist = dist;
            nearest = tornado2;
        }
        return nearest;
    }

    private void renderCloudsToTarget(Matrix4f invViewProjMatrix, Vec3 cameraPos, Vector3f sunDirection, float sunIntensity, float partialTicks, TornadoEntity tornadoEntity, Camera camera) {
        CloudShaderManager shader = CloudShaderManager.getInstance();
        Minecraft mc = Minecraft.getInstance();
        if (this.quadVAO <= 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        shader.bind();
        int depthTextureId = mc.getMainRenderTarget().getDepthTextureId();
        GL30.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)depthTextureId);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        shader.setDepthTexture(0);
        int screenWidth = mc.getWindow().getWidth();
        int screenHeight = mc.getWindow().getHeight();
        double fov = ((Integer)mc.options.fov().get()).intValue();
        float fovRadians = (float)Math.toRadians(fov);
        float tanHalfFov = (float)Math.tan((double)fovRadians / 2.0);
        float aspectRatio = (float)screenWidth / (float)screenHeight;
        Vector3f lookVec = new Vector3f((Vector3fc)camera.getLookVector()).normalize();
        Vector3f upVec = new Vector3f((Vector3fc)camera.getUpVector()).normalize();
        Vector3f rightVec = new Vector3f();
        lookVec.cross((Vector3fc)upVec, rightVec).normalize();
        rightVec.cross((Vector3fc)lookVec, upVec).normalize();
        shader.setCameraPosition((float)cameraPos.x, (float)cameraPos.y, (float)cameraPos.z);
        shader.setCameraLook(lookVec.x, lookVec.y, lookVec.z);
        shader.setCameraUp(upVec.x, upVec.y, upVec.z);
        shader.setCameraRight(rightVec.x, rightVec.y, rightVec.z);
        shader.setFovScale(tanHalfFov, aspectRatio);
        shader.setInverseViewProjectionMatrix(invViewProjMatrix);
        shader.setViewProjectionMatrix(this.currentViewProjMatrix);
        shader.setTime((float)mc.level.getGameTime() + partialTicks);
        shader.setSunDirection(sunDirection.x, sunDirection.y, sunDirection.z);
        shader.setSunIntensity(sunIntensity);
        shader.setScreenSize(screenWidth, screenHeight);
        shader.setCloudCoverage(this.cloudCoverage);
        shader.setCloudAltitude(this.cloudAltitude);
        shader.setCloudThickness(this.cloudThickness);
        shader.setWindDirection(this.windDirection.x, this.windDirection.y, this.windDirection.z);
        shader.setWindSpeed(this.windSpeed);
        shader.setQualityLevel(this.qualityLevel);
        if (tornadoEntity != null) {
            shader.setStormActive(true);
            shader.setStormCenter((float)tornadoEntity.getX(), (float)tornadoEntity.getY(), (float)tornadoEntity.getZ());
            float stormRadius = 50.0f + (float)tornadoEntity.getTier() * 30.0f;
            shader.setStormRadius(stormRadius);
        } else {
            shader.setStormActive(false);
        }
        GL30.glBindVertexArray((int)this.quadVAO);
        GL30.glDrawArrays((int)4, (int)0, (int)6);
        GL30.glBindVertexArray((int)0);
        shader.unbind();
        GL30.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)0);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCloudCoverage(float coverage) {
        this.cloudCoverage = Math.max(0.0f, Math.min(1.0f, coverage));
    }

    public void setCloudAltitude(float altitude) {
        this.cloudAltitude = altitude;
    }

    public void setCloudThickness(float thickness) {
        this.cloudThickness = thickness;
    }

    public void setWindSpeed(float speed) {
        this.windSpeed = speed;
    }

    public void setWindDirection(Vector3f direction) {
        this.windDirection.set((Vector3fc)direction).normalize();
    }

    public void setQualityLevel(int level) {
        this.qualityLevel = Math.max(0, Math.min(2, level));
    }

    public int getQualityLevel() {
        return this.qualityLevel;
    }

    public float getSmoothedFrameTime() {
        return this.smoothedFrameTime;
    }

    public void cleanup() {
        if (this.quadVAO > 0) {
            GL30.glDeleteVertexArrays((int)this.quadVAO);
            this.quadVAO = -1;
        }
        if (this.quadVBO > 0) {
            GL30.glDeleteBuffers((int)this.quadVBO);
            this.quadVBO = -1;
        }
        if (this.domeVAO > 0) {
            GL30.glDeleteVertexArrays((int)this.domeVAO);
            this.domeVAO = -1;
        }
        if (this.domeVBO > 0) {
            GL30.glDeleteBuffers((int)this.domeVBO);
            this.domeVBO = -1;
        }
        if (this.cloudTarget != null) {
            this.cloudTarget.destroyBuffers();
            this.cloudTarget = null;
        }
        if (this.previousFrame != null) {
            this.previousFrame.destroyBuffers();
            this.previousFrame = null;
        }
        CloudShaderManager.getInstance().cleanup();
    }
}

