/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.tornado;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Random;
import net.minecraft.client.renderer.texture.DynamicTexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class NoiseTextureGenerator {
    private static NoiseTextureGenerator instance;
    private DynamicTexture perlinNoiseTexture;
    private DynamicTexture worleyNoiseTexture;
    private int perlinTextureId = -1;
    private int worleyTextureId = -1;
    private static final int TEXTURE_SIZE = 128;

    public static NoiseTextureGenerator getInstance() {
        if (instance == null) {
            instance = new NoiseTextureGenerator();
        }
        return instance;
    }

    private NoiseTextureGenerator() {
    }

    public void initialize() {
        this.generatePerlinNoiseTexture();
        this.generateWorleyNoiseTexture();
        tornado.LOGGER.info("Noise textures generated successfully");
    }

    private void generatePerlinNoiseTexture() {
        try {
            NativeImage image = new NativeImage(128, 128, false);
            Random random = new Random(12345L);
            float[][][] gradients = this.generateGradients(16, random);
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    float nx = (float)x / 128.0f * 4.0f;
                    float ny = (float)y / 128.0f * 4.0f;
                    float value = 0.0f;
                    float amplitude = 1.0f;
                    float frequency = 1.0f;
                    float maxValue = 0.0f;
                    for (int octave = 0; octave < 4; ++octave) {
                        value += this.perlinNoise2D(nx * frequency, ny * frequency, gradients) * amplitude;
                        maxValue += amplitude;
                        amplitude *= 0.5f;
                        frequency *= 2.0f;
                    }
                    value /= maxValue;
                    value = (value + 1.0f) * 0.5f;
                    int gray = (int)(value * 255.0f);
                    gray = Math.max(0, Math.min(255, gray));
                    int color = 0xFF000000 | gray << 16 | gray << 8 | gray;
                    image.setPixelRGBA(x, y, color);
                }
            }
            this.perlinNoiseTexture = new DynamicTexture(image);
            this.perlinTextureId = this.perlinNoiseTexture.getId();
        }
        catch (Exception e) {
            tornado.LOGGER.error("Failed to generate Perlin noise texture", (Throwable)e);
        }
    }

    private void generateWorleyNoiseTexture() {
        try {
            NativeImage image = new NativeImage(128, 128, false);
            Random random = new Random(54321L);
            int numPoints = 32;
            float[][] points = new float[numPoints][2];
            for (int i = 0; i < numPoints; ++i) {
                points[i][0] = random.nextFloat();
                points[i][1] = random.nextFloat();
            }
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    float px = (float)x / 128.0f;
                    float py = (float)y / 128.0f;
                    float minDist = Float.MAX_VALUE;
                    float secondMinDist = Float.MAX_VALUE;
                    for (float[] point : points) {
                        for (int wx = -1; wx <= 1; ++wx) {
                            for (int wy = -1; wy <= 1; ++wy) {
                                float dx = point[0] + (float)wx - px;
                                float dy = point[1] + (float)wy - py;
                                float dist = (float)Math.sqrt(dx * dx + dy * dy);
                                if (dist < minDist) {
                                    secondMinDist = minDist;
                                    minDist = dist;
                                    continue;
                                }
                                if (!(dist < secondMinDist)) continue;
                                secondMinDist = dist;
                            }
                        }
                    }
                    float value = secondMinDist - minDist;
                    value = Math.max(0.0f, Math.min(1.0f, value * 3.0f));
                    int gray = (int)(value * 255.0f);
                    int color = 0xFF000000 | gray << 16 | gray << 8 | gray;
                    image.setPixelRGBA(x, y, color);
                }
            }
            this.worleyNoiseTexture = new DynamicTexture(image);
            this.worleyTextureId = this.worleyNoiseTexture.getId();
        }
        catch (Exception e) {
            tornado.LOGGER.error("Failed to generate Worley noise texture", (Throwable)e);
        }
    }

    private float[][][] generateGradients(int size, Random random) {
        float[][][] gradients = new float[size][size][2];
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                float angle = random.nextFloat() * ((float)Math.PI * 2);
                gradients[y][x][0] = (float)Math.cos(angle);
                gradients[y][x][1] = (float)Math.sin(angle);
            }
        }
        return gradients;
    }

    private float perlinNoise2D(float x, float y, float[][][] gradients) {
        int size = gradients.length;
        int x0 = (int)Math.floor(x) & size - 1;
        int y0 = (int)Math.floor(y) & size - 1;
        int x1 = x0 + 1 & size - 1;
        int y1 = y0 + 1 & size - 1;
        float fx = x - (float)Math.floor(x);
        float fy = y - (float)Math.floor(y);
        float u = this.fade(fx);
        float v = this.fade(fy);
        float n00 = this.dot2D(gradients[y0][x0], fx, fy);
        float n10 = this.dot2D(gradients[y0][x1], fx - 1.0f, fy);
        float n01 = this.dot2D(gradients[y1][x0], fx, fy - 1.0f);
        float n11 = this.dot2D(gradients[y1][x1], fx - 1.0f, fy - 1.0f);
        float nx0 = this.lerp(n00, n10, u);
        float nx1 = this.lerp(n01, n11, u);
        return this.lerp(nx0, nx1, v);
    }

    private float fade(float t) {
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    private float lerp(float a, float b, float t) {
        return a + t * (b - a);
    }

    private float dot2D(float[] grad, float x, float y) {
        return grad[0] * x + grad[1] * y;
    }

    public void bindPerlinNoise(int textureUnit) {
        if (this.perlinTextureId > 0) {
            GL30.glActiveTexture((int)(33984 + textureUnit));
            GL11.glBindTexture((int)3553, (int)this.perlinTextureId);
        }
    }

    public void bindWorleyNoise(int textureUnit) {
        if (this.worleyTextureId > 0) {
            GL30.glActiveTexture((int)(33984 + textureUnit));
            GL11.glBindTexture((int)3553, (int)this.worleyTextureId);
        }
    }

    public int getPerlinTextureId() {
        return this.perlinTextureId;
    }

    public int getWorleyTextureId() {
        return this.worleyTextureId;
    }

    public void cleanup() {
        if (this.perlinNoiseTexture != null) {
            this.perlinNoiseTexture.close();
            this.perlinNoiseTexture = null;
            this.perlinTextureId = -1;
        }
        if (this.worleyNoiseTexture != null) {
            this.worleyNoiseTexture.close();
            this.worleyNoiseTexture = null;
            this.worleyTextureId = -1;
        }
    }
}

