/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.client;

import com.example.examplemod.TornadoRenderer;
import com.example.examplemod.client.CloudVolumetricRenderer;
import com.example.examplemod.client.TornadoVolumetricRenderer;
import com.example.examplemod.tornado;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

@EventBusSubscriber(modid="tornado", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class TornadoRenderEvents {
    private static boolean initialized = false;
    private static boolean cloudsInitialized = false;

    private static void ensureInitialized() {
        if (!initialized) {
            TornadoVolumetricRenderer.getInstance().initialize();
            initialized = true;
        }
    }

    private static void ensureCloudsInitialized() {
        if (!cloudsInitialized) {
            CloudVolumetricRenderer.getInstance().initialize();
            cloudsInitialized = true;
        }
    }

    @SubscribeEvent
    public static void onRenderClouds(ViewportEvent.ComputeFogColor event) {
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        if (mc.isPaused()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        Camera camera = event.getCamera();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && CloudVolumetricRenderer.getInstance().isEnabled()) {
            TornadoRenderEvents.ensureCloudsInitialized();
            try {
                CloudVolumetricRenderer.getInstance().render(poseStack, partialTicks, camera);
            }
            catch (Exception e) {
                tornado.LOGGER.error("Error rendering volumetric clouds", (Throwable)e);
            }
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS && TornadoRenderer.isUsingVolumetricShaders()) {
            TornadoRenderEvents.ensureInitialized();
            try {
                TornadoVolumetricRenderer.getInstance().render(poseStack, partialTicks, camera);
            }
            catch (Exception e) {
                tornado.LOGGER.error("Error rendering tornado volumetrics", (Throwable)e);
            }
        }
    }
}

