#version 150

// Vertex shader for tornado volumetric rendering
// Renders a bounding box in world space for raymarching

in vec3 Position;
in vec2 UV0;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec3 uCameraPos;
uniform vec3 uTornadoPosition;
uniform vec3 uBoxSize;        // Size of bounding box (width, height, depth)
uniform vec3 uBoxCenter;      // World-space center of bounding box

out vec2 texCoord;
out vec3 worldPos;       // World-space position of this vertex

void main() {
    // Transform vertex through model-view-projection for screen position
    vec4 viewPos = ModelViewMat * vec4(Position, 1.0);
    gl_Position = ProjMat * viewPos;
    
    texCoord = UV0;
    
    // Calculate world position directly from local cube coords
    // Position is -0.5 to 0.5 (unit cube), scale by box size and offset to world center
    worldPos = uBoxCenter + Position * uBoxSize;
}

