/*
 * Decompiled with CFR 0.152.
 */
package com.hicham.biomnotifier;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class BiomeNotifierMod
implements ModInitializer {
    public static final String MOD_ID = "biomnotifier";
    private class_2960 lastBiomeId = null;

    public void onInitialize() {
        ServerTickEvents.END_SERVER_TICK.register(this::checkBiomeChange);
    }

    private void checkBiomeChange(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            class_6880 biomeEntry = player.method_37908().method_23753(player.method_24515());
            class_2960 currentBiomeId = biomeEntry.method_40230().map(key -> key.method_29177()).orElse(null);
            if (currentBiomeId == null || currentBiomeId.equals((Object)this.lastBiomeId)) continue;
            this.lastBiomeId = currentBiomeId;
            String hex = this.getBiomeHexColor(currentBiomeId);
            int rgb = Integer.parseInt(hex.substring(1), 16);
            class_5251 color = class_5251.method_27717((int)rgb);
            class_5250 biomeName = class_2561.method_43471((String)("biome." + currentBiomeId.toString().replace(':', '.'))).method_10862(class_2583.field_24360.method_27703(color).method_10978(Boolean.valueOf(true)));
            player.method_7353((class_2561)biomeName, true);
        }
    }

    private String getBiomeHexColor(class_2960 biomeId) {
        String path;
        return switch (path = biomeId.method_12832()) {
            case "desert" -> "#eff29b";
            case "forest", "jungle" -> "#228B22";
            case "ocean", "river" -> "#1E90FF";
            case "snowy_plains", "ice_spikes" -> "#19e6ca";
            case "nether_wastes" -> "#FF5555";
            case "soul_sand_valley" -> "#422e24";
            case "mushroom_fields" -> "#362d3a";
            case "end_highlands" -> "#AA00FF";
            case "basalt_deltas" -> "#555555";
            case "frozen_river" -> "#9be2f2";
            case "snowy_beach" -> "#b2d6d4";
            case "frozen_ocean" -> "#3c93b0";
            default -> "#55FF55";
        };
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

