/*
 * Decompiled with CFR 0.152.
 */
package com.hicham.biomnotifier;

import com.hicham.biomnotifier.ConfigManager;
import com.hicham.biomnotifier.ModConfig;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class BiomeNotifierMod
implements ModInitializer {
    public static final String MOD_ID = "biomnotifier";
    private final Map<class_3222, class_2960> playerLastBiomes = new HashMap<class_3222, class_2960>();
    private int tickCounter = 0;

    public void onInitialize() {
        ConfigManager.initialize();
        ServerTickEvents.END_SERVER_TICK.register(this::checkBiomeChange);
    }

    private void checkBiomeChange(MinecraftServer server) {
        ModConfig config = ConfigManager.getConfig();
        if (!config.enabled) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter < config.checkInterval) {
            return;
        }
        this.tickCounter = 0;
        for (class_3222 player2 : server.method_3760().method_14571()) {
            class_2960 lastBiomeId;
            class_6880 biomeEntry = player2.method_51469().method_23753(player2.method_24515());
            class_2960 currentBiomeId = biomeEntry.method_40230().map(key -> key.method_29177()).orElse(null);
            if (currentBiomeId == null || currentBiomeId.equals((Object)(lastBiomeId = this.playerLastBiomes.get(player2)))) continue;
            this.playerLastBiomes.put(player2, currentBiomeId);
            if (lastBiomeId == null) continue;
            String hex = this.getBiomeHexColor(currentBiomeId, config);
            try {
                int rgb = Integer.parseInt(hex.substring(1), 16);
                class_5251 color = class_5251.method_27717((int)rgb);
                class_5250 biomeName = class_2561.method_43471((String)("biome." + currentBiomeId.toString().replace(':', '.'))).method_10862(class_2583.field_24360.method_27703(color).method_10978(Boolean.valueOf(config.italicText)));
                player2.method_7353((class_2561)biomeName, true);
            }
            catch (NumberFormatException e) {
                class_5250 biomeName = class_2561.method_43471((String)("biome." + currentBiomeId.toString().replace(':', '.'))).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(config.italicText)));
                player2.method_7353((class_2561)biomeName, true);
            }
        }
        this.playerLastBiomes.keySet().removeIf(player -> !player.method_5805() || player.method_14239());
    }

    private String getBiomeHexColor(class_2960 biomeId, ModConfig config) {
        return config.biomeColors.getOrDefault(biomeId.method_12832(), "#55FF55");
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

