/*
 * Decompiled with CFR 0.152.
 */
package com.hicham.biomnotifier;

import com.hicham.biomnotifier.ModConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"BiomeNotifier/ConfigManager");
    private static ConfigHolder<ModConfig> configHolder;
    private static final Object configLock;
    public static final Event<ConfigChangedCallback> CONFIG_CHANGED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        try {
            Object object = configLock;
            synchronized (object) {
                configHolder = AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
                LOGGER.info("BiomeNotifier configuration initialized successfully");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize configuration", (Throwable)e);
            throw new RuntimeException("Failed to initialize BiomeNotifier configuration", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModConfig getConfig() {
        Object object = configLock;
        synchronized (object) {
            ConfigManager.ensureInitialized();
            return (ModConfig)configHolder.getConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfig() {
        Object object = configLock;
        synchronized (object) {
            ConfigManager.ensureInitialized();
            try {
                configHolder.save();
                LOGGER.debug("Configuration saved successfully");
                ((ConfigChangedCallback)CONFIG_CHANGED.invoker()).onConfigChanged();
            }
            catch (Exception e) {
                LOGGER.error("Failed to save configuration", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetToDefaults() {
        Object object = configLock;
        synchronized (object) {
            ConfigManager.ensureInitialized();
            configHolder.load();
            LOGGER.info("Configuration reset to defaults");
            ((ConfigChangedCallback)CONFIG_CHANGED.invoker()).onConfigChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigHolder<ModConfig> getConfigHolder() {
        Object object = configLock;
        synchronized (object) {
            ConfigManager.ensureInitialized();
            return configHolder;
        }
    }

    public static void registerConfigListener(ConfigChangedCallback listener) {
        CONFIG_CHANGED.register((Object)listener);
    }

    private static void ensureInitialized() {
        if (configHolder == null) {
            throw new IllegalStateException("ConfigManager not initialized! Call initialize() first.");
        }
    }

    static {
        configLock = new Object();
        CONFIG_CHANGED = EventFactory.createArrayBacked(ConfigChangedCallback.class, listeners -> () -> {
            for (ConfigChangedCallback listener : listeners) {
                listener.onConfigChanged();
            }
        });
    }

    @FunctionalInterface
    public static interface ConfigChangedCallback {
        public void onConfigChanged();
    }
}

