/*
 * Decompiled with CFR 0.152.
 */
package com.hicham.biomnotifier;

import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="biomnotifier")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.Tooltip
    public boolean enabled = true;
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=5L, max=100L)
    public int checkInterval = 20;
    @ConfigEntry.Category(value="appearance")
    @ConfigEntry.Gui.Tooltip
    public boolean italicText = true;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Excluded
    public transient Map<String, String> biomeColors = new HashMap<String, String>();
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Excluded
    public int configVersion = 1;

    public ModConfig() {
        this.biomeColors.put("desert", "#eff29b");
        this.biomeColors.put("forest", "#228B22");
        this.biomeColors.put("jungle", "#228B22");
        this.biomeColors.put("dark_forest", "#228B22");
        this.biomeColors.put("bamboo_jungle", "#228B22");
        this.biomeColors.put("jungle_edge", "#228B22");
        this.biomeColors.put("savanna", "#ADB75C");
        this.biomeColors.put("savanna_plateau", "#ADB75C");
        this.biomeColors.put("plains", "#91B65D");
        this.biomeColors.put("sunflower_plains", "#91B65D");
        this.biomeColors.put("mountains", "#6E9651");
        this.biomeColors.put("gravelly_mountains", "#6E9651");
        this.biomeColors.put("snowy_mountains", "#6E9651");
        this.biomeColors.put("wooded_mountains", "#6E9651");
        this.biomeColors.put("ocean", "#1E90FF");
        this.biomeColors.put("river", "#1E90FF");
        this.biomeColors.put("warm_ocean", "#1E90FF");
        this.biomeColors.put("lukewarm_ocean", "#1E90FF");
        this.biomeColors.put("cold_ocean", "#1E90FF");
        this.biomeColors.put("deep_ocean", "#1E90FF");
        this.biomeColors.put("deep_lukewarm_ocean", "#1E90FF");
        this.biomeColors.put("deep_cold_ocean", "#1E90FF");
        this.biomeColors.put("deep_frozen_ocean", "#1E90FF");
        this.biomeColors.put("swamp", "#617B60");
        this.biomeColors.put("mangrove_swamp", "#617B60");
        this.biomeColors.put("snowy_plains", "#19e6ca");
        this.biomeColors.put("snowy_taiga", "#19e6ca");
        this.biomeColors.put("ice_spikes", "#19e6ca");
        this.biomeColors.put("snowy_beach", "#b2d6d4");
        this.biomeColors.put("frozen_river", "#b2d6d4");
        this.biomeColors.put("frozen_ocean", "#b2d6d4");
        this.biomeColors.put("badlands", "#C9644A");
        this.biomeColors.put("wooded_badlands", "#C9644A");
        this.biomeColors.put("eroded_badlands", "#C9644A");
        this.biomeColors.put("mushroom_fields", "#362d3a");
        this.biomeColors.put("cherry_grove", "#FCCBE7");
        this.biomeColors.put("pale_garden", "#E0D8C8");
        this.biomeColors.put("nether_wastes", "#FF5555");
        this.biomeColors.put("soul_sand_valley", "#422e24");
        this.biomeColors.put("basalt_deltas", "#555555");
        this.biomeColors.put("end_highlands", "#AA00FF");
        this.biomeColors.put("end_midlands", "#AA00FF");
        this.biomeColors.put("end_barrens", "#AA00FF");
    }

    public void validatePostLoad() {
        this.checkInterval = Math.max(5, Math.min(100, this.checkInterval));
        if (this.biomeColors == null) {
            this.biomeColors = new HashMap<String, String>();
            this.biomeColors.put("desert", "#eff29b");
            this.biomeColors.put("forest", "#228B22");
        }
        this.configVersion = 1;
    }
}

