/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortiusweaponryredux.network;

import java.util.function.Supplier;
import net.mcreator.mortiusweaponryredux.MortiusWeaponryReduxMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MortiusWeaponryReduxModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MortiusWeaponryReduxMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.dps_count = message.data.dps_count;
                    variables.dps_first = message.data.dps_first;
                    variables.dps_second = message.data.dps_second;
                    variables.dps_count_second = message.data.dps_count_second;
                    variables.timeBullet = message.data.timeBullet;
                    variables.zafkielMainHand = message.data.zafkielMainHand;
                    variables.timeLeft = message.data.timeLeft;
                    variables.lookingAtBlock = message.data.lookingAtBlock;
                    variables.dashCooldown = message.data.dashCooldown;
                    variables.autoPressed = message.data.autoPressed;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double dps_count = 0.0;
        public boolean dps_first = false;
        public boolean dps_second = false;
        public double dps_count_second = 0.0;
        public double timeBullet = 0.0;
        public boolean zafkielMainHand = false;
        public double timeLeft = 8760.0;
        public boolean lookingAtBlock = false;
        public double dashCooldown = 0.0;
        public boolean autoPressed = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MortiusWeaponryReduxMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("dps_count", this.dps_count);
            nbt.m_128379_("dps_first", this.dps_first);
            nbt.m_128379_("dps_second", this.dps_second);
            nbt.m_128347_("dps_count_second", this.dps_count_second);
            nbt.m_128347_("timeBullet", this.timeBullet);
            nbt.m_128379_("zafkielMainHand", this.zafkielMainHand);
            nbt.m_128347_("timeLeft", this.timeLeft);
            nbt.m_128379_("lookingAtBlock", this.lookingAtBlock);
            nbt.m_128347_("dashCooldown", this.dashCooldown);
            nbt.m_128379_("autoPressed", this.autoPressed);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.dps_count = nbt.m_128459_("dps_count");
            this.dps_first = nbt.m_128471_("dps_first");
            this.dps_second = nbt.m_128471_("dps_second");
            this.dps_count_second = nbt.m_128459_("dps_count_second");
            this.timeBullet = nbt.m_128459_("timeBullet");
            this.zafkielMainHand = nbt.m_128471_("zafkielMainHand");
            this.timeLeft = nbt.m_128459_("timeLeft");
            this.lookingAtBlock = nbt.m_128471_("lookingAtBlock");
            this.dashCooldown = nbt.m_128459_("dashCooldown");
            this.autoPressed = nbt.m_128471_("autoPressed");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("mortius_weaponry_redux", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            if (!event.isWasDeath()) {
                clone.dps_count = original.dps_count;
                clone.dps_first = original.dps_first;
                clone.dps_second = original.dps_second;
                clone.dps_count_second = original.dps_count_second;
                clone.timeBullet = original.timeBullet;
                clone.zafkielMainHand = original.zafkielMainHand;
                clone.timeLeft = original.timeLeft;
                clone.lookingAtBlock = original.lookingAtBlock;
                clone.dashCooldown = original.dashCooldown;
                clone.autoPressed = original.autoPressed;
            }
        }
    }
}

