/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortiusweaponryredux.entity;

import net.mcreator.mortiusweaponryredux.init.MortiusWeaponryReduxModEntities;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class AutoArrowEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Items.ARROW);

    public AutoArrowEntity(EntityType<? extends AutoArrowEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public AutoArrowEntity(EntityType<? extends AutoArrowEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public AutoArrowEntity(EntityType<? extends AutoArrowEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static AutoArrowEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return AutoArrowEntity.shoot(world, entity, source, 0.0f, 0.0, 0);
    }

    public static AutoArrowEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return AutoArrowEntity.shoot(world, entity, source, pullingPower * 0.0f, 0.0, 0);
    }

    public static AutoArrowEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        AutoArrowEntity entityarrow = new AutoArrowEntity((EntityType<? extends AutoArrowEntity>)((EntityType)MortiusWeaponryReduxModEntities.AUTO_ARROW.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(true);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    public static AutoArrowEntity shoot(LivingEntity entity, LivingEntity target) {
        AutoArrowEntity entityarrow = new AutoArrowEntity((EntityType<? extends AutoArrowEntity>)((EntityType)MortiusWeaponryReduxModEntities.AUTO_ARROW.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 0.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(0.0);
        entityarrow.setKnockback(0);
        entityarrow.setCritArrow(true);
        entity.level().addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }
}

