/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mortiusweaponryredux.entity;

import net.mcreator.mortiusweaponryredux.init.MortiusWeaponryReduxModEntities;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class IronArrowEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Items.ARROW);

    public IronArrowEntity(EntityType<? extends IronArrowEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public IronArrowEntity(EntityType<? extends IronArrowEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public IronArrowEntity(EntityType<? extends IronArrowEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static IronArrowEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return IronArrowEntity.shoot(world, entity, source, 1.9f, 2.0, 0);
    }

    public static IronArrowEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return IronArrowEntity.shoot(world, entity, source, pullingPower * 1.9f, 2.0, 0);
    }

    public static IronArrowEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        IronArrowEntity entityarrow = new IronArrowEntity((EntityType<? extends IronArrowEntity>)((EntityType)MortiusWeaponryReduxModEntities.IRON_ARROW.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(true);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    public static IronArrowEntity shoot(LivingEntity entity, LivingEntity target) {
        IronArrowEntity entityarrow = new IronArrowEntity((EntityType<? extends IronArrowEntity>)((EntityType)MortiusWeaponryReduxModEntities.IRON_ARROW.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 3.8f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(2.0);
        entityarrow.setKnockback(0);
        entityarrow.setCritArrow(true);
        entity.level().addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }
}

