/*
 * Decompiled with CFR 0.152.
 */
package net.trique.awesomewands.item.wands;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.trique.awesomewands.item.AwesomeItems;
import net.trique.awesomewands.particle.AwesomeParticles;

public class PsychicWandItem
extends Item {
    public PsychicWandItem(Item.Properties props) {
        super(props.attributes(PsychicWandItem.createAttributeModifiers()));
    }

    private static ItemAttributeModifiers createAttributeModifiers() {
        ItemAttributeModifiers.Builder b = ItemAttributeModifiers.builder();
        return b.build();
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        super.onUseTick(level, user, stack, remainingUseTicks);
        if (this.getUseDuration(stack, user) - remainingUseTicks == 1) {
            level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 3.0f, 1.0f);
            level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 3.0f, 1.0f);
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (!level.isClientSide && user instanceof Player) {
            Player player = (Player)user;
            boolean creative = player.getAbilities().instabuild;
            ItemStack chargeResource = this.findChargeResource(player);
            if (creative || !chargeResource.isEmpty()) {
                this.spawnIceBeam(level, user);
                if (!creative) {
                    chargeResource.shrink(1);
                    player.getCooldowns().addCooldown((Item)this, 40);
                    stack.hurtAndBreak(1, user, EquipmentSlot.MAINHAND);
                }
            }
        }
        return super.finishUsingItem(stack, level, user);
    }

    private ItemStack findChargeResource(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack s = player.getInventory().getItem(i);
            if (!s.is(AwesomeItems.ARCANE_RUNE)) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    private void spawnIceBeam(Level level, LivingEntity user) {
        level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.SHULKER_BULLET_HIT, SoundSource.PLAYERS, 5.0f, 1.0f);
        level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 5.0f, 1.0f);
        float heightOffset = 1.6f;
        int distance = 20;
        Vec3 source = user.position().add(0.0, (double)1.6f, 0.0);
        Vec3 target = user.position().add(user.getLookAngle().scale(20.0));
        Vec3 toTarget = target.subtract(source);
        Vec3 dir = toTarget.normalize();
        HashSet hit = new HashSet();
        int steps = Mth.floor((double)toTarget.length()) + 7;
        for (int i = 1; i < steps; ++i) {
            Vec3 p = source.add(dir.scale((double)i));
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.sendParticles((ParticleOptions)AwesomeParticles.PSYCHIC_BEAM.get(), p.x, p.y, p.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            BlockPos bp = BlockPos.containing((Position)p);
            AABB box = new AABB(bp).inflate(1.0);
            hit.addAll(level.getEntitiesOfClass(LivingEntity.class, box, e -> {
                TamableAnimal t;
                return !(e instanceof TamableAnimal && (t = (TamableAnimal)e).isOwnedBy(user));
            }));
        }
        hit.remove(user);
        DamageSources sources = level.damageSources();
        for (Entity e2 : hit) {
            if (!(e2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)e2;
            living.hurt(sources.magic(), 5.0f);
            double resist = living.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            double vertical = 0.5 * (1.0 - resist);
            double horizontal = 2.0 * (1.0 - resist);
            living.push(dir.x * horizontal, dir.y * vertical, dir.z * horizontal);
            living.hasImpulse = true;
            living.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 50, 9));
        }
    }
}

