/*
 * Decompiled with CFR 0.152.
 */
package net.trique.awesomewands.util;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.trique.awesomewands.item.AwesomeItems;

public final class AwesomeLootTableModifiers {
    private static final ResourceLocation IGLOO_CHEST = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/igloo_chest");
    private static final ResourceLocation DESERT_PYRAMID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid");
    private static final ResourceLocation MINESHAFT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft");
    private static final ResourceLocation NETHER_BRIDGE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/nether_bridge");
    private static final ResourceLocation JUNGLE_TEMPLE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple");
    private static final ResourceLocation END_CITY_TREASURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure");

    private AwesomeLootTableModifiers() {
    }

    public static void register() {
        NeoForge.EVENT_BUS.addListener(AwesomeLootTableModifiers::onLootTableLoad);
    }

    private static LootPool makePoolWithChance(LootPoolEntryContainer.Builder<?> entryBuilder, float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(entryBuilder.when(LootItemRandomChanceCondition.randomChance((float)chance))).build();
    }

    private static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation id = event.getName();
        if (id == null) {
            return;
        }
        float CHANCE = 0.1f;
        if (id.equals((Object)IGLOO_CHEST)) {
            event.getTable().addPool(AwesomeLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)AwesomeItems.ICE_WAND.get())), 0.1f));
        } else if (id.equals((Object)DESERT_PYRAMID)) {
            event.getTable().addPool(AwesomeLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)AwesomeItems.THUNDER_WAND.get())), 0.1f));
        } else if (id.equals((Object)MINESHAFT)) {
            event.getTable().addPool(AwesomeLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)AwesomeItems.FIRE_WAND.get())), 0.1f));
        } else if (id.equals((Object)NETHER_BRIDGE)) {
            event.getTable().addPool(AwesomeLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)AwesomeItems.VAMPIRIC_WAND.get())), 0.1f));
        } else if (id.equals((Object)JUNGLE_TEMPLE)) {
            event.getTable().addPool(AwesomeLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)AwesomeItems.HEAL_WAND.get())), 0.1f));
        } else if (id.equals((Object)END_CITY_TREASURE)) {
            event.getTable().addPool(AwesomeLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)AwesomeItems.PSYCHIC_WAND.get())), 0.1f));
        }
    }
}

