/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrartp.api.factory;

import com.vecoo.extrartp.ExtraRTP;
import com.vecoo.extrartp.api.events.RandomTeleportEvent;
import com.vecoo.extrartp.config.ServerConfig;
import com.vecoo.extrartp.util.Utils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ExtraRTPFactory {
    public static boolean randomTeleport(@NotNull ServerLevel level, @NotNull ServerPlayer player) {
        ServerConfig config = ExtraRTP.getInstance().getConfig();
        RandomSource random = level.m_213780_();
        WorldBorder worldBorder = level.m_6857_();
        double minX = worldBorder.m_61955_();
        double maxX = worldBorder.m_61957_();
        double minZ = worldBorder.m_61956_();
        double maxZ = worldBorder.m_61958_();
        int y = Utils.heightStart(level.m_46472_().m_135782_().m_135815_());
        double deltaX = maxX - minX;
        double deltaZ = maxZ - minZ;
        AtomicBoolean teleportSuccess = new AtomicBoolean(false);
        for (int attempt = 0; attempt < config.getCountAttemptsTeleport() && !teleportSuccess.get(); ++attempt) {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(random.m_188503_((int)deltaX) + (int)minX, y, random.m_188503_((int)deltaZ) + (int)minZ);
            ChunkAccess chunk = level.m_7726_().m_7587_(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4, ChunkStatus.f_62322_, true);
            if (chunk == null) continue;
            ExtraRTPFactory.findPosition(blockPos, chunk).thenAccept(success -> {
                if (success.booleanValue() && teleportSuccess.compareAndSet(false, true)) {
                    ExtraRTP.getInstance().getServer().execute(() -> {
                        RandomTeleportEvent.Successful event = new RandomTeleportEvent.Successful(player, level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                        player.m_8999_(event.getLevel(), event.getX(), event.getY(), event.getZ(), event.getYRot(), event.getXRot());
                        player.m_20256_(Vec3.f_82478_);
                    });
                }
            });
        }
        return teleportSuccess.get();
    }

    private static CompletableFuture<Boolean> findPosition(@NotNull BlockPos.MutableBlockPos blockPos, @NotNull ChunkAccess chunk) {
        return CompletableFuture.supplyAsync(() -> {
            while (blockPos.m_123342_() > 0) {
                BlockState blockState = chunk.m_8055_((BlockPos)blockPos);
                if (blockState.m_60795_()) {
                    blockPos.m_122173_(Direction.DOWN);
                    continue;
                }
                if (!blockState.m_60819_().m_76178_()) {
                    return false;
                }
                if (!blockState.m_60838_((BlockGetter)chunk, (BlockPos)blockPos)) {
                    blockPos.m_122173_(Direction.DOWN);
                }
                return true;
            }
            return false;
        });
    }
}

