/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrartp.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrartp.ExtraRTP;
import com.vecoo.extrartp.api.factory.ExtraRTPFactory;
import com.vecoo.extrartp.config.LocaleConfig;
import com.vecoo.extrartp.config.ServerConfig;
import com.vecoo.extrartp.util.PermissionNodes;
import com.vecoo.extrartp.util.Utils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RandomTeleportCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rtp").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.RANDOMTELEPORT_COMMAND))).executes(e -> RandomTeleportCommand.executeRTP(((CommandSourceStack)e.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)StringArgumentType.string()).requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.RANDOMTELEPORT_DIMENSION_COMMAND))).suggests((s, builder) -> {
            for (Level dimensions : ExtraRTP.getInstance().getServer().getAllLevels()) {
                String dimensionName = dimensions.dimension().location().getPath().toLowerCase();
                if (!dimensionName.startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(dimensionName);
            }
            return builder.buildFuture();
        }).executes(s -> RandomTeleportCommand.executeRTPDimension(((CommandSourceStack)s.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)s, (String)"dimension")))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(s -> UtilPermission.hasPermission((CommandSourceStack)s, PermissionNodes.RANDOMTELEPORT_DIMENSION_PLAYER_COMMAND))).executes(e -> RandomTeleportCommand.executeRTPDimensionPlayer((CommandSourceStack)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"dimension"), EntityArgument.getPlayer((CommandContext)e, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(s -> UtilPermission.hasPermission((CommandSourceStack)s, PermissionNodes.RANDOMTELEPORT_RELOAD_COMMAND))).executes(e -> RandomTeleportCommand.executeReload((CommandSourceStack)e.getSource()))));
    }

    private static int executeRTP(@NotNull ServerPlayer player) {
        ServerConfig config = ExtraRTP.getInstance().getConfig();
        LocaleConfig localeConfig = ExtraRTP.getInstance().getLocale();
        ServerLevel level = UtilWorld.getLevelByName((String)config.getDefaultWorld());
        if (level == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getNotDimensionFound().replace("%dimension%", config.getDefaultWorld())));
            return 0;
        }
        if (Utils.hasRandomTeleportCooldown(player)) {
            return 0;
        }
        if (ExtraRTPFactory.randomTeleport(level, player)) {
            Utils.COOLDOWN.put(player.getUUID(), System.currentTimeMillis());
            player.sendSystemMessage(UtilChat.formatMessage((String)ExtraRTP.getInstance().getLocale().getSuccessfulTeleport().replace("%dimension%", ExtraRTP.getInstance().getConfig().getDefaultWorld())));
        } else {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getFailedTeleport()));
        }
        return 1;
    }

    private static int executeRTPDimension(@NotNull ServerPlayer player, @NotNull String dimension) {
        ServerLevel level = UtilWorld.getLevelByName((String)dimension);
        LocaleConfig localeConfig = ExtraRTP.getInstance().getLocale();
        if (level == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getNotDimensionFound().replace("%dimension%", dimension)));
            return 0;
        }
        ServerConfig config = ExtraRTP.getInstance().getConfig();
        if (config.isBlacklistWorld() && config.getBlacklistWorldList().contains(dimension.toLowerCase())) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getDimensionBlacklist().replace("%dimension%", dimension)));
            return 0;
        }
        if (Utils.hasRandomTeleportCooldown(player)) {
            return 0;
        }
        if (ExtraRTPFactory.randomTeleport(level, player)) {
            Utils.COOLDOWN.put(player.getUUID(), System.currentTimeMillis());
            player.sendSystemMessage(UtilChat.formatMessage((String)ExtraRTP.getInstance().getLocale().getSuccessfulTeleport().replace("%dimension%", dimension)));
        } else {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getFailedTeleport()));
        }
        return 1;
    }

    private static int executeRTPDimensionPlayer(@NotNull CommandSourceStack source, @NotNull String dimension, @NotNull ServerPlayer player) {
        ServerLevel world = UtilWorld.getLevelByName((String)dimension);
        LocaleConfig localeConfig = ExtraRTP.getInstance().getLocale();
        if (world == null) {
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getNotDimensionFound().replace("%dimension%", dimension)));
            return 0;
        }
        if (ExtraRTPFactory.randomTeleport(world, player)) {
            Utils.COOLDOWN.put(player.getUUID(), System.currentTimeMillis());
            player.sendSystemMessage(UtilChat.formatMessage((String)ExtraRTP.getInstance().getLocale().getSuccessfulTeleport().replace("%dimension%", dimension)));
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getSuccessfulTeleportPlayer().replace("%dimension%", dimension).replace("%player%", player.getName().getString())));
        } else {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getFailedTeleport()));
            source.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getFailedTeleport()));
        }
        return 1;
    }

    private static int executeReload(@NotNull CommandSourceStack source) {
        ExtraRTP.getInstance().loadConfig();
        source.sendSystemMessage(UtilChat.formatMessage((String)ExtraRTP.getInstance().getLocale().getConfigReload()));
        return 1;
    }
}

