/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrartp;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.vecoo.extrartp.command.RandomTeleportCommand;
import com.vecoo.extrartp.config.LocaleConfig;
import com.vecoo.extrartp.config.ServerConfig;
import com.vecoo.extrartp.listener.RTPListener;
import com.vecoo.extrartp.util.PermissionNodes;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import org.slf4j.Logger;

@Mod(value="extrartp")
public class ExtraRTP {
    public static final String MOD_ID = "extrartp";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ExtraRTP instance;
    private ServerConfig config;
    private LocaleConfig locale;
    private MinecraftServer server;

    public ExtraRTP() {
        instance = this;
        this.loadConfig();
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new RTPListener());
    }

    @SubscribeEvent
    public void onPermissionGather(PermissionGatherEvent.Nodes event) {
        PermissionNodes.registerPermission(event);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        RandomTeleportCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.server = event.getServer();
    }

    public void loadConfig() {
        try {
            this.config = new ServerConfig();
            this.config.init();
            this.locale = new LocaleConfig();
            this.locale.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    public static ExtraRTP getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getConfig() {
        return ExtraRTP.instance.config;
    }

    public LocaleConfig getLocale() {
        return ExtraRTP.instance.locale;
    }

    public MinecraftServer getServer() {
        return ExtraRTP.instance.server;
    }
}

