/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrartp;

import com.mojang.logging.LogUtils;
import com.vecoo.extrartp.command.RandomTeleportCommand;
import com.vecoo.extrartp.config.LocaleConfig;
import com.vecoo.extrartp.config.ServerConfig;
import com.vecoo.extrartp.listener.RTPListener;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class ExtraRTP
implements ModInitializer {
    public static final String MOD_ID = "extrartp";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ExtraRTP instance;
    private ServerConfig config;
    private LocaleConfig locale;
    private MinecraftServer server;

    public void onInitialize() {
        instance = this;
        this.loadConfig();
        CommandRegistrationCallback.EVENT.register(RandomTeleportCommand::register);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
        });
        ServerPlayConnectionEvents.JOIN.register(RTPListener::onPlayerJoin);
    }

    public void loadConfig() {
        try {
            this.config = new ServerConfig();
            this.config.init();
            this.locale = new LocaleConfig();
            this.locale.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    public static ExtraRTP getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getConfig() {
        return ExtraRTP.instance.config;
    }

    public LocaleConfig getLocale() {
        return ExtraRTP.instance.locale;
    }

    public MinecraftServer getServer() {
        return ExtraRTP.instance.server;
    }
}

