/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrartp.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extrartp.ExtraRTP;
import com.vecoo.extrartp.api.factory.ExtraRTPFactory;
import com.vecoo.extrartp.config.LocaleConfig;
import com.vecoo.extrartp.config.ServerConfig;
import com.vecoo.extrartp.util.Utils;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

public class RandomTeleportCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rtp").requires(p -> UtilPermission.hasPermission((class_2168)p, (String)"minecraft.command.rtp"))).executes(e -> RandomTeleportCommand.executeRTP(((class_2168)e.getSource()).method_9207()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)StringArgumentType.string()).requires(p -> UtilPermission.hasPermission((class_2168)p, (String)"minecraft.command.rtp.dimension"))).suggests((s, builder) -> {
            for (class_3218 dimensions : ExtraRTP.getInstance().getServer().method_3738()) {
                String dimensionName = dimensions.method_27983().method_29177().method_12832().toLowerCase();
                if (!dimensionName.startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(dimensionName);
            }
            return builder.buildFuture();
        }).executes(s -> RandomTeleportCommand.executeRTPDimension(((class_2168)s.getSource()).method_9207(), StringArgumentType.getString((CommandContext)s, (String)"dimension")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(s -> UtilPermission.hasPermission((class_2168)s, (String)"minecraft.command.rtp.dimension.player"))).executes(e -> RandomTeleportCommand.executeRTPDimensionPlayer((class_2168)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"dimension"), class_2186.method_9315((CommandContext)e, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(s -> UtilPermission.hasPermission((class_2168)s, (String)"minecraft.command.rtp.reload"))).executes(e -> RandomTeleportCommand.executeReload((class_2168)e.getSource()))));
    }

    private static int executeRTP(@NotNull class_3222 player) {
        ServerConfig config = ExtraRTP.getInstance().getConfig();
        LocaleConfig localeConfig = ExtraRTP.getInstance().getLocale();
        class_3218 level = UtilWorld.getLevelByName((String)config.getDefaultWorld());
        if (level == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getNotDimensionFound().replace("%dimension%", config.getDefaultWorld())));
            return 0;
        }
        if (Utils.hasRandomTeleportCooldown(player)) {
            return 0;
        }
        if (ExtraRTPFactory.randomTeleport(level, player)) {
            Utils.COOLDOWN.put(player.method_5667(), System.currentTimeMillis());
            player.method_43496(UtilChat.formatMessage((String)ExtraRTP.getInstance().getLocale().getSuccessfulTeleport().replace("%dimension%", ExtraRTP.getInstance().getConfig().getDefaultWorld())));
        } else {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getFailedTeleport()));
        }
        return 1;
    }

    private static int executeRTPDimension(@NotNull class_3222 player, @NotNull String dimension) {
        class_3218 level = UtilWorld.getLevelByName((String)dimension);
        LocaleConfig localeConfig = ExtraRTP.getInstance().getLocale();
        if (level == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getNotDimensionFound().replace("%dimension%", dimension)));
            return 0;
        }
        ServerConfig config = ExtraRTP.getInstance().getConfig();
        if (config.isBlacklistWorld() && config.getBlacklistWorldList().contains(dimension.toLowerCase())) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getDimensionBlacklist().replace("%dimension%", dimension)));
            return 0;
        }
        if (Utils.hasRandomTeleportCooldown(player)) {
            return 0;
        }
        if (ExtraRTPFactory.randomTeleport(level, player)) {
            Utils.COOLDOWN.put(player.method_5667(), System.currentTimeMillis());
            player.method_43496(UtilChat.formatMessage((String)ExtraRTP.getInstance().getLocale().getSuccessfulTeleport().replace("%dimension%", dimension)));
        } else {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getFailedTeleport()));
        }
        return 1;
    }

    private static int executeRTPDimensionPlayer(@NotNull class_2168 source, @NotNull String dimension, @NotNull class_3222 player) {
        class_3218 world = UtilWorld.getLevelByName((String)dimension);
        LocaleConfig localeConfig = ExtraRTP.getInstance().getLocale();
        if (world == null) {
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getNotDimensionFound().replace("%dimension%", dimension)));
            return 0;
        }
        if (ExtraRTPFactory.randomTeleport(world, player)) {
            Utils.COOLDOWN.put(player.method_5667(), System.currentTimeMillis());
            player.method_43496(UtilChat.formatMessage((String)ExtraRTP.getInstance().getLocale().getSuccessfulTeleport().replace("%dimension%", dimension)));
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getSuccessfulTeleportPlayer().replace("%dimension%", dimension).replace("%player%", player.method_5477().getString())));
        } else {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getFailedTeleport()));
            source.method_45068(UtilChat.formatMessage((String)localeConfig.getFailedTeleport()));
        }
        return 1;
    }

    private static int executeReload(@NotNull class_2168 source) {
        ExtraRTP.getInstance().loadConfig();
        source.method_45068(UtilChat.formatMessage((String)ExtraRTP.getInstance().getLocale().getConfigReload()));
        return 1;
    }
}

