/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extrartp.config;

import com.google.common.collect.Sets;
import com.vecoo.extralib.gson.UtilGson;
import java.util.HashMap;
import java.util.Set;

public class ServerConfig {
    private String defaultWorld = "overworld";
    private int countAttemptsTeleport = 5;
    private int cooldownSecondTeleport = 60;
    private boolean firstJoinRTP = false;
    private boolean blacklistWorld = false;
    private Set<String> blacklistWorldList = Sets.newHashSet((Object[])new String[]{"the_nether", "the_end"});
    private HashMap<String, Integer> heightWorlds = new HashMap();

    public ServerConfig() {
        this.heightWorlds.put("overworld", 256);
        this.heightWorlds.put("the_nether", 120);
        this.heightWorlds.put("the_end", 256);
    }

    public String getDefaultWorld() {
        return this.defaultWorld;
    }

    public int getCountAttemptsTeleport() {
        return this.countAttemptsTeleport;
    }

    public boolean isFirstJoinRTP() {
        return this.firstJoinRTP;
    }

    public boolean isBlacklistWorld() {
        return this.blacklistWorld;
    }

    public int getCooldownSecondTeleport() {
        return this.cooldownSecondTeleport;
    }

    public HashMap<String, Integer> getHeightWorlds() {
        return this.heightWorlds;
    }

    public Set<String> getBlacklistWorldList() {
        return this.blacklistWorldList;
    }

    private void write() {
        UtilGson.writeFileAsync((String)"/config/ExtraRTP/", (String)"config.json", (String)UtilGson.newGson().toJson((Object)this)).join();
    }

    public void init() {
        boolean completed = (Boolean)UtilGson.readFileAsync((String)"/config/ExtraRTP/", (String)"config.json", el -> {
            ServerConfig config = (ServerConfig)UtilGson.newGson().fromJson(el, ServerConfig.class);
            this.defaultWorld = config.getDefaultWorld();
            this.countAttemptsTeleport = config.getCountAttemptsTeleport();
            this.blacklistWorld = config.isBlacklistWorld();
            this.blacklistWorldList = config.getBlacklistWorldList();
            this.heightWorlds = config.getHeightWorlds();
            this.cooldownSecondTeleport = config.getCooldownSecondTeleport();
            this.firstJoinRTP = config.isFirstJoinRTP();
        }).join();
        if (!completed) {
            this.write();
        }
    }
}

