/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_delight.common.item;

import com.teamabnormals.abnormals_delight.core.registry.ADItems;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class CakeSliceItem
extends Item {
    private final ResourceLocation effectName;
    private final int duration;

    public CakeSliceItem(ResourceLocation effectName, int duration, Item.Properties properties) {
        super(properties);
        this.effectName = effectName;
        this.duration = duration;
    }

    public CakeSliceItem(Item.Properties properties) {
        this(null, 0, properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        ItemStack returnStack = super.finishUsingItem(stack, worldIn, entityLiving);
        if (!worldIn.isClientSide && this.effectName != null && BuiltInRegistries.MOB_EFFECT.getHolder(this.effectName).isPresent()) {
            entityLiving.addEffect(new MobEffectInstance((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(this.effectName).get(), this.duration));
        } else if (this == ADItems.STRAWBERRY_CAKE_SLICE.get()) {
            CakeSliceItem.applyHealing(1.0f, (LevelAccessor)worldIn, entityLiving);
        }
        return returnStack;
    }

    public static void applyHealing(float healAmount, LevelAccessor world, LivingEntity entity) {
        entity.heal(healAmount);
        RandomSource rand = entity.getRandom();
        if (world.isClientSide()) {
            int times = 2 * Math.round(healAmount);
            for (int i = 0; i < times; ++i) {
                double d0 = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                world.addParticle((ParticleOptions)ParticleTypes.HEART, entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), d0, d1, d2);
            }
        }
    }
}

