/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_delight.common.item;

import com.google.common.collect.Lists;
import com.teamabnormals.abnormals_delight.core.other.ADConstants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.common.item.ConsumableItem;

public class SlabdishItem
extends ConsumableItem {
    public static final List<MobEffectInstance> EFFECTS = Lists.newArrayList((Object[])new MobEffectInstance[]{new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 6000, 1), new MobEffectInstance(MobEffects.REGENERATION, 6000), new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 6000), new MobEffectInstance(MobEffects.CONFUSION, 6000)});

    public SlabdishItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        MutableComponent whenFeeding = Component.translatable((String)"tooltip.abnormals_delight.slabdish.when_feeding");
        tooltip.add((Component)whenFeeding.withStyle(ChatFormatting.GRAY));
        for (MobEffectInstance effectinstance : EFFECTS) {
            MutableComponent effectDescription = Component.literal((String)" ");
            MutableComponent effectName = Component.translatable((String)effectinstance.getDescriptionId());
            effectDescription.append((Component)effectName);
            MobEffect effect = (MobEffect)effectinstance.getEffect().value();
            if (effectinstance.getAmplifier() > 0) {
                effectDescription.append(" ").append((Component)Component.translatable((String)("potion.potency." + effectinstance.getAmplifier())));
            }
            if (effectinstance.getDuration() > 20) {
                effectDescription.append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)effectinstance, (float)1.0f, (float)context.tickRate())).append(")");
            }
            tooltip.add((Component)effectDescription.withStyle(effect.getCategory().getTooltipFormatting()));
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target instanceof TamableAnimal) {
            TamableAnimal animal = (TamableAnimal)target;
            if (BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()).equals((Object)ADConstants.SLABFISH) && animal.isAlive() && animal.isTame()) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

