/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_delight.core;

import com.teamabnormals.abnormals_delight.core.ADConfig;
import com.teamabnormals.abnormals_delight.core.data.client.ADBlockStateProvider;
import com.teamabnormals.abnormals_delight.core.data.client.ADItemModelProvider;
import com.teamabnormals.abnormals_delight.core.data.client.ADLanguageProvider;
import com.teamabnormals.abnormals_delight.core.data.server.ADDataMapProvider;
import com.teamabnormals.abnormals_delight.core.data.server.ADGlobalLootModifierProvider;
import com.teamabnormals.abnormals_delight.core.data.server.ADLootTableProvider;
import com.teamabnormals.abnormals_delight.core.data.server.ADRecipeProvider;
import com.teamabnormals.abnormals_delight.core.data.server.modifiers.ADAdvancementModifierProvider;
import com.teamabnormals.abnormals_delight.core.data.server.tags.ADBlockTagsProvider;
import com.teamabnormals.abnormals_delight.core.data.server.tags.ADEntityTypeTagsProvider;
import com.teamabnormals.abnormals_delight.core.data.server.tags.ADItemTagsProvider;
import com.teamabnormals.abnormals_delight.core.registry.ADBlocks;
import com.teamabnormals.abnormals_delight.core.registry.ADItems;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="abnormals_delight")
public class AbnormalsDelight {
    public static final String MOD_ID = "abnormals_delight";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("abnormals_delight");

    public AbnormalsDelight(IEventBus bus, ModContainer container) {
        ADBlocks.BLOCKS.register(bus);
        ADItems.ITEMS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ADConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ADItems::setupTabEditors);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        ADBlockTagsProvider blockTags = new ADBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new ADItemTagsProvider(output, provider, blockTags.contentsGetter(), helper));
        generator.addProvider(server, (DataProvider)new ADEntityTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new ADLootTableProvider(output, provider));
        generator.addProvider(server, (DataProvider)new ADAdvancementModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new ADDataMapProvider(output, provider));
        generator.addProvider(server, (DataProvider)new ADRecipeProvider(output, provider));
        generator.addProvider(server, (DataProvider)new ADGlobalLootModifierProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new ADBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new ADItemModelProvider(output, helper));
        generator.addProvider(client, (DataProvider)new ADLanguageProvider(output));
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

