/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_delight.core.data.server;

import com.teamabnormals.abnormals_delight.core.AbnormalsDelight;
import com.teamabnormals.abnormals_delight.core.other.ADConditions;
import com.teamabnormals.abnormals_delight.core.other.tags.ADItemTags;
import com.teamabnormals.abnormals_delight.core.registry.ADBlocks;
import com.teamabnormals.abnormals_delight.core.registry.ADItems;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericItemTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.buzzier_bees.core.registry.BBBlocks;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.incubation.core.registry.IncubationItems;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanItemTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UAItemTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.crafting.ingredient.ItemAbilityIngredient;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class ADRecipeProvider
extends BlueprintRecipeProvider
implements ADConditions {
    public ADRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("abnormals_delight", output, provider);
    }

    public void buildRecipes(RecipeOutput output) {
        this.buildMixedRecipes(output);
        this.buildAtmosphericRecipes(output, new ICondition[]{ATMOSPHERIC_LOADED});
        this.buildAutumnityRecipes(output, new ICondition[]{AUTUMNITY_LOADED});
        this.buildBuzzierBeesRecipes(output, new ICondition[]{BUZZIER_BEES_LOADED});
        this.buildEnvironmentalRecipes(output, new ICondition[]{ENVIRONMENTAL_LOADED});
        this.buildIncubationRecipes(output, new ICondition[]{INCUBATION_LOADED});
        this.buildNeapolitanRecipes(output, new ICondition[]{NEAPOLITAN_LOADED});
        this.buildUpgradeAquaticRecipes(output, new ICondition[]{UPGRADE_AQUATIC_LOADED});
    }

    public void buildAtmosphericRecipes(RecipeOutput output, ICondition ... conditions) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ADItems.DUNE_PLATTER).requires((ItemLike)Items.COOKED_RABBIT).requires((ItemLike)AtmosphericItems.ALOE_LEAVES).requires((ItemLike)Items.BOWL).requires((ItemLike)AtmosphericItems.ROASTED_YUCCA_FRUIT).requires((ItemLike)AtmosphericItems.YELLOW_BLOSSOMS).requires((ItemLike)AtmosphericItems.BARREL_CACTUS).unlockedBy(ADRecipeProvider.getHasName((ItemLike)AtmosphericItems.ALOE_LEAVES), ADRecipeProvider.has((ItemLike)AtmosphericItems.ALOE_LEAVES)).unlockedBy(ADRecipeProvider.getHasName((ItemLike)AtmosphericItems.ROASTED_YUCCA_FRUIT), ADRecipeProvider.has((ItemLike)AtmosphericItems.ROASTED_YUCCA_FRUIT)).unlockedBy(ADRecipeProvider.getHasName((ItemLike)AtmosphericItems.BARREL_CACTUS), ADRecipeProvider.has((ItemLike)AtmosphericItems.BARREL_CACTUS)).save(output.withConditions(conditions));
        CookingPotRecipeBuilder.cookingPotRecipe(ADItems.PASSION_ALOE_NECTAR, (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)Items.HONEY_BOTTLE).addIngredient((ItemLike)AtmosphericItems.ALOE_LEAVES).addIngredient(AtmosphericItemTags.FOODS_PASSION_FRUIT).addIngredient(AtmosphericItemTags.FOODS_PASSION_FRUIT).unlockedBy("has_passion_fruit", ADRecipeProvider.has((TagKey)AtmosphericItemTags.FOODS_PASSION_FRUIT)).unlockedByAnyIngredient(new ItemLike[]{AtmosphericItems.ALOE_LEAVES}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).save(output.withConditions(conditions));
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AtmosphericBlocks.FIRETHORN, (ItemLike)Items.RED_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AtmosphericBlocks.FORSYTHIA, (ItemLike)Items.YELLOW_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AtmosphericBlocks.GILIA, (ItemLike)Items.PURPLE_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AtmosphericBlocks.HOT_MONKEY_BRUSH, (ItemLike)Items.ORANGE_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AtmosphericBlocks.SCALDING_MONKEY_BRUSH, (ItemLike)Items.RED_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AtmosphericBlocks.WARM_MONKEY_BRUSH, (ItemLike)Items.YELLOW_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AtmosphericBlocks.WATER_HYACINTH, (ItemLike)Items.PURPLE_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AtmosphericBlocks.YUCCA_FLOWER, (ItemLike)Items.LIGHT_GRAY_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AtmosphericItems.YUCCA_GATEAU, ADItems.YUCCA_GATEAU_SLICE, 10, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.ROSEWOOD_CABINET, (ItemLike)AtmosphericBlocks.ROSEWOOD_SLAB, (ItemLike)AtmosphericBlocks.ROSEWOOD_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.MORADO_CABINET, (ItemLike)AtmosphericBlocks.MORADO_SLAB, (ItemLike)AtmosphericBlocks.MORADO_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.YUCCA_CABINET, (ItemLike)AtmosphericBlocks.YUCCA_SLAB, (ItemLike)AtmosphericBlocks.YUCCA_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.KOUSA_CABINET, (ItemLike)AtmosphericBlocks.KOUSA_SLAB, (ItemLike)AtmosphericBlocks.KOUSA_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.ASPEN_CABINET, (ItemLike)AtmosphericBlocks.ASPEN_SLAB, (ItemLike)AtmosphericBlocks.ASPEN_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.LAUREL_CABINET, (ItemLike)AtmosphericBlocks.LAUREL_SLAB, (ItemLike)AtmosphericBlocks.LAUREL_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.GRIMWOOD_CABINET, (ItemLike)AtmosphericBlocks.GRIMWOOD_SLAB, (ItemLike)AtmosphericBlocks.GRIMWOOD_TRAPDOOR, conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)AtmosphericBlocks.ROSEWOOD_PLANKS, (ItemLike)AtmosphericBlocks.ROSEWOOD_DOOR, (ItemLike)AtmosphericBlocks.ROSEWOOD_TRAPDOOR, (ItemLike)AtmosphericBlocks.ROSEWOOD_SIGNS.getFirst(), (ItemLike)AtmosphericBlocks.ROSEWOOD_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)AtmosphericBlocks.MORADO_PLANKS, (ItemLike)AtmosphericBlocks.MORADO_DOOR, (ItemLike)AtmosphericBlocks.MORADO_TRAPDOOR, (ItemLike)AtmosphericBlocks.MORADO_SIGNS.getFirst(), (ItemLike)AtmosphericBlocks.MORADO_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)AtmosphericBlocks.YUCCA_PLANKS, (ItemLike)AtmosphericBlocks.YUCCA_DOOR, (ItemLike)AtmosphericBlocks.YUCCA_TRAPDOOR, (ItemLike)AtmosphericBlocks.YUCCA_SIGNS.getFirst(), (ItemLike)AtmosphericBlocks.YUCCA_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)AtmosphericBlocks.KOUSA_PLANKS, (ItemLike)AtmosphericBlocks.KOUSA_DOOR, (ItemLike)AtmosphericBlocks.KOUSA_TRAPDOOR, (ItemLike)AtmosphericBlocks.KOUSA_SIGNS.getFirst(), (ItemLike)AtmosphericBlocks.KOUSA_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)AtmosphericBlocks.ASPEN_PLANKS, (ItemLike)AtmosphericBlocks.ASPEN_DOOR, (ItemLike)AtmosphericBlocks.ASPEN_TRAPDOOR, (ItemLike)AtmosphericBlocks.ASPEN_SIGNS.getFirst(), (ItemLike)AtmosphericBlocks.ASPEN_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)AtmosphericBlocks.LAUREL_PLANKS, (ItemLike)AtmosphericBlocks.LAUREL_DOOR, (ItemLike)AtmosphericBlocks.LAUREL_TRAPDOOR, (ItemLike)AtmosphericBlocks.LAUREL_SIGNS.getFirst(), (ItemLike)AtmosphericBlocks.LAUREL_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)AtmosphericBlocks.GRIMWOOD_PLANKS, (ItemLike)AtmosphericBlocks.GRIMWOOD_DOOR, (ItemLike)AtmosphericBlocks.GRIMWOOD_TRAPDOOR, (ItemLike)AtmosphericBlocks.GRIMWOOD_SIGNS.getFirst(), (ItemLike)AtmosphericBlocks.GRIMWOOD_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.ROSEWOOD_LOG, (ItemLike)AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.ROSEWOOD, (ItemLike)AtmosphericBlocks.STRIPPED_ROSEWOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.MORADO_LOG, (ItemLike)AtmosphericBlocks.STRIPPED_MORADO_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.MORADO_WOOD, (ItemLike)AtmosphericBlocks.STRIPPED_MORADO_WOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.YUCCA_LOG, (ItemLike)AtmosphericBlocks.STRIPPED_YUCCA_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.YUCCA_WOOD, (ItemLike)AtmosphericBlocks.STRIPPED_YUCCA_WOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.KOUSA_LOG, (ItemLike)AtmosphericBlocks.STRIPPED_KOUSA_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.KOUSA_WOOD, (ItemLike)AtmosphericBlocks.STRIPPED_KOUSA_WOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.ASPEN_LOG, (ItemLike)AtmosphericBlocks.STRIPPED_ASPEN_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.ASPEN_WOOD, (ItemLike)AtmosphericBlocks.STRIPPED_ASPEN_WOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.WATCHFUL_ASPEN_LOG, (ItemLike)AtmosphericBlocks.STRIPPED_ASPEN_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.WATCHFUL_ASPEN_WOOD, (ItemLike)AtmosphericBlocks.STRIPPED_ASPEN_WOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.LAUREL_LOG, (ItemLike)AtmosphericBlocks.STRIPPED_LAUREL_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.LAUREL_WOOD, (ItemLike)AtmosphericBlocks.STRIPPED_LAUREL_WOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.GRIMWOOD_LOG, (ItemLike)AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AtmosphericBlocks.GRIMWOOD, (ItemLike)AtmosphericBlocks.STRIPPED_GRIMWOOD, conditions);
    }

    public void buildAutumnityRecipes(RecipeOutput output, ICondition ... conditions) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)AutumnityItems.PUMPKIN_BREAD, (int)2).requires((ItemLike)AutumnityItems.SYRUP_BOTTLE).requires((ItemLike)ModItems.PUMPKIN_SLICE.get()).requires((ItemLike)Items.WHEAT, 2).unlockedBy(ADRecipeProvider.getHasName((ItemLike)AutumnityItems.SYRUP_BOTTLE), ADRecipeProvider.has((ItemLike)AutumnityItems.SYRUP_BOTTLE)).save(output.withConditions(new ICondition[]{AUTUMNITY_LOADED}), ADRecipeProvider.wrapRecipeID((ItemLike)AutumnityItems.PUMPKIN_BREAD));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ADItems.MAPLE_GLAZED_BACON).requires((ItemLike)ModItems.COOKED_BACON.get()).requires((ItemLike)AutumnityItems.SYRUP_BOTTLE).unlockedBy(ADRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.COOKED_BACON.get())), ADRecipeProvider.has((ItemLike)((ItemLike)ModItems.COOKED_BACON.get()))).unlockedBy(ADRecipeProvider.getHasName((ItemLike)AutumnityItems.SYRUP_BOTTLE), ADRecipeProvider.has((ItemLike)AutumnityItems.SYRUP_BOTTLE)).save(output.withConditions(conditions));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ADItems.MAPLE_COOKIE, (int)8).requires((ItemLike)AutumnityItems.SYRUP_BOTTLE).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).unlockedBy(ADRecipeProvider.getHasName((ItemLike)AutumnityItems.SYRUP_BOTTLE), ADRecipeProvider.has((ItemLike)AutumnityItems.SYRUP_BOTTLE)).save(output.withConditions(conditions));
        CookingPotRecipeBuilder.cookingPotRecipe(ADItems.ESCARGOT, (int)1, (int)200, (float)1.0f, (ItemLike)AutumnityItems.SNAIL_SHELL_PIECE).addIngredient((ItemLike)AutumnityBlocks.SNAIL_GOO, 2).addIngredient(CommonTags.CROPS_ONION).addIngredient(Tags.Items.DRINKS_MILK).unlockedByAnyIngredient(new ItemLike[]{AutumnityBlocks.SNAIL_GOO, AutumnityItems.SNAIL_SHELL_PIECE}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)AutumnityItems.FOUL_SOUP, (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)AutumnityItems.FOUL_BERRIES, 2).addIngredient((ItemLike)Items.SPIDER_EYE).addIngredient(CommonTags.CROPS_ONION).unlockedByAnyIngredient(new ItemLike[]{AutumnityItems.FOUL_BERRIES}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.STUFFED_PUMPKIN_BLOCK.get()), (int)1, (int)400, (float)2.0f, (ItemLike)AutumnityBlocks.LARGE_PUMPKIN_SLICE).addIngredient(CommonTags.CROPS_RICE).addIngredient(CommonTags.CROPS_ONION).addIngredient((ItemLike)Items.BROWN_MUSHROOM).addIngredient((ItemLike)Items.POTATO).addIngredient(Tags.Items.FOODS_BERRY).addIngredient(Tags.Items.FOODS_VEGETABLE).unlockedByItems(ADRecipeProvider.getHasName((ItemLike)AutumnityBlocks.LARGE_PUMPKIN_SLICE), new ItemLike[]{AutumnityBlocks.LARGE_PUMPKIN_SLICE}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AutumnityBlocks.AUTUMN_CROCUS, (ItemLike)Items.MAGENTA_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AutumnityBlocks.TURKEY, (ItemLike)AutumnityItems.TURKEY_PIECE, 5, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AutumnityBlocks.COOKED_TURKEY, (ItemLike)AutumnityItems.COOKED_TURKEY_PIECE, 5, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)AutumnityBlocks.LARGE_PUMPKIN_SLICE, (ItemLike)ModItems.PUMPKIN_SLICE.get(), 4, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.MAPLE_CABINET, (ItemLike)AutumnityBlocks.MAPLE_SLAB, (ItemLike)AutumnityBlocks.MAPLE_TRAPDOOR, conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)AutumnityBlocks.MAPLE_PLANKS, (ItemLike)AutumnityBlocks.MAPLE_DOOR, (ItemLike)AutumnityBlocks.MAPLE_TRAPDOOR, (ItemLike)AutumnityBlocks.MAPLE_SIGNS.getFirst(), (ItemLike)AutumnityBlocks.MAPLE_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AutumnityBlocks.MAPLE_LOG, (ItemLike)AutumnityBlocks.STRIPPED_MAPLE_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)AutumnityBlocks.MAPLE_WOOD, (ItemLike)AutumnityBlocks.STRIPPED_MAPLE_WOOD, conditions);
    }

    public void buildBuzzierBeesRecipes(RecipeOutput output, ICondition ... conditions) {
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)BBBlocks.BUTTERCUP, (ItemLike)Items.YELLOW_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)BBBlocks.PINK_CLOVER, (ItemLike)Items.PINK_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)BBBlocks.WHITE_CLOVER, (ItemLike)Items.WHITE_DYE, 2, conditions);
    }

    public void buildEnvironmentalRecipes(RecipeOutput output, ICondition ... conditions) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ADItems.SEARED_VENISON).requires(EnvironmentalItemTags.FOODS_COOKED_VENISON).requires(EnvironmentalItemTags.FOODS_CHERRY).requires((ItemLike)Items.BOWL).requires(EnvironmentalItemTags.FOODS_CHERRY).requires((ItemLike)Items.CARROT).unlockedBy("has_cooked_venison", ADRecipeProvider.has((TagKey)EnvironmentalItemTags.FOODS_COOKED_VENISON)).unlockedBy("has_cherries", ADRecipeProvider.has((TagKey)EnvironmentalItemTags.FOODS_CHERRY)).save(output.withConditions(new ICondition[]{ENVIRONMENTAL_LOADED}));
        CookingPotRecipeBuilder.cookingPotRecipe(ADItems.VENISON_WITH_BAMBOO_SHOOTS, (int)1, (int)200, (float)1.0f).addIngredient(EnvironmentalItemTags.FOODS_RAW_VENISON).addIngredient((ItemLike)Items.KELP).addIngredient((ItemLike)Items.BAMBOO).addIngredient((ItemLike)Items.BAMBOO).addIngredient(Tags.Items.FOODS_VEGETABLE).unlockedBy("has_raw_venison", ADRecipeProvider.has((TagKey)EnvironmentalItemTags.FOODS_RAW_VENISON)).unlockedByAnyIngredient(new ItemLike[]{Items.KELP, Items.BAMBOO}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
        CookingPotRecipeBuilder.cookingPotRecipe(ADItems.DUCK_NOODLES, (int)1, (int)200, (float)1.0f).addIngredient(EnvironmentalItemTags.FOODS_RAW_DUCK).addIngredient(CommonTags.FOODS_PASTA).addIngredient((ItemLike)Items.CARROT).addIngredient(Tags.Items.FOODS_VEGETABLE).unlockedBy("has_raw_duck", ADRecipeProvider.has((TagKey)EnvironmentalItemTags.FOODS_RAW_DUCK)).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
        CookingPotRecipeBuilder.cookingPotRecipe(ADItems.SLABDISH, (int)1, (int)200, (float)1.0f).addIngredient(Tags.Items.FOODS_RAW_FISH).addIngredient((ItemLike)EnvironmentalBlocks.DIANTHUS).addIngredient((ItemLike)Items.BONE_MEAL).addIngredient(ADItemTags.SLABDISH_INGREDIENTS).addIngredient(ADItemTags.SLABDISH_INGREDIENTS).unlockedBy("has_slabdish_ingredients", ADRecipeProvider.has(ADItemTags.SLABDISH_INGREDIENTS)).unlockedByAnyIngredient(new ItemLike[]{Items.BONE_MEAL}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).save(output.withConditions(conditions));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ADItems.CHERRY_COOKIE, (int)8).requires(EnvironmentalItemTags.FOODS_CHERRY).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).unlockedBy("has_cherries", ADRecipeProvider.has((TagKey)EnvironmentalItemTags.FOODS_CHERRY)).save(output.withConditions(conditions));
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalItems.DUCK, ADItems.DUCK_FILLET, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalItems.COOKED_DUCK, ADItems.COOKED_DUCK_FILLET, 2, conditions);
        ADRecipeProvider.conditionalFoodCookingRecipes(output, ADItems.DUCK_FILLET, ADItems.COOKED_DUCK_FILLET, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalItems.VENISON, ADItems.VENISON_SHANKS, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalItems.COOKED_VENISON, ADItems.COOKED_VENISON_SHANKS, 2, conditions);
        ADRecipeProvider.conditionalFoodCookingRecipes(output, ADItems.VENISON_SHANKS, ADItems.COOKED_VENISON_SHANKS, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.BLUEBELL, (ItemLike)Items.BLUE_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.DIANTHUS, (ItemLike)Items.LIME_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.VIOLET, (ItemLike)Items.PURPLE_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.TASSELFLOWER, (ItemLike)Items.ORANGE_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.RED_LOTUS_FLOWER, (ItemLike)Items.RED_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.WHITE_LOTUS_FLOWER, (ItemLike)Items.WHITE_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.CARTWHEEL, (ItemLike)Items.PINK_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.YELLOW_HIBISCUS, (ItemLike)Items.YELLOW_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.ORANGE_HIBISCUS, (ItemLike)Items.ORANGE_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.RED_HIBISCUS, (ItemLike)Items.RED_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.PINK_HIBISCUS, (ItemLike)Items.PINK_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.MAGENTA_HIBISCUS, (ItemLike)Items.MAGENTA_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)EnvironmentalBlocks.PURPLE_HIBISCUS, (ItemLike)Items.PURPLE_DYE, 2, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.WILLOW_CABINET, (ItemLike)EnvironmentalBlocks.WILLOW_SLAB, (ItemLike)EnvironmentalBlocks.WILLOW_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.WISTERIA_CABINET, (ItemLike)EnvironmentalBlocks.WISTERIA_SLAB, (ItemLike)EnvironmentalBlocks.WISTERIA_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.PLUM_CABINET, (ItemLike)EnvironmentalBlocks.PLUM_SLAB, (ItemLike)EnvironmentalBlocks.PLUM_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.PINE_CABINET, (ItemLike)EnvironmentalBlocks.PINE_SLAB, (ItemLike)EnvironmentalBlocks.PINE_TRAPDOOR, conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)EnvironmentalBlocks.WILLOW_PLANKS, (ItemLike)EnvironmentalBlocks.WILLOW_DOOR, (ItemLike)EnvironmentalBlocks.WILLOW_TRAPDOOR, (ItemLike)EnvironmentalBlocks.WILLOW_SIGNS.getFirst(), (ItemLike)EnvironmentalBlocks.WILLOW_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)EnvironmentalBlocks.WISTERIA_PLANKS, (ItemLike)EnvironmentalBlocks.WISTERIA_DOOR, (ItemLike)EnvironmentalBlocks.WISTERIA_TRAPDOOR, (ItemLike)EnvironmentalBlocks.WISTERIA_SIGNS.getFirst(), (ItemLike)EnvironmentalBlocks.WISTERIA_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)EnvironmentalBlocks.PLUM_PLANKS, (ItemLike)EnvironmentalBlocks.PLUM_DOOR, (ItemLike)EnvironmentalBlocks.PLUM_TRAPDOOR, (ItemLike)EnvironmentalBlocks.PLUM_SIGNS.getFirst(), (ItemLike)EnvironmentalBlocks.PLUM_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)EnvironmentalBlocks.PINE_PLANKS, (ItemLike)EnvironmentalBlocks.PINE_DOOR, (ItemLike)EnvironmentalBlocks.PINE_TRAPDOOR, (ItemLike)EnvironmentalBlocks.PINE_SIGNS.getFirst(), (ItemLike)EnvironmentalBlocks.PINE_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)EnvironmentalBlocks.WILLOW_LOG, (ItemLike)EnvironmentalBlocks.STRIPPED_WILLOW_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)EnvironmentalBlocks.WILLOW_WOOD, (ItemLike)EnvironmentalBlocks.STRIPPED_WILLOW_WOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)EnvironmentalBlocks.WISTERIA_LOG, (ItemLike)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)EnvironmentalBlocks.WISTERIA_WOOD, (ItemLike)EnvironmentalBlocks.STRIPPED_WISTERIA_WOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)EnvironmentalBlocks.PLUM_LOG, (ItemLike)EnvironmentalBlocks.STRIPPED_PLUM_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)EnvironmentalBlocks.PLUM_WOOD, (ItemLike)EnvironmentalBlocks.STRIPPED_PLUM_WOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)EnvironmentalBlocks.PINE_LOG, (ItemLike)EnvironmentalBlocks.STRIPPED_PINE_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)EnvironmentalBlocks.PINE_WOOD, (ItemLike)EnvironmentalBlocks.STRIPPED_PINE_WOOD, conditions);
    }

    public void buildIncubationRecipes(RecipeOutput output, ICondition ... conditions) {
        ADRecipeProvider.conditionalFoodCookingRecipes(output, (ItemLike)Items.EGG, (ItemLike)ModItems.FRIED_EGG.get(), new ICondition[]{INCUBATION_NOT_LOADED});
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)IncubationItems.SCRAMBLED_EGGS, (int)1, (int)200, (float)1.0f).addIngredient(Tags.Items.EGGS).addIngredient(Tags.Items.EGGS).addIngredient(Tags.Items.DRINKS_MILK).unlockedBy("has_eggs", ADRecipeProvider.has((TagKey)Tags.Items.EGGS)).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
    }

    public void buildNeapolitanRecipes(RecipeOutput output, ICondition ... conditions) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MELON_POPSICLE.get()), (int)1).pattern(" mm").pattern("imm").pattern("-i ").define(Character.valueOf('m'), (ItemLike)Items.MELON_SLICE).define(Character.valueOf('i'), (ItemLike)Items.ICE).define(Character.valueOf('-'), (ItemLike)Items.STICK).unlockedBy(ADRecipeProvider.getHasName((ItemLike)Items.MELON_SLICE), ADRecipeProvider.has((ItemLike)Items.MELON_SLICE)).save(output.withConditions(new ICondition[]{NEAPOLITAN_NOT_LOADED}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MELON_POPSICLE.get()), (int)1).pattern(" mm").pattern("imm").pattern("-i ").define(Character.valueOf('m'), (ItemLike)Items.MELON_SLICE).define(Character.valueOf('i'), (ItemLike)NeapolitanItems.ICE_CUBES).define(Character.valueOf('-'), (ItemLike)Items.STICK).unlockedBy(ADRecipeProvider.getHasName((ItemLike)Items.MELON_SLICE), ADRecipeProvider.has((ItemLike)Items.MELON_SLICE)).save(output.withConditions(new ICondition[]{NEAPOLITAN_LOADED}), ADRecipeProvider.wrapRecipeID((ItemLike)ModItems.MELON_POPSICLE.get()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)NeapolitanItems.ADZUKI_CURRY).requires((ItemLike)NeapolitanItems.ROASTED_ADZUKI_BEANS).requires((ItemLike)NeapolitanItems.DRIED_BANANA).requires((ItemLike)Items.CARROT).requires((ItemLike)ModItems.PUMPKIN_SLICE.get()).requires((ItemLike)Items.BOWL).unlockedBy(ADRecipeProvider.getHasName((ItemLike)((ItemLike)NeapolitanItems.ROASTED_ADZUKI_BEANS.get())), ADRecipeProvider.has((ItemLike)((ItemLike)NeapolitanItems.ROASTED_ADZUKI_BEANS.get()))).save(output, ADRecipeProvider.wrapRecipeID((ItemLike)NeapolitanItems.ADZUKI_CURRY));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)NeapolitanItems.ADZUKI_CURRY, (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)NeapolitanItems.ADZUKI_BEANS).addIngredient(NeapolitanItemTags.FOODS_BANANA).addIngredient(Tags.Items.CROPS_CARROT).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).unlockedBy(ADRecipeProvider.getHasName((ItemLike)((ItemLike)NeapolitanItems.ADZUKI_BEANS.get())), ADRecipeProvider.has((ItemLike)((ItemLike)NeapolitanItems.ADZUKI_BEANS.get()))).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)NeapolitanItems.ADZUKI_STEW, (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)NeapolitanItems.ADZUKI_BEANS, 2).addIngredient(Tags.Items.CROPS_BEETROOT).addIngredient(CommonTags.CROPS_TOMATO).addIngredient((ItemLike)Items.BROWN_MUSHROOM).unlockedBy(ADRecipeProvider.getHasName((ItemLike)((ItemLike)NeapolitanItems.ADZUKI_BEANS.get())), ADRecipeProvider.has((ItemLike)((ItemLike)NeapolitanItems.ADZUKI_BEANS.get()))).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MILK_BOTTLE.get()), (int)4).requires((ItemLike)Items.MILK_BUCKET).requires((ItemLike)Items.GLASS_BOTTLE, 4).unlockedBy("has_milk_bucket", ADRecipeProvider.has((ItemLike)Items.MILK_BUCKET)).save(output.withConditions(new ICondition[]{NEAPOLITAN_NOT_LOADED}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.MILK_BUCKET).requires((ItemLike)Items.BUCKET).requires((ItemLike)ModItems.MILK_BOTTLE.get(), 4).unlockedBy(ADRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.MILK_BOTTLE.get())), ADRecipeProvider.has((ItemLike)((ItemLike)ModItems.MILK_BOTTLE.get()))).save(output.withConditions(new ICondition[]{NEAPOLITAN_NOT_LOADED}), ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"milk_bucket_from_bottles"));
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)NeapolitanItems.ADZUKI_CAKE, ADItems.ADZUKI_CAKE_SLICE, 7, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)NeapolitanItems.BANANA_CAKE, ADItems.BANANA_CAKE_SLICE, 7, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)NeapolitanItems.CHOCOLATE_CAKE, ADItems.CHOCOLATE_CAKE_SLICE, 7, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)NeapolitanItems.MINT_CAKE, ADItems.MINT_CAKE_SLICE, 7, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)NeapolitanItems.STRAWBERRY_CAKE, ADItems.STRAWBERRY_CAKE_SLICE, 7, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)NeapolitanItems.VANILLA_CAKE, ADItems.VANILLA_CAKE_SLICE, 7, conditions);
        this.cakeRecipe(output, (ItemLike)NeapolitanItems.ADZUKI_CAKE, (ItemLike)ADItems.ADZUKI_CAKE_SLICE, conditions);
        this.cakeRecipe(output, (ItemLike)NeapolitanItems.BANANA_CAKE, (ItemLike)ADItems.BANANA_CAKE_SLICE, conditions);
        this.cakeRecipe(output, (ItemLike)NeapolitanItems.CHOCOLATE_CAKE, (ItemLike)ADItems.CHOCOLATE_CAKE_SLICE, conditions);
        this.cakeRecipe(output, (ItemLike)NeapolitanItems.MINT_CAKE, (ItemLike)ADItems.MINT_CAKE_SLICE, conditions);
        this.cakeRecipe(output, (ItemLike)NeapolitanItems.STRAWBERRY_CAKE, (ItemLike)ADItems.STRAWBERRY_CAKE_SLICE, conditions);
        this.cakeRecipe(output, (ItemLike)NeapolitanItems.VANILLA_CAKE, (ItemLike)ADItems.VANILLA_CAKE_SLICE, conditions);
    }

    public void buildUpgradeAquaticRecipes(RecipeOutput output, ICondition ... conditions) {
        CookingPotRecipeBuilder.cookingPotRecipe(ADItems.PICKERELWEED_JUICE, (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)UABlocks.PICKERELWEED).addIngredient((ItemLike)UABlocks.PICKERELWEED).addIngredient((ItemLike)Items.SUGAR).unlockedByAnyIngredient(new ItemLike[]{UABlocks.PICKERELWEED}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).save(output.withConditions(conditions));
        CookingPotRecipeBuilder.cookingPotRecipe(ADItems.PERCH_WITH_MUSHROOMS, (int)1, (int)200, (float)1.0f).addIngredient(UAItemTags.FOODS_RAW_PERCH).addIngredient((ItemLike)ModItems.RED_MUSHROOM_COLONY.get()).addIngredient(CommonTags.CROPS_RICE).addIngredient(CommonTags.CROPS_TOMATO).unlockedByAnyIngredient(new ItemLike[]{UAItems.PERCH, (ItemLike)ModItems.RED_MUSHROOM_COLONY.get(), (ItemLike)ModItems.RICE.get(), (ItemLike)ModItems.TOMATO.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
        CookingPotRecipeBuilder.cookingPotRecipe(ADItems.PIKE_WITH_BEETROOT, (int)1, (int)200, (float)1.0f).addIngredient(UAItemTags.FOODS_RAW_PIKE).addIngredient((ItemLike)UABlocks.PICKERELWEED).addIngredient((ItemLike)UABlocks.PICKERELWEED).addIngredient(Tags.Items.CROPS_BEETROOT).unlockedByAnyIngredient(new ItemLike[]{UAItems.PERCH, UABlocks.PICKERELWEED, Items.BEETROOT}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(output.withConditions(conditions));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ADItems.MULBERRY_COOKIE, (int)8).requires((ItemLike)UAItems.MULBERRY).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.WHEAT).unlockedBy(ADRecipeProvider.getHasName((ItemLike)UAItems.MULBERRY), ADRecipeProvider.has((ItemLike)UAItems.MULBERRY)).save(output.withConditions(conditions));
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)UABlocks.PICKERELWEED, (ItemLike)Items.CYAN_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)UABlocks.PINK_SEAROCKET, (ItemLike)Items.PINK_DYE, 2, conditions);
        ADRecipeProvider.cuttingRecipe(output, (ItemLike)UABlocks.WHITE_SEAROCKET, (ItemLike)Items.WHITE_DYE, 2, conditions);
        ADRecipeProvider.cuttingFish(output, (ItemLike)UAItems.PIKE, ADItems.PIKE_SLICE, 2, conditions);
        ADRecipeProvider.cuttingFish(output, (ItemLike)UAItems.COOKED_PIKE, ADItems.COOKED_PIKE_SLICE, 2, conditions);
        ADRecipeProvider.conditionalFoodCookingRecipes(output, ADItems.PIKE_SLICE, ADItems.COOKED_PIKE_SLICE, conditions);
        ADRecipeProvider.cuttingFish(output, (ItemLike)UAItems.PERCH, ADItems.PERCH_SLICE, 2, conditions);
        ADRecipeProvider.cuttingFish(output, (ItemLike)UAItems.COOKED_PERCH, ADItems.COOKED_PERCH_SLICE, 2, conditions);
        ADRecipeProvider.conditionalFoodCookingRecipes(output, ADItems.PERCH_SLICE, ADItems.COOKED_PERCH_SLICE, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.DRIFTWOOD_CABINET, (ItemLike)UABlocks.DRIFTWOOD_SLAB, (ItemLike)UABlocks.DRIFTWOOD_TRAPDOOR, conditions);
        ADRecipeProvider.cabinetRecipe(output, ADBlocks.RIVER_CABINET, (ItemLike)UABlocks.RIVER_SLAB, (ItemLike)UABlocks.RIVER_TRAPDOOR, conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)UABlocks.DRIFTWOOD_PLANKS, (ItemLike)UABlocks.DRIFTWOOD_DOOR, (ItemLike)UABlocks.DRIFTWOOD_TRAPDOOR, (ItemLike)UABlocks.DRIFTWOOD_SIGNS.getFirst(), (ItemLike)UABlocks.DRIFTWOOD_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.salvagePlankFromFurniture(output, (ItemLike)UABlocks.RIVER_PLANKS, (ItemLike)UABlocks.RIVER_DOOR, (ItemLike)UABlocks.RIVER_TRAPDOOR, (ItemLike)UABlocks.RIVER_SIGNS.getFirst(), (ItemLike)UABlocks.RIVER_HANGING_SIGNS.getFirst(), conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)UABlocks.DRIFTWOOD_LOG, (ItemLike)UABlocks.STRIPPED_DRIFTWOOD_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)UABlocks.DRIFTWOOD, (ItemLike)UABlocks.STRIPPED_DRIFTWOOD, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)UABlocks.RIVER_LOG, (ItemLike)UABlocks.STRIPPED_RIVER_LOG, conditions);
        ADRecipeProvider.stripLogForBark(output, (ItemLike)UABlocks.RIVER_WOOD, (ItemLike)UABlocks.STRIPPED_RIVER_WOOD, conditions);
    }

    public void buildMixedRecipes(RecipeOutput output) {
        CookingPotRecipeBuilder.cookingPotRecipe(ADItems.CHERRY_CREAM_SODA, (int)1, (int)200, (float)1.0f).addIngredient(Tags.Items.DRINKS_MILK).addIngredient((ItemLike)Items.SUGAR).addIngredient(EnvironmentalItemTags.FOODS_CHERRY).addIngredient(EnvironmentalItemTags.FOODS_CHERRY).addIngredient((ItemLike)NeapolitanItems.DRIED_VANILLA_PODS).unlockedBy("has_cherries", ADRecipeProvider.has((TagKey)EnvironmentalItemTags.FOODS_CHERRY)).unlockedByAnyIngredient(new ItemLike[]{NeapolitanItems.DRIED_VANILLA_PODS}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).save(output.withConditions(new ICondition[]{ENVIRONMENTAL_LOADED, NEAPOLITAN_LOADED}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ADItems.PASSION_FRUIT_GLAZED_DUCK).requires(EnvironmentalItemTags.FOODS_COOKED_DUCK).requires(AtmosphericItemTags.FOODS_PASSION_FRUIT).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.BAKED_POTATO).requires(CommonTags.CROPS_ONION).unlockedBy("has_cooked_duck", ADRecipeProvider.has((TagKey)EnvironmentalItemTags.FOODS_COOKED_DUCK)).unlockedBy("has_passion_fruit", ADRecipeProvider.has((TagKey)AtmosphericItemTags.FOODS_PASSION_FRUIT)).save(output.withConditions(new ICondition[]{ATMOSPHERIC_LOADED, ENVIRONMENTAL_LOADED}));
    }

    public static void cabinetRecipe(RecipeOutput output, ItemLike block, ItemLike slab, ItemLike trapdoor, ICondition ... conditions) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)block).pattern("___").pattern("D D").pattern("___").define(Character.valueOf('_'), slab).define(Character.valueOf('D'), trapdoor).unlockedBy(ADRecipeProvider.getHasName((ItemLike)trapdoor), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{trapdoor})).group("fd_cabinet").save(output.withConditions(conditions));
    }

    private static void salvagePlankFromFurniture(RecipeOutput output, ItemLike plank, ItemLike door, ItemLike trapdoor, ItemLike sign, ItemLike hangingSign, ICondition ... conditions) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{door}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)plank).save(output.withConditions(conditions));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{trapdoor}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)plank).save(output.withConditions(conditions));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{sign}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)plank).save(output.withConditions(conditions));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{hangingSign}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)plank).save(output.withConditions(conditions));
    }

    private static void cuttingRecipe(RecipeOutput output, ItemLike input, ItemLike cut, int count, ICondition ... conditions) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)cut, (int)count).save(output.withConditions(conditions));
    }

    private static void cuttingFish(RecipeOutput output, ItemLike input, ItemLike cut, int count, ICondition ... conditions) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)cut, (int)count).addResult((ItemLike)Items.BONE_MEAL).save(output.withConditions(conditions));
    }

    private static void stripLogForBark(RecipeOutput output, ItemLike log, ItemLike strippedLog, ICondition ... conditions) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{log}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_STRIP).toVanilla(), (ItemLike)strippedLog).addResult((ItemLike)ModItems.TREE_BARK.get()).addSound(SoundEvents.AXE_STRIP).save(output.withConditions(conditions));
    }

    private void cakeRecipe(RecipeOutput output, ItemLike cake, ItemLike slice, ICondition ... conditions) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)cake).requires(slice).requires(slice).requires(slice).requires(slice).requires(slice).requires(slice).requires(slice).unlockedBy(ADRecipeProvider.getHasName((ItemLike)slice), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slice})).group("cake").save(output.withConditions(conditions), this.getModConversionRecipeName(cake, slice));
    }

    public static void conditionalFoodCookingRecipes(RecipeOutput recipeOutput, ItemLike input, ItemLike output, ICondition ... conditions) {
        ADRecipeProvider.conditionalFoodCookingRecipes(recipeOutput, input, output, 0.35f, 200, conditions);
    }

    public static void conditionalFoodCookingRecipes(RecipeOutput recipeOutput, ItemLike input, ItemLike output, float xp, int baseCookTime, ICondition ... conditions) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)xp, (int)baseCookTime).unlockedBy(ADRecipeProvider.getHasName((ItemLike)input), ADRecipeProvider.has((ItemLike)input)).save(recipeOutput.withConditions(conditions));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)xp, (int)(baseCookTime / 2)).unlockedBy(ADRecipeProvider.getHasName((ItemLike)input), ADRecipeProvider.has((ItemLike)input)).save(recipeOutput.withConditions(conditions), String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)output)) + "_from_smoking");
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)xp, (int)(baseCookTime * 3)).unlockedBy(ADRecipeProvider.getHasName((ItemLike)input), ADRecipeProvider.has((ItemLike)input)).save(recipeOutput.withConditions(conditions), String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)output)) + "_from_campfire_cooking");
    }

    public static ResourceLocation wrapRecipeID(ItemLike itemLike) {
        return AbnormalsDelight.location(RecipeBuilder.getDefaultRecipeId((ItemLike)itemLike).getPath());
    }
}

