/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_delight.core.data.server.modifiers;

import com.teamabnormals.abnormals_delight.core.other.ADConditions;
import com.teamabnormals.abnormals_delight.core.registry.ADItems;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.core.api.conditions.BlueprintAndCondition;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import vectorwing.farmersdelight.common.registry.ModItems;

public class ADAdvancementModifierProvider
extends AdvancementModifierProvider
implements ADConditions {
    public ADAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("abnormals_delight", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        List<Item> items = BuiltInRegistries.ITEM.stream().filter(item -> "farmersdelight".equals(BuiltInRegistries.ITEM.getKey(item).getNamespace())).toList();
        items.forEach(item -> {
            if (item.getDefaultInstance().getFoodProperties(null) != null && item != ModItems.APPLE_CIDER.get() && item != ModItems.FRIED_EGG.get()) {
                balancedDiet.addCriterion(BuiltInRegistries.ITEM.getKey(item).getPath(), ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)item));
            }
        });
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        this.compatBalancedDiet("autumnity", (ICondition)AUTUMNITY_LOADED, List.of(ADItems.MAPLE_COOKIE, ADItems.MAPLE_GLAZED_BACON, ADItems.ESCARGOT));
        this.compatBalancedDiet("atmospheric", (ICondition)ATMOSPHERIC_LOADED, List.of(ADItems.DUNE_PLATTER, ADItems.YUCCA_GATEAU_SLICE));
        this.compatBalancedDiet("environmental", (ICondition)ENVIRONMENTAL_LOADED, List.of(ADItems.DUCK_FILLET, ADItems.COOKED_DUCK_FILLET, ADItems.VENISON_SHANKS, ADItems.COOKED_VENISON_SHANKS, ADItems.CHERRY_COOKIE, ADItems.SEARED_VENISON, ADItems.DUCK_NOODLES, ADItems.VENISON_WITH_BAMBOO_SHOOTS, ADItems.SLABDISH));
        this.compatBalancedDiet("environmental_and_atmospheric", (ICondition)new BlueprintAndCondition(new ICondition[]{ENVIRONMENTAL_LOADED, ATMOSPHERIC_LOADED}), List.of(ADItems.PASSION_FRUIT_GLAZED_DUCK));
        this.compatBalancedDiet("incubation", (ICondition)new NotCondition((ICondition)INCUBATION_LOADED), List.of(ModItems.FRIED_EGG));
        this.compatBalancedDiet("neapolitan", (ICondition)NEAPOLITAN_LOADED, List.of(ADItems.VANILLA_CAKE_SLICE, ADItems.CHOCOLATE_CAKE_SLICE, ADItems.STRAWBERRY_CAKE_SLICE, ADItems.BANANA_CAKE_SLICE, ADItems.MINT_CAKE_SLICE, ADItems.ADZUKI_CAKE_SLICE));
        this.compatBalancedDiet("upgrade_aquatic", (ICondition)UPGRADE_AQUATIC_LOADED, List.of(ADItems.PIKE_SLICE, ADItems.COOKED_PIKE_SLICE, ADItems.PERCH_SLICE, ADItems.COOKED_PERCH_SLICE, ADItems.MULBERRY_COOKIE, ADItems.PERCH_WITH_MUSHROOMS, ADItems.PIKE_WITH_BEETROOT));
    }

    private void compatBalancedDiet(String name, ICondition condition, List<Supplier<Item>> items) {
        ConditionedResourceSelector selector = new ConditionedResourceSelector((ResourceSelector)new NamesResourceSelector(new String[]{"husbandry/balanced_diet"}), new ICondition[]{condition});
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        items.stream().filter(item -> ((Item)item.get()).getDefaultInstance().getFoodProperties(null) != null).sorted(Comparator.comparing(item -> BuiltInRegistries.ITEM.getKey((Object)((Item)item.get())))).forEach(item -> balancedDiet.addCriterion(BuiltInRegistries.ITEM.getKey((Object)((Item)item.get())).getPath(), ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)item.get()))));
        this.entry("husbandry/balanced_diet/" + name).selector(selector).addModifier((ObjectModifier)balancedDiet.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
    }
}

