/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_delight.core.other;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamabnormals.abnormals_delight.common.item.SlabdishItem;
import com.teamabnormals.abnormals_delight.core.other.ADConstants;
import com.teamabnormals.abnormals_delight.core.other.tags.ADBlockTags;
import com.teamabnormals.abnormals_delight.core.registry.ADItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.MathUtils;

@EventBusSubscriber(modid="abnormals_delight")
public class ADEvents {
    public static final HashMap<Supplier<Item>, ResourceLocation> SLICES_TO_CAKES = (HashMap)Util.make((Object)Maps.newHashMap(), list -> {
        list.put(ADItems.VANILLA_CAKE_SLICE, ADConstants.VANILLA_CAKE);
        list.put(ADItems.CHOCOLATE_CAKE_SLICE, ADConstants.CHOCOLATE_CAKE);
        list.put(ADItems.STRAWBERRY_CAKE_SLICE, ADConstants.STRAWBERRY_CAKE);
        list.put(ADItems.BANANA_CAKE_SLICE, ADConstants.BANANA_CAKE);
        list.put(ADItems.MINT_CAKE_SLICE, ADConstants.MINT_CAKE);
        list.put(ADItems.ADZUKI_CAKE_SLICE, ADConstants.ADZUKI_CAKE);
    });
    public static final HashMap<TagKey<Block>, Supplier<Item>> TAGS_TO_SLICES = (HashMap)Util.make((Object)Maps.newHashMap(), list -> {
        list.put(ADBlockTags.DROPS_VANILLA_CAKE_SLICE, ADItems.VANILLA_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_CHOCOLATE_CAKE_SLICE, ADItems.CHOCOLATE_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_STRAWBERRY_CAKE_SLICE, ADItems.STRAWBERRY_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_BANANA_CAKE_SLICE, ADItems.BANANA_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_MINT_CAKE_SLICE, ADItems.MINT_CAKE_SLICE);
        list.put(ADBlockTags.DROPS_ADZUKI_CAKE_SLICE, ADItems.ADZUKI_CAKE_SLICE);
    });

    public static Optional<IntegerProperty> yuccaGateauBites(BlockState state) {
        return state.getProperties().stream().filter(p -> p.getName().equals("bites") && p instanceof IntegerProperty).map(p -> (IntegerProperty)p).findFirst();
    }

    public static Supplier<Item> getCakeSlice(BlockState state) {
        TagKey<Block> cakeTag = ADBlockTags.DROPS_FLAVORED_CAKE_SLICE;
        for (TagKey<Block> tagKey : TAGS_TO_SLICES.keySet()) {
            if (!state.is(tagKey)) continue;
            cakeTag = tagKey;
        }
        return TAGS_TO_SLICES.get(cakeTag);
    }

    @SubscribeEvent
    public static void onCakeInteraction(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        ItemStack tool = event.getEntity().getItemInHand(event.getHand());
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        if (tool.is(ModTags.KNIVES) && name != null) {
            if (state.is(ADBlockTags.DROPS_YUCCA_GATEAU_SLICE)) {
                int bites = 1;
                Optional<IntegerProperty> property = ADEvents.yuccaGateauBites(state);
                if (property.isPresent()) {
                    bites = (Integer)state.getValue((Property)property.get());
                    if (bites < 9) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)property.get(), (Comparable)Integer.valueOf(bites + 1)), 3);
                    } else {
                        level.removeBlock(pos, false);
                    }
                } else {
                    BlockState yuccaGateau = ((Block)BuiltInRegistries.BLOCK.get(ADConstants.YUCCA_GATEAU)).defaultBlockState();
                    level.setBlock(pos, (BlockState)yuccaGateau.setValue((Property)ADEvents.yuccaGateauBites(yuccaGateau).get(), (Comparable)Integer.valueOf(1)), 3);
                    Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
                }
                ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)ADItems.YUCCA_GATEAU_SLICE.get()), (double)((float)pos.getX() + (float)bites * 0.075f), (double)((float)pos.getY() + 0.2f), (double)((float)pos.getZ() + 0.5f), (double)-0.05f, (double)0.0, (double)0.0);
                level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            } else if (state.is(ADBlockTags.DROPS_FLAVORED_CAKE_SLICE)) {
                Supplier<Item> cakeSlice = ADEvents.getCakeSlice(state);
                float offset = 0.0f;
                if (state.hasProperty((Property)CakeBlock.BITES)) {
                    int bites = (Integer)state.getValue((Property)CakeBlock.BITES);
                    offset = (float)bites * 0.1f;
                    if (bites < 6) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)CakeBlock.BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
                    } else {
                        level.removeBlock(pos, false);
                    }
                } else {
                    level.setBlock(pos, (BlockState)((Block)BuiltInRegistries.BLOCK.get(SLICES_TO_CAKES.get(cakeSlice))).defaultBlockState().setValue((Property)CakeBlock.BITES, (Comparable)Integer.valueOf(1)), 3);
                    Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
                }
                ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)cakeSlice.get()), (double)((float)pos.getX() + offset), (double)((float)pos.getY() + 0.2f), (double)((float)pos.getZ() + 0.5f), (double)-0.05f, (double)0.0, (double)0.0);
                level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        Player player = event.getPlayer();
        ArrayList loot = Lists.newArrayList();
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        if (player.getMainHandItem().is(ModTags.KNIVES) && name != null) {
            if (state.is(ADBlockTags.DROPS_YUCCA_GATEAU_SLICE)) {
                Optional<IntegerProperty> property = ADEvents.yuccaGateauBites(state);
                subtraction = property.map(arg_0 -> ((BlockState)state).getValue(arg_0)).orElse(0);
                loot.add(new ItemStack((ItemLike)ADItems.YUCCA_GATEAU_SLICE.get(), 10 - subtraction));
            } else if (state.is(ADBlockTags.DROPS_FLAVORED_CAKE_SLICE)) {
                Supplier<Item> cakeSlice = ADEvents.getCakeSlice(state);
                subtraction = !state.hasProperty((Property)CakeBlock.BITES) ? 0 : (Integer)state.getValue((Property)CakeBlock.BITES);
                loot.add(new ItemStack((ItemLike)cakeSlice.get(), 7 - subtraction));
            }
            if (!loot.isEmpty() && event.getLevel() instanceof Level) {
                for (ItemStack stack : loot) {
                    Block.popResource((Level)((Level)event.getLevel()), (BlockPos)event.getPos(), (ItemStack)stack);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack stack = event.getItemStack();
        if (target instanceof TamableAnimal) {
            TamableAnimal entity = (TamableAnimal)target;
            if (BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()).equals((Object)ADConstants.SLABFISH) && entity.isAlive() && entity.isTame() && stack.getItem().equals(ADItems.SLABDISH.get())) {
                entity.setHealth(entity.getMaxHealth());
                for (MobEffectInstance effect : SlabdishItem.EFFECTS) {
                    entity.addEffect(new MobEffectInstance(effect));
                }
                entity.level().playSound(null, target.blockPosition(), SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
                for (int i = 0; i < 5; ++i) {
                    double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                    entity.level().addParticle((ParticleOptions)ModParticleTypes.STAR.get(), entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), d0, d1, d2);
                }
                if (stack.getCraftingRemainingItem() != ItemStack.EMPTY && !player.isCreative()) {
                    player.addItem(stack.getCraftingRemainingItem());
                    stack.shrink(1);
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

