/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_delight.core.registry;

import com.teamabnormals.abnormals_delight.common.item.CakeSliceItem;
import com.teamabnormals.abnormals_delight.common.item.ContainerConsumableItem;
import com.teamabnormals.abnormals_delight.common.item.NectarItem;
import com.teamabnormals.abnormals_delight.common.item.SlabdishItem;
import com.teamabnormals.abnormals_delight.core.AbnormalsDelight;
import com.teamabnormals.abnormals_delight.core.other.ADConstants;
import com.teamabnormals.abnormals_delight.core.other.ADTiers;
import com.teamabnormals.abnormals_delight.core.registry.ADBlocks;
import com.teamabnormals.blueprint.core.util.item.CreativeModeTabContentsPopulator;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import vectorwing.farmersdelight.common.FoodValues;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.item.KnifeItem;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModCreativeTabs;
import vectorwing.farmersdelight.common.registry.ModEffects;
import vectorwing.farmersdelight.common.registry.ModItems;

public class ADItems {
    public static final ItemSubRegistryHelper ITEMS = (ItemSubRegistryHelper)AbnormalsDelight.REGISTRY_HELPER.getItemSubHelper();
    public static final DeferredItem<Item> SILVER_KNIFE = ITEMS.createItem("silver_knife", () -> new KnifeItem(ADTiers.SILVER, new Item.Properties()));
    public static final DeferredItem<Item> NECROMIUM_KNIFE = ITEMS.createItem("necromium_knife", () -> new KnifeItem(ADTiers.NECROMIUM, new Item.Properties().fireResistant()));
    public static final DeferredItem<Item> DUCK_FILLET = ITEMS.createItem("duck_fillet", () -> new Item(new Item.Properties().food(ADFoods.DUCK_FILLET)));
    public static final DeferredItem<Item> COOKED_DUCK_FILLET = ITEMS.createItem("cooked_duck_fillet", () -> new Item(new Item.Properties().food(ADFoods.COOKED_DUCK_FILLET)));
    public static final DeferredItem<Item> VENISON_SHANKS = ITEMS.createItem("venison_shanks", () -> new Item(new Item.Properties().food(ADFoods.VENISON_SHANKS)));
    public static final DeferredItem<Item> COOKED_VENISON_SHANKS = ITEMS.createItem("cooked_venison_shanks", () -> new Item(new Item.Properties().food(ADFoods.COOKED_VENISON_SHANKS)));
    public static final DeferredItem<Item> PIKE_SLICE = ITEMS.createItem("pike_slice", () -> new Item(new Item.Properties().food(ADFoods.PIKE_SLICE)));
    public static final DeferredItem<Item> COOKED_PIKE_SLICE = ITEMS.createItem("cooked_pike_slice", () -> new Item(new Item.Properties().food(ADFoods.COOKED_PIKE_SLICE)));
    public static final DeferredItem<Item> PERCH_SLICE = ITEMS.createItem("perch_slice", () -> new Item(new Item.Properties().food(ADFoods.PERCH_SLICE)));
    public static final DeferredItem<Item> COOKED_PERCH_SLICE = ITEMS.createItem("cooked_perch_slice", () -> new Item(new Item.Properties().food(ADFoods.COOKED_PERCH_SLICE)));
    public static final DeferredItem<Item> CHERRY_COOKIE = ITEMS.createItem("cherry_cookie", () -> new ConsumableItem(new Item.Properties().food(FoodValues.COOKIES)));
    public static final DeferredItem<Item> MULBERRY_COOKIE = ITEMS.createItem("mulberry_cookie", () -> new ConsumableItem(new Item.Properties().food(FoodValues.COOKIES)));
    public static final DeferredItem<Item> MAPLE_COOKIE = ITEMS.createItem("maple_cookie", () -> new ConsumableItem(new Item.Properties().food(FoodValues.COOKIES)));
    public static final DeferredItem<Item> SEARED_VENISON = ITEMS.createItem("seared_venison", () -> new ConsumableItem(new Item.Properties().craftRemainder(Items.BOWL).food(ADFoods.SEARED_VENISON).stacksTo(16)));
    public static final DeferredItem<Item> PASSION_FRUIT_GLAZED_DUCK = ITEMS.createItem("passion_fruit_glazed_duck", () -> new ConsumableItem(new Item.Properties().craftRemainder(Items.BOWL).food(ADFoods.PASSION_FRUIT_GLAZED_DUCK).stacksTo(16)));
    public static final DeferredItem<Item> DUNE_PLATTER = ITEMS.createItem("dune_platter", () -> new ConsumableItem(new Item.Properties().craftRemainder(Items.BOWL).food(ADFoods.DUNE_PLATTER).stacksTo(16)));
    public static final DeferredItem<Item> DUCK_NOODLES = ITEMS.createItem("duck_noodles", () -> new ConsumableItem(new Item.Properties().craftRemainder(Items.BOWL).food(ADFoods.DUCK_NOODLES).stacksTo(16)));
    public static final DeferredItem<Item> PERCH_WITH_MUSHROOMS = ITEMS.createItem("perch_with_mushrooms", () -> new ConsumableItem(new Item.Properties().craftRemainder(Items.BOWL).food(ADFoods.PERCH_WITH_MUSHROOMS).stacksTo(16)));
    public static final DeferredItem<Item> PIKE_WITH_BEETROOT = ITEMS.createItem("pike_with_beetroot", () -> new ConsumableItem(new Item.Properties().craftRemainder(Items.BOWL).food(ADFoods.PIKE_WITH_BEETROOT).stacksTo(16)));
    public static final DeferredItem<Item> VENISON_WITH_BAMBOO_SHOOTS = ITEMS.createItem("venison_with_bamboo_shoots", () -> new ConsumableItem(new Item.Properties().craftRemainder(Items.BOWL).food(ADFoods.VENISON_WITH_BAMBOO_SHOOTS).stacksTo(16)));
    public static final DeferredItem<Item> MAPLE_GLAZED_BACON = ITEMS.createItem("maple_glazed_bacon", () -> new Item(new Item.Properties().food(ADFoods.MAPLE_GLAZED_BACON)));
    public static final DeferredItem<Item> ESCARGOT = ITEMS.createItem("escargot", () -> new ContainerConsumableItem(ADConstants.SNAIL_SHELL_PIECE, new Item.Properties().food(ADFoods.ESCARGOT).stacksTo(16)));
    public static final DeferredItem<Item> SLABDISH = ITEMS.createItem("slabdish", () -> new SlabdishItem(new Item.Properties().craftRemainder(Items.BOWL).food(ADFoods.SLABDISH).stacksTo(16)));
    public static final DeferredItem<Item> CHERRY_CREAM_SODA = ITEMS.createItem("cherry_cream_soda", () -> new DrinkableItem(ModItems.drinkItem().food(ADFoods.CHERRY_CREAM_SODA), true, false));
    public static final DeferredItem<Item> PASSION_ALOE_NECTAR = ITEMS.createItem("passion_aloe_nectar", () -> new NectarItem(ModItems.drinkItem()));
    public static final DeferredItem<Item> PICKERELWEED_JUICE = ITEMS.createItem("pickerelweed_juice", () -> new DrinkableItem(ModItems.drinkItem().food(ADFoods.PICKERELWEED_JUICE), true, false));
    public static final DeferredItem<Item> VANILLA_CAKE_SLICE = ITEMS.createItem("vanilla_cake_slice", () -> new CakeSliceItem(ADConstants.VANILLA_SCENT, 100, new Item.Properties().food(ADFoods.CAKE_SLICE)));
    public static final DeferredItem<Item> CHOCOLATE_CAKE_SLICE = ITEMS.createItem("chocolate_cake_slice", () -> new CakeSliceItem(ADConstants.SUGAR_RUSH, 200, new Item.Properties().food(ADFoods.CAKE_SLICE)));
    public static final DeferredItem<Item> STRAWBERRY_CAKE_SLICE = ITEMS.createItem("strawberry_cake_slice", () -> new CakeSliceItem(new Item.Properties().food(ADFoods.CAKE_SLICE)));
    public static final DeferredItem<Item> BANANA_CAKE_SLICE = ITEMS.createItem("banana_cake_slice", () -> new CakeSliceItem(ADConstants.AGILITY, 200, new Item.Properties().food(ADFoods.CAKE_SLICE)));
    public static final DeferredItem<Item> MINT_CAKE_SLICE = ITEMS.createItem("mint_cake_slice", () -> new CakeSliceItem(ADConstants.BERSERKING, 300, new Item.Properties().food(ADFoods.CAKE_SLICE)));
    public static final DeferredItem<Item> ADZUKI_CAKE_SLICE = ITEMS.createItem("adzuki_cake_slice", () -> new CakeSliceItem(ADConstants.HARMONY, 200, new Item.Properties().food(ADFoods.CAKE_SLICE)));
    public static final DeferredItem<Item> YUCCA_GATEAU_SLICE = ITEMS.createItem("yucca_gateau_slice", () -> new CakeSliceItem(ADConstants.PERSISTENCE, 320, new Item.Properties().food(ADFoods.YUCCA_GATEAU_SLICE)));

    public static void setupTabEditors() {
        CreativeModeTabContentsPopulator.mod((String)"abnormals_delight").tab(ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"farmersdelight"))).addItemsAfter(ADItems.modLoaded(ModItems.GOLDEN_KNIFE, "caverns_and_chasms"), new Supplier[]{SILVER_KNIFE}).addItemsAfter(ADItems.modLoaded(ModItems.NETHERITE_KNIFE, "caverns_and_chasms"), new Supplier[]{NECROMIUM_KNIFE}).addItemsAfter(ADItems.modLoaded(ModItems.CAKE_SLICE, "environmental"), new Supplier[]{YUCCA_GATEAU_SLICE}).addItemsAfter(ADItems.modLoaded(ModItems.CAKE_SLICE, "neapolitan"), new Supplier[]{VANILLA_CAKE_SLICE, CHOCOLATE_CAKE_SLICE, STRAWBERRY_CAKE_SLICE, BANANA_CAKE_SLICE, MINT_CAKE_SLICE, ADZUKI_CAKE_SLICE}).addItemsAfter(ADItems.modLoaded(ModItems.SWEET_BERRY_COOKIE, "upgrade_aquatic"), new Supplier[]{MULBERRY_COOKIE}).addItemsAfter(ADItems.modLoaded(ModItems.SWEET_BERRY_COOKIE, "environmental"), new Supplier[]{CHERRY_COOKIE}).addItemsAfter(ADItems.modLoaded(ModItems.HONEY_COOKIE, "autumnity"), new Supplier[]{MAPLE_COOKIE}).addItemsAfter(ADItems.modLoaded(ModItems.COOKED_CHICKEN_CUTS, "environmental"), new Supplier[]{DUCK_FILLET, COOKED_DUCK_FILLET}).addItemsAfter(ADItems.modLoaded(ModItems.COOKED_BACON, "environmental"), new Supplier[]{VENISON_SHANKS, COOKED_VENISON_SHANKS}).addItemsAfter(ADItems.modLoaded(ModItems.COOKED_BACON, "autumnity"), new Supplier[]{MAPLE_GLAZED_BACON}).addItemsAfter(ADItems.modLoaded(ModItems.COOKED_SALMON_SLICE, "upgrade_aquatic"), new Supplier[]{PIKE_SLICE, COOKED_PIKE_SLICE, PERCH_SLICE, COOKED_PERCH_SLICE}).addItemsAfter(ADItems.modLoaded(ModItems.HORSE_FEED, "environmental"), new Supplier[]{SLABDISH}).addItemsAfter(ADItems.modLoaded(ModItems.MELON_JUICE, "upgrade_aquatic"), new Supplier[]{PICKERELWEED_JUICE}).addItemsAfter(ADItems.modLoaded(ModItems.MELON_JUICE, "environmental"), new Supplier[]{CHERRY_CREAM_SODA}).addItemsAfter(ADItems.modLoaded(ModItems.MELON_JUICE, "atmospheric"), new Supplier[]{PASSION_ALOE_NECTAR}).addItemsAfter(ADItems.modLoaded(ModItems.KELP_ROLL_SLICE, "autumnity"), new Supplier[]{ESCARGOT}).addItemsAfter(ADItems.modLoaded(ModItems.GRILLED_SALMON, "upgrade_aquatic"), new Supplier[]{PIKE_WITH_BEETROOT, PERCH_WITH_MUSHROOMS}).addItemsAfter(ADItems.modLoaded(ModItems.GRILLED_SALMON, "environmental"), new Supplier[]{DUCK_NOODLES, SEARED_VENISON, VENISON_WITH_BAMBOO_SHOOTS}).addItemsAfter(ADItems.modLoaded(ModItems.GRILLED_SALMON, "atmospheric", "environmental"), new Supplier[]{PASSION_FRUIT_GLAZED_DUCK}).addItemsAfter(ADItems.modLoaded(ModItems.GRILLED_SALMON, "atmospheric"), new Supplier[]{DUNE_PLATTER}).addItemsBefore(ADItems.modLoaded(ModItems.BAMBOO_CABINET, "atmospheric"), new Supplier[]{ADBlocks.ROSEWOOD_CABINET, ADBlocks.MORADO_CABINET, ADBlocks.YUCCA_CABINET, ADBlocks.LAUREL_CABINET, ADBlocks.ASPEN_CABINET, ADBlocks.KOUSA_CABINET, ADBlocks.GRIMWOOD_CABINET}).addItemsBefore(ADItems.modLoaded(ModItems.BAMBOO_CABINET, "autumnity"), new Supplier[]{ADBlocks.MAPLE_CABINET}).addItemsBefore(ADItems.modLoaded(ModItems.BAMBOO_CABINET, "caverns_and_chasms"), new Supplier[]{ADBlocks.AZALEA_CABINET}).addItemsBefore(ADItems.modLoaded(ModItems.BAMBOO_CABINET, "environmental"), new Supplier[]{ADBlocks.WILLOW_CABINET, ADBlocks.PINE_CABINET, ADBlocks.PLUM_CABINET, ADBlocks.WISTERIA_CABINET}).addItemsBefore(ADItems.modLoaded(ModItems.BAMBOO_CABINET, "upgrade_aquatic"), new Supplier[]{ADBlocks.DRIFTWOOD_CABINET, ADBlocks.RIVER_CABINET}).addItemsAfter(ADItems.modLoaded(ModItems.WARPED_CABINET, "endergetic"), new Supplier[]{ADBlocks.POISE_CABINET});
    }

    public static void setupReplaceTabEditor() {
        CreativeModeTabContentsPopulator.mod((String)"z_abnormals_delight").predicate(event -> ADItems.modPredicate(event, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS)).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.CAKE}), new Supplier[]{ModItems.CAKE_SLICE}).addItemsAfter(ADItems.ofID(ADConstants.VANILLA_CAKE, new String[0]), new Supplier[]{VANILLA_CAKE_SLICE}).addItemsAfter(ADItems.ofID(ADConstants.CHOCOLATE_CAKE, new String[0]), new Supplier[]{CHOCOLATE_CAKE_SLICE}).addItemsAfter(ADItems.ofID(ADConstants.STRAWBERRY_CAKE, new String[0]), new Supplier[]{STRAWBERRY_CAKE_SLICE}).addItemsAfter(ADItems.ofID(ADConstants.BANANA_CAKE, new String[0]), new Supplier[]{BANANA_CAKE_SLICE}).addItemsAfter(ADItems.ofID(ADConstants.MINT_CAKE, new String[0]), new Supplier[]{MINT_CAKE_SLICE}).addItemsAfter(ADItems.ofID(ADConstants.ADZUKI_CAKE, new String[0]), new Supplier[]{ADZUKI_CAKE_SLICE}).predicate(event -> ADItems.modPredicate(event, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES)).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL}), new Supplier[]{ModItems.FLINT_KNIFE}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_HOE}), new Supplier[]{ModItems.IRON_KNIFE}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_HOE}), new Supplier[]{ModItems.GOLDEN_KNIFE}).addItemsAfter(ADItems.ofID(ADConstants.SILVER_HOE, new String[0]), new Supplier[]{SILVER_KNIFE}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND_HOE}), new Supplier[]{ModItems.DIAMOND_KNIFE}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_HOE}), new Supplier[]{ModItems.NETHERITE_KNIFE}).addItemsAfter(ADItems.ofID(ADConstants.NECROMIUM_HOE, new String[0]), new Supplier[]{NECROMIUM_KNIFE}).predicate(event -> ADItems.modPredicate(event, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT)).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.TRIDENT}), new Supplier[]{ModItems.FLINT_KNIFE, ModItems.IRON_KNIFE, ModItems.GOLDEN_KNIFE}).addItemsBefore(ADItems.modLoaded((ItemLike)Items.TRIDENT, "caverns_and_chasms"), new Supplier[]{SILVER_KNIFE}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.TRIDENT}), new Supplier[]{ModItems.DIAMOND_KNIFE, ModItems.NETHERITE_KNIFE}).addItemsBefore(ADItems.modLoaded((ItemLike)Items.TRIDENT, "caverns_and_chasms"), new Supplier[]{NECROMIUM_KNIFE}).predicate(event -> ADItems.modPredicate(event, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS)).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BARREL}), new Supplier[]{ModBlocks.OAK_CABINET, ModBlocks.SPRUCE_CABINET, ModBlocks.BIRCH_CABINET, ModBlocks.JUNGLE_CABINET, ModBlocks.ACACIA_CABINET, ModBlocks.DARK_OAK_CABINET, ModBlocks.MANGROVE_CABINET, ModBlocks.CHERRY_CABINET}).addItemsBefore(ADItems.modLoaded((ItemLike)Items.BARREL, "farmersdelight"), new Supplier[]{ADBlocks.ROSEWOOD_CABINET, ADBlocks.MORADO_CABINET, ADBlocks.YUCCA_CABINET, ADBlocks.LAUREL_CABINET, ADBlocks.ASPEN_CABINET, ADBlocks.KOUSA_CABINET, ADBlocks.GRIMWOOD_CABINET}).addItemsBefore(ADItems.modLoaded((ItemLike)Items.BARREL, "farmersdelight"), new Supplier[]{ADBlocks.MAPLE_CABINET}).addItemsBefore(ADItems.modLoaded((ItemLike)Items.BARREL, "farmersdelight"), new Supplier[]{ADBlocks.AZALEA_CABINET}).addItemsBefore(ADItems.modLoaded((ItemLike)Items.BARREL, "farmersdelight"), new Supplier[]{ADBlocks.WILLOW_CABINET, ADBlocks.PINE_CABINET, ADBlocks.PLUM_CABINET, ADBlocks.WISTERIA_CABINET}).addItemsBefore(ADItems.modLoaded((ItemLike)Items.BARREL, "farmersdelight"), new Supplier[]{ADBlocks.DRIFTWOOD_CABINET, ADBlocks.RIVER_CABINET}).addItemsBefore(ADItems.modLoaded((ItemLike)Items.BARREL, new String[0]), new Supplier[]{ModBlocks.BAMBOO_CABINET, ModBlocks.CRIMSON_CABINET, ModBlocks.WARPED_CABINET}).addItemsBefore(ADItems.modLoaded((ItemLike)Items.BARREL, "farmersdelight"), new Supplier[]{ADBlocks.POISE_CABINET});
    }

    public static Predicate<ItemStack> modLoaded(ItemLike item, String ... modids) {
        return stack -> Ingredient.of((ItemLike[])new ItemLike[]{item}).test(stack) && BlockSubRegistryHelper.areModsLoaded((String[])modids);
    }

    public static Predicate<ItemStack> modLoaded(DeferredItem<Item> item, String ... modids) {
        return stack -> item.get() != null && Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()}).test(stack) && BlockSubRegistryHelper.areModsLoaded((String[])modids);
    }

    public static Predicate<ItemStack> modLoaded(Supplier<Item> item, String ... modids) {
        return stack -> item.get() != null && Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()}).test(stack) && BlockSubRegistryHelper.areModsLoaded((String[])modids);
    }

    public static Predicate<ItemStack> ofID(ResourceLocation location, String ... modids) {
        return stack -> BlockSubRegistryHelper.areModsLoaded((String[])modids) && Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(location)}).test(stack);
    }

    public static boolean fdGroupPredicate(BuildCreativeModeTabContentsEvent event) {
        return event.getTab() == ModCreativeTabs.TAB_FARMERS_DELIGHT;
    }

    public static boolean modPredicate(BuildCreativeModeTabContentsEvent event, ResourceKey<CreativeModeTab> tab) {
        return event.getTabKey() == tab;
    }

    public static class ADFoods {
        public static final FoodProperties CHERRY_CREAM_SODA = new FoodProperties.Builder().alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.SLOW_FALLING, 300, 0), 1.0f).build();
        public static final FoodProperties PICKERELWEED_JUICE = new FoodProperties.Builder().alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.WATER_BREATHING, 300, 0), 1.0f).build();
        public static final FoodProperties DUCK_FILLET = new FoodProperties.Builder().nutrition(2).saturationModifier(0.1f).effect(() -> new MobEffectInstance(MobEffects.HUNGER, 600, 0), 0.3f).fast().build();
        public static final FoodProperties COOKED_DUCK_FILLET = new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).fast().build();
        public static final FoodProperties VENISON_SHANKS = new FoodProperties.Builder().nutrition(1).saturationModifier(0.3f).fast().build();
        public static final FoodProperties COOKED_VENISON_SHANKS = new FoodProperties.Builder().nutrition(3).saturationModifier(0.8f).fast().build();
        public static final FoodProperties PIKE_SLICE = new FoodProperties.Builder().nutrition(1).saturationModifier(0.3f).effect(() -> new MobEffectInstance(MobEffects.HUNGER, 600, 0), 0.3f).fast().build();
        public static final FoodProperties COOKED_PIKE_SLICE = new FoodProperties.Builder().nutrition(4).saturationModifier(0.8f).fast().build();
        public static final FoodProperties PERCH_SLICE = new FoodProperties.Builder().nutrition(1).saturationModifier(0.2f).effect(() -> new MobEffectInstance(MobEffects.HUNGER, 600, 0), 0.3f).fast().build();
        public static final FoodProperties COOKED_PERCH_SLICE = new FoodProperties.Builder().nutrition(2).saturationModifier(0.7f).fast().build();
        public static final FoodProperties SEARED_VENISON = new FoodProperties.Builder().nutrition(12).saturationModifier(0.9f).effect(() -> new MobEffectInstance(ModEffects.NOURISHMENT, 6000, 0), 1.0f).build();
        public static final FoodProperties PASSION_FRUIT_GLAZED_DUCK = new FoodProperties.Builder().nutrition(14).saturationModifier(0.9f).effect(() -> new MobEffectInstance(ModEffects.NOURISHMENT, 6000, 0), 1.0f).build();
        public static final FoodProperties DUNE_PLATTER = new FoodProperties.Builder().nutrition(10).saturationModifier(0.8f).effect(() -> new MobEffectInstance(ModEffects.NOURISHMENT, 3600, 0), 1.0f).build();
        public static final FoodProperties DUCK_NOODLES = new FoodProperties.Builder().nutrition(12).saturationModifier(0.8f).effect(() -> new MobEffectInstance(ModEffects.NOURISHMENT, 6000, 0), 1.0f).build();
        public static final FoodProperties PERCH_WITH_MUSHROOMS = new FoodProperties.Builder().nutrition(14).saturationModifier(0.9f).effect(() -> new MobEffectInstance(ModEffects.NOURISHMENT, 6000, 0), 1.0f).build();
        public static final FoodProperties PIKE_WITH_BEETROOT = new FoodProperties.Builder().nutrition(9).saturationModifier(0.7f).effect(() -> new MobEffectInstance(ModEffects.NOURISHMENT, 1200, 0), 1.0f).build();
        public static final FoodProperties VENISON_WITH_BAMBOO_SHOOTS = new FoodProperties.Builder().nutrition(11).saturationModifier(0.9f).effect(() -> new MobEffectInstance(ModEffects.NOURISHMENT, 6000, 0), 1.0f).build();
        public static final FoodProperties SLABDISH = new FoodProperties.Builder().nutrition(4).saturationModifier(0.2f).effect(() -> new MobEffectInstance(MobEffects.CONFUSION, 600), 1.0f).build();
        public static final FoodProperties MAPLE_GLAZED_BACON = new FoodProperties.Builder().nutrition(6).saturationModifier(0.8f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600), 1.0f).build();
        public static final FoodProperties ESCARGOT = new FoodProperties.Builder().nutrition(8).saturationModifier(0.5f).build();
        public static final FoodProperties CAKE_SLICE = new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 400, 0), 1.0f).build();
        public static final FoodProperties YUCCA_GATEAU_SLICE = new FoodProperties.Builder().nutrition(1).saturationModifier(0.0f).fast().effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 400, 0), 1.0f).build();
    }
}

